<?php echo $__env->make('backend/include/custom', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

  <!--favicon-->

  <?php echo $__env->make('backend/include/head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('backend/include/datatableajax/tablelink', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


  <title>Product Single View Page</title>
</head>

<body>
  <!--wrapper-->
  <div class="wrapper">
    <!--sidebar wrapper -->
    <?php echo $__env->make('backend/include/sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--end sidebar wrapper -->
    <!--start header -->
    <?php echo $__env->make('backend/include/header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--end header -->

    <!--start page wrapper -->
<div class="page-wrapper">
      <div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
        <div class="breadcrumb-title d-flex align-items-center ms-3">
          <i class="bx bx-package  me-1"></i>
          <span>Product Single View Page</span>
        </div>
      </div>
<div class="container my-5 product-page">
    <div class="card shadow-sm p-4">
        <div class="row g-4">
            <!-- Left: Image Gallery -->
            <div class="col-md-5">
                <?php
                    $multipleImages = json_decode($productdata->multiple_image, true);
                    $allImages = !empty($multipleImages) ? array_merge([$productdata->image], $multipleImages) : [$productdata->image];
                ?>

                <div class="d-flex" style="height: 350px;">
                    <!-- Vertical Thumbnails -->
                    <div class="me-3 d-flex flex-column gap-3 thumbnails-container">
                        <?php $__currentLoopData = $allImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <img 
                                src="<?php echo e(asset('uploads/product/' . $img)); ?>" 
                                width="60" height="60" 
                                class="thumb-image border rounded <?php echo e($index === 0 ? 'selected' : ''); ?>" 
                                onclick="setImage(<?php echo e($index); ?>)"
                                alt="Thumbnail">
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <!-- Main Image with Prev/Next -->
                    <div class="position-relative border rounded flex-grow-1 main-image-container">
                        <a id="mainImageLink" href="<?php echo e(asset('uploads/product/' . $allImages[0])); ?>" data-fancybox="gallery">
                            <img 
                                id="mainPreview" 
                                src="<?php echo e(asset('uploads/product/' . $allImages[0])); ?>" 
                                class="img-fluid main-image" 
                                alt="Main Image">
                        </a>

        <button onclick="changeImage(-1)" 
                class="position-absolute top-50 start-0 translate-middle-y"
                style="z-index: 2; background: transparent; border: none; font-size: 2rem; color: white;">
            <i class='bx bx-chevron-left'></i>
        </button>

        <!-- Next Button -->
        <button onclick="changeImage(1)" 
                class="position-absolute top-50 end-0 translate-middle-y"
                style="z-index: 2; background: transparent; border: none; font-size: 2rem; color: white;">
            <i class='bx bx-chevron-right'></i>
        </button>
                    </div>
                </div>

                <!-- Hidden Fancybox Links -->
                <?php $__currentLoopData = $allImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($index != 0): ?>
                        <a href="<?php echo e(asset('uploads/product/' . $img)); ?>" data-fancybox="gallery" style="display: none;"></a>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Right: Product Details -->
<div class="col-md-7 product-details">

    
    <h3 class="mb-3 ms-1 product-title"><?php echo e($productdata->product_item); ?></h3>

    
    <div class="mb-4 ps-1">
        <h4 class="fw-bold text-dark d-flex align-items-end flex-wrap">
            ₹<?php echo e($productdata->default_price); ?>


            <span class="d-flex flex-column align-items-start ms-3" style="line-height: 1;">
                <small class="text-muted" style="font-size: 0.75rem;">MRP</small>
                <small class="text-decoration-line-through text-danger">₹<?php echo e($productdata->mrp_price); ?></small>
            </span>
        </h4>
    </div>

    
    <?php
        $serviceName = \App\Models\Service::where('id', $productdata->service_id)->value('title');
        $subserviceName = \App\Models\Subservice::where('id', $productdata->subservice_id)->value('title');
        $brandName = \App\Models\Brand::where('id', $productdata->brand_id)->value('brand_name');
    ?>

    <div class="row g-3 mb-4">
        <div class="col-sm-6">
            <div class="border rounded p-3 bg-white shadow-sm h-100">
                <small class="text-muted">Service</small>
                <div class="fw-semibold"><?php echo e($serviceName); ?></div>
            </div>
        </div>

        <div class="col-sm-6">
            <div class="border rounded p-3 bg-white shadow-sm h-100">
                <small class="text-muted">Sub Service</small>
                <div class="fw-semibold"><?php echo e($subserviceName); ?></div>
            </div>
        </div>

        <div class="col-sm-6">
            <div class="border rounded p-3 bg-white shadow-sm h-100">
                <small class="text-muted">Brand</small>
                <div class="fw-semibold"><?php echo e($brandName ?? 'NA'); ?></div>
            </div>
        </div>

        <div class="col-sm-6">
            <div class="border rounded p-3 bg-white shadow-sm h-100">
                <small class="text-muted">Image Description</small>
                <div class="fw-semibold"><?php echo e($productdata->img_description); ?></div>
            </div>
        </div>
    </div>

    
    <!--
    <!--<div class="d-flex align-items-center gap-3 mb-3">-->
    <!--    <div class="d-flex align-items-center border rounded px-2">-->
    <!--        <button class="btn btn-outline-secondary btn-sm" onclick="decrementQty()">−</button>-->
    <!--        <input type="text" class="form-control text-center mx-2 qty-input border-0" value="1" style="width: 60px;">-->
    <!--        <button class="btn btn-outline-secondary btn-sm" onclick="incrementQty()">+</button>-->
    <!--    </div>-->

    <!--    <button class="btn btn-warning px-4">Add to Cart</button>-->
    <!--    <button class="btn btn-outline-danger"><i class="fa fa-heart"></i></button>-->
    <!--</div>-->

</div>

        </div>

<!-- Tabs Section -->
<div class="mt-5">

    <!-- Tab Navigation -->
    <ul class="nav nav-tabs border-bottom border-2 mb-0" role="tablist">
        <li class="nav-item">
            <a class="nav-link active text-dark fw-semibold" data-bs-toggle="tab" href="#desc" role="tab">
                Description
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark fw-semibold" data-bs-toggle="tab" href="#meta" role="tab">
                Meta Tags
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark fw-semibold" data-bs-toggle="tab" href="#reviews" role="tab">
                Reviews
            </a>
        </li>
    </ul>

    <!-- Tab Contents in Box Style -->
    <div class="tab-content bg-transparent p-0">

        <!-- Description Box -->
        <div class="tab-pane fade show active" id="desc" role="tabpanel">
            <div class="bg-white border rounded p-4 mt-3">
                <div><?php echo $productdata->description; ?></div>
            </div>
        </div>

        <!-- Meta Tags Box -->
        <div class="tab-pane fade" id="meta" role="tabpanel">
            <div class="bg-white border rounded p-4 mt-3">
                <ul class="list-unstyled mb-0">
                    <li class="mb-2"><strong>Meta Title:</strong> <?php echo e($productdata->meta_title); ?></li>
                    <li class="mb-2"><strong>Meta Keywords:</strong> <?php echo e($productdata->meta_keyword); ?></li>
                    <li><strong>Meta Description:</strong> <?php echo e($productdata->meta_description); ?></li>
                </ul>
            </div>
        </div>

        <!-- Reviews Box -->
        <div class="tab-pane fade" id="reviews" role="tabpanel">
            <div class="bg-white border rounded p-4 mt-3">
                <p class="text-secondary">NA</p>
            </div>
        </div>

    </div>
</div>

    </div>
</div>

  </div>
</div>


   


    




    <?php echo $__env->make('backend/include/footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('backend/include/datatableajax/tablescript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

<script>
    let allImages = <?php echo json_encode($allImages, 15, 512) ?>;
    let currentIndex = 0;

    function changeImage(direction) {
        currentIndex += direction;

        if (currentIndex < 0) currentIndex = allImages.length - 1;
        if (currentIndex >= allImages.length) currentIndex = 0;

        updateMainImage();
    }

    function setImage(index) {
        currentIndex = index;
        updateMainImage();
    }

    function updateMainImage() {
        let newSrc = "<?php echo e(asset('uploads/product')); ?>/" + allImages[currentIndex];

        // Update image
        document.getElementById('mainPreview').src = newSrc;

        // Update Fancybox link
        const link = document.getElementById('mainImageLink');
        link.href = newSrc;
        link.setAttribute('');
    }
</script>

</body>

</html>
<?php /**PATH /home/uatlocalpintu/public_html/resources/views/backend/product/productsingleview.blade.php ENDPATH**/ ?>