<?php echo $__env->make('backend/include/custom', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

<!--favicon-->

<?php echo $__env->make('backend/include/head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('backend/include/datatableajax/tablelink', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<title>Product Update</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
<?php echo $__env->make('backend/include/sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>	
<!--end sidebar wrapper -->
<!--start header -->
<?php echo $__env->make('backend/include/header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>	
<!--end header -->



<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1" >
    <div class="breadcrumb-title d-flex align-items-center ms-3 " >
        <i class="bx bx-package me-1"></i>
        <span class="">Product Update</span>
    </div>
</div>

 
<div class="page-content">
   <div class="row">
					<div class="col-xl-12 mx-auto">
						<div class="card">
						
						
							<div class="card-body">
  <form class="row g-3 needs-validation" onsubmit="return myckediter()" id="formatDistrict-update" method="POST" action="<?php echo e(asset('backend/promocodeupdate/' . Crypt::encrypt($promocode->id))); ?>" enctype="multipart/form-data" novalidate>
    <?php echo csrf_field(); ?>
    <section class="mb-4">
<div class="row g-3"> <!-- Added spacing between inputs -->

    <!-- Title -->
    <div class="col-md-4">
        <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
        <input type="text" class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($promocode->title); ?>" id="title" name="title" required>
    </div>

    <!-- Promocode Type -->
    <div class="col-md-4">
        <label for="promocode_type" class="form-label">Promocode Type <span class="text-danger">*</span></label>
        <select class="form-select" id="promocode_type" name="promocode_type" required>
            <option value="">Select Option</option>
            <option value="1" <?php echo e($promocode->promocode_type == 1 ? 'selected' : ''); ?>>Fixed Price</option>
<option value="2" <?php echo e($promocode->promocode_type == 2 ? 'selected' : ''); ?>>Percentage</option>

        </select>
    </div>

    <!-- Price / Percentage -->
    <div class="col-md-4">
        <label for="pricr_per" class="form-label">Price & Percentage <span class="text-danger">*</span></label>
        <input type="text" class="form-control" id="pricr_per" value="<?php echo e($promocode->pricr_per); ?>" name="pricr_per" required oninput="this.value = this.value.replace(/[^0-9]/g, '')">
    </div>

    <!-- Promocode -->
    <div class="col-md-4">
        <label for="promocode" class="form-label">Promocode <span class="text-danger">*</span></label>
        <input type="text" class="form-control" id="promocode" value="<?php echo e($promocode->promocode); ?>" name="promocode" required>
    </div>

    <!-- Use Range Limit -->
    <div class="col-md-4">
        <label for="use_range" class="form-label">Use Range Limit <span class="text-danger">*</span></label>
        <input type="text" class="form-control" id="use_range" value="<?php echo e($promocode->use_range); ?>" name="use_range" required oninput="this.value = this.value.replace(/[^0-9]/g, '')">
    </div>

    <!-- User Range Limit -->
    <div class="col-md-4">
        <label for="user_range" class="form-label">User Range Limit <span class="text-danger">*</span></label>
        <input type="text" class="form-control" id="user_range" value="<?php echo e($promocode->user_range); ?>" name="user_range" required oninput="this.value = this.value.replace(/[^0-9]/g, '')">
    </div>

    <!-- Start Date -->
    <div class="col-md-4">
        <label for="startdate" class="form-label">Valid Start Date <span class="text-danger">*</span></label>
        <input type="text" id="startdate" class="form-control datepicker" value="<?php echo e($promocode->startdate); ?>" name="startdate" required />
    </div>

    <!-- End Date -->
    <div class="col-md-4">
        <label for="enddate" class="form-label">Valid End Date <span class="text-danger">*</span></label>
        <input type="text" id="enddate" class="form-control datepicker" value="<?php echo e($promocode->enddate); ?>" name="enddate" required />
    </div>

    <!-- Ordering By -->
    <div class="col-md-4">
        <label for="ordering_by" class="form-label">Ordering By</label>
        <input type="number" class="form-control" id="ordering_by" value="<?php echo e($promocode->ordering_by); ?>" name="ordering_by">
    </div>

    <!-- Countries -->
    <div class="col-md-3">
        <label for="countries" class="form-label">Countries</label>
        <select class="form-select" name="countries" id="countries">
            <option value="">Select Countries</option>
        <?php $__currentLoopData = $country; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $countryData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($countryData->countries_id); ?>" <?php if($countryData->countries_id == $promocode->countries): ?> selected <?php endif; ?>>
                <?php echo e($countryData->name); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <!-- State -->
    <div class="col-md-3">
        <label for="state" class="form-label">State</label>
        <select name="state" class="form-select" id="state">
         <option value="">Select State</option>
        <?php
            $states = DB::table('tbl_states')
                ->where('country_id', $promocode->countries)
                ->where('s_status', '1')
                ->get();
        ?>
        <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stateData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($stateData->state_id); ?>" 
                <?php if($promocode->state ==$stateData->state_id  ): ?> selected <?php endif; ?>>
                <?php echo e($stateData->name); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </select>
    </div>

    <!-- City -->
    <div class="col-md-3">
        <label for="city" class="form-label">City</label>
        <select name="city" class="form-select" id="city">
             <option value="">Select City</option>
             <?php
            $city = DB::table('tbl_cities')->where('stateid', $promocode->state)->where('city_status', '1')
                ->get();
        ?>
        
         <?php $__currentLoopData = $city; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cityData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($cityData->city_id); ?>" 
                <?php if($promocode->city ==$cityData->city_id  ): ?> selected <?php endif; ?>>
                <?php echo e($cityData->name); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
       
        </select>
    </div>

    <!-- Pincode -->
 <div class="col-md-3">
    <label for="pincode" class="form-label">Pincode</label>
    <select name="pincode" class="form-select" id="pincode">
        <option value="">Select Pincode</option>
        <?php
            $pincodes = DB::table('pincodes')
                ->where('city', $promocode->city)
                ->where('status', '1')
                ->get();
        ?>

        <?php $__currentLoopData = $pincodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pincodeData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($pincodeData->id); ?>" 
                <?php if($promocode->pincode == $pincodeData->id): ?> selected <?php endif; ?>>
                <?php echo e($pincodeData->pincode); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>


    <!-- Service -->
   <div class="col-md-3">
    <label for="service_id" class="form-label">Service</label>
    <select class="form-select" name="service_id" id="service_id">
        <option value="">Select Service</option>
        <?php
            // Page load par selected city ke services populate
            $serviceIds = DB::table('serviceallottedcities')->where('countries_id', $promocode->countries)->where('state_id', $promocode->state)->where('city_id', $promocode->city)->where('status','1') ->where('service_type', '1') ->pluck('serviceid');

            $services = DB::table('services')->whereIn('id', $serviceIds)->where('status', '1')->select('id', 'title')->get();
        ?>

        <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($service->id); ?>" 
                <?php if($promocode->service_id == $service->id): ?> selected <?php endif; ?>>
                <?php echo e($service->title); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>

    <!-- Subservice -->
   <div class="col-md-3">
    <label for="subservice_id" class="form-label">Subservice</label>
    <select name="subservice_id" class="form-select" id="subservice_id">
        <option value="">Select Subservice</option>
        <?php if($promocode->service_id): ?>
            <?php
                $subserviceIds = DB::table('subservices')->where('service_id', $promocode->service_id)->where('status','1')->pluck('id');

                $allowedSubserviceIds = DB::table('serviceallottedcities')
                    ->where('countries_id', $promocode->countries)
                    ->where('state_id', $promocode->state)
                    ->where('city_id', $promocode->city)
                    ->where('status','1')
                    ->where('service_type','2')
                    ->whereIn('serviceid',$subserviceIds)
                    ->pluck('serviceid');

                $subservices = DB::table('subservices')->whereIn('id', $allowedSubserviceIds)->get();
            ?>

            <?php $__currentLoopData = $subservices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($sub->id); ?>" 
                    <?php if($promocode->subservice_id == $sub->id): ?> selected <?php endif; ?>>
                    <?php echo e($sub->title); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </select>
</div>

<!-- Child Service -->
<div class="col-md-3">
    <label for="childservice_id" class="form-label">Child Service</label>
    <select name="childservice_id" class="form-select" id="childservice_id">
        <option value="">Select Child Service</option>
        <?php if($promocode->subservice_id): ?>
            <?php
                $childIds = DB::table('child_services')->where('subservice_id', $promocode->subservice_id)->where('status','1')->pluck('id');

                $allowedChildIds = DB::table('serviceallottedcities')
                    ->where('countries_id', $promocode->countries)
                    ->where('state_id', $promocode->state)
                    ->where('city_id', $promocode->city)
                    ->where('status','1')
                    ->where('service_type','3')
                    ->whereIn('serviceid',$childIds)
                    ->pluck('serviceid');

                $childservices = DB::table('child_services')->whereIn('id', $allowedChildIds)->get();
            ?>

            <?php $__currentLoopData = $childservices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($child->id); ?>" 
                    <?php if($promocode->childservice_id == $child->id): ?> selected <?php endif; ?>>
                    <?php echo e($child->title); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </select>
</div>

<!-- Service Plan -->
<div class="col-md-3">
    <label for="serviceplan_id" class="form-label">Service Plan</label>
    <select name="serviceplan_id" class="form-select" id="serviceplan_id">
        <option value="">Select Plan</option>
        <?php if($promocode->subservice_id): ?>
            <?php
                $planIds = DB::table('service_plans')->where('subservice_id', $promocode->subservice_id)->where('status','1')->pluck('id');

                $allowedPlanIds = DB::table('serviceallottedcities')->where('countries_id', $promocode->countries)->where('state_id', $promocode->state)->where('city_id', $promocode->city)->where('status','1')->where('service_type','4')->whereIn('serviceid',$planIds)->pluck('serviceid');

                $plans = DB::table('service_plans')->whereIn('id',$allowedPlanIds)->get();
            ?>

            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($plan->id); ?>" 
                    <?php if($promocode->serviceplan_id == $plan->id): ?> selected <?php endif; ?>>
                    <?php echo e($plan->title); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </select>
</div>
    <!-- Submit Button -->
    <div class="col-12 text-end mt-3">
        <button class="btn btn-primary" type="submit" id="submit-btn" name="submit" value="submit">
            Update
        </button>
    </div>

</div>

    </section>
  </form>
							</div>
						</div>
					</div>
				</div>
</div>
</div>

	


<?php echo $__env->make('backend/include/footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('backend/include/datatableajax/tablescript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
$(document).ready(function () {

    // On country change
    $('#countries').change(function () {
        const countryId = $(this).val();
        if (countryId) {
            $.ajax({
                url: '<?php echo e(url("backend/promocodestatebycity")); ?>',
                method: 'GET',
                data: { country_id: countryId },
                beforeSend: () => $('#loader').show(),
                success: function (response) {
                    let options = '<option value="">Select State</option>';
                    response.states.forEach(item => {
                        options += `<option value="${item.state_id}">${item.name}</option>`;
                    });
                    $('#state').html(options);
                    $('#city, #pincode, #service_id, #subservice_id, #childservice_id, #serviceplan_id').html('<option value="">Select</option>');
                },
                complete: () => $('#loader').hide()
            });
        }
    });

    // On state change
    $('#state').change(function () {
        const stateId = $(this).val();
        const countryId = $('#countries').val();
        if (stateId) {
            $.ajax({
                url: '<?php echo e(url("backend/promocodestatebycity")); ?>',
                method: 'GET',
                data: { state_id: stateId, country_id: countryId },
                beforeSend: () => $('#loader').show(),
                success: function (response) {
                    let options = '<option value="">Select City</option>';
                    response.cities.forEach(item => {
                        options += `<option value="${item.city_id}">${item.name}</option>`;
                    });
                    $('#city').html(options);
                    $('#pincode, #service_id, #subservice_id, #childservice_id, #serviceplan_id').html('<option value="">Select</option>');
                },
                complete: () => $('#loader').hide()
            });
        }
    });

    // On city change
    $('#city').change(function () {
        const cityId = $(this).val();
        const countryId = $('#countries').val();
        const stateId = $('#state').val();

        if (cityId) {
            $.ajax({
                url: '<?php echo e(url("backend/promocodestatebycity")); ?>',
                method: 'GET',
                data: { city_id: cityId, country_id: countryId, state_id: stateId },
                beforeSend: () => $('#loader').show(),
                success: function (response) {
                    let pincodeOptions = '<option value="">Select Pincode</option>';
                    response.pincodes.forEach(item => {
                        pincodeOptions += `<option value="${item.id}">${item.pincode}</option>`;
                    });
                    $('#pincode').html(pincodeOptions);

                    let serviceOptions = '<option value="">Select Service</option>';
                    response.services.forEach(item => {
                        serviceOptions += `<option value="${item.id}">${item.title}</option>`;
                    });
                    $('#service_id').html(serviceOptions);

                    $('#subservice_id, #childservice_id, #serviceplan_id').html('<option value="">Select</option>');
                },
                complete: () => $('#loader').hide()
            });
        }
    });

    // On service change
    $('#service_id').change(function () {
        const serviceId = $(this).val();
        const countryId = $('#countries').val();
        const stateId = $('#state').val();
        const cityId = $('#city').val();

        if (serviceId) {
            $.ajax({
                url: '<?php echo e(url("backend/promocodestatebycity")); ?>',
                method: 'GET',
                data: { service_id: serviceId, country_id: countryId, state_id: stateId, city_id: cityId },
                beforeSend: () => $('#loader').show(),
                success: function (response) {
                    let subOptions = '<option value="">Select Subservice</option>';
                    response.subservices.forEach(item => {
                        subOptions += `<option value="${item.id}">${item.title}</option>`;
                    });
                    $('#subservice_id').html(subOptions);
                    $('#childservice_id, #serviceplan_id').html('<option value="">Select</option>');
                },
                complete: () => $('#loader').hide()
            });
        }
    });

    // On subservice change → get childservices + plans
   // On subservice change → get childservices + plans
$('#subservice_id').change(function () {
    const subserviceId = $(this).val();
    const countryId = $('#countries').val();
    const stateId = $('#state').val();
    const cityId = $('#city').val();

    if (subserviceId) {
        $.ajax({
            url: '<?php echo e(url("backend/promocodestatebycity")); ?>',
            method: 'GET',
            data: { subservice_id: subserviceId, country_id: countryId, state_id: stateId, city_id: cityId },
            beforeSend: () => $('#loader').show(),
            success: function (response) {
              
                let childOptions = '<option value="">Select Child Service</option>';
                response.childservices.forEach(item => {
                    childOptions += `<option value="${item.id}">${item.title}</option>`;
                });
                $('#childservice_id').html(childOptions);

               
                let planOptions = '<option value="">Select Plan</option>';
                response.plans.forEach(item => {
                    planOptions += `<option value="${item.id}">${item.title}</option>`;
                });
                $('#serviceplan_id').html(planOptions);
            },
            complete: () => $('#loader').hide()
        });
    }
});


});
</script>

<script>
    $(document).ready(function() {
        let startDatePicker = flatpickr("#startdate", {
            dateFormat: "d-m-Y",
            minDate: "today", 
            onChange: function(selectedDates, dateStr, instance) {
               
                endDatePicker.set("minDate", dateStr);
            }
        });

        let endDatePicker = flatpickr("#enddate", {
            dateFormat: "d-m-Y",
            minDate: "today"
        });
    });
</script>

<script>
  $(document).ready(function () {
      
    function initSelect2(selector, options = {}) {
      $(selector).select2($.extend({
        theme: "bootstrap-5",
        width: $(selector).data('width') ? $(selector).data('width') : $(selector).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(selector).data('placeholder'),
      }, options));
    }
    initSelect2('#countries');
    initSelect2('#state');
    initSelect2('#city');
    initSelect2('#pincode');
    initSelect2('#service_id');
    initSelect2('#subservice_id');
    initSelect2('#childservice_id');
    initSelect2('#serviceplan_id');
  });
</script>


</body>

</html><?php /**PATH /home/uatlocalpintu/public_html/resources/views/backend/promocode/promocodeedit.blade.php ENDPATH**/ ?>