
<script>

    $(document).ready(function () {

        let $title = $('#title');
        let $slug = $('#slug');
        let $metatitle = $('#metatitle');
        let $img_description = $('#img_description');
        let $subservice = $('#subservice_id');
        let slugError = $('#slug-error');
        let submitBtn = $('#submit-btn');



        // Title input event
        $title.on('input', function () {
            generateSlug($(this).val());
        });
        
        // Manual slug typing also triggers check
        $slug.on('input', function () {
            generateSlug($(this).val());
        });

        function generateSlug(text) {
            let slug = text
                .toLowerCase()
                .replace(/[^a-z0-9\s-]/g, '')
                .replace(/\s+/g, '-')
                .replace(/-+/g, '-');
                
             $slug.val(slug);
            $metatitle.val(text);
            $img_description.val(text);
            checkSlug(slug);    
        }

checkSlug($slug.val());

        function checkSlug(slug) {
            if (slug !== "") {
                $.ajax({
                    url: '<?php echo e(asset('slugalreadycheck')); ?>',
                    method: 'POST',
                    data: {
                        slug: slug,
                        editid: "<?php echo e($validateslug['editid']); ?>",
                        slugtype: "<?php echo e($validateslug['slugtype']); ?>",
                        fid: "<?php echo e($validateslug['fid']); ?>",
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    success: function (response) {
                        if (response.exists) {
                            slugError.text(response.msg).show();
                            submitBtn.prop('disabled', true);
                        } else {
                            slugError.text('').hide();
                            submitBtn.prop('disabled', false);
                        }
                    },
                    error: function () {
                        console.error('Error checking slug!');
                    }
                });
            } else {
                slugError.text('').hide();
                submitBtn.prop('disabled', false);
            }
        }
    });
</script>

<?php /**PATH D:\door\resources\views/backend/include/dynamicvalidation/slugvalidation.blade.php ENDPATH**/ ?>