@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

  <!--favicon-->

  @include('backend/include/head')
  @include('backend/include/datatableajax/tablelink')

  <title>Transaction Details</title>
  
  <style>
      .transaction-header {
    border-radius: 7px;
    background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
}
 .transaction-header h4{
        font-size: 20px;

}
 .transaction-header h3{
        font-size: 21px;

}

.receipt-header {
    background: #ff9800;
    color: white;
    padding: 1.5rem;
    text-align: center;
    position: relative;
    overflow: hidden;
}


.receipt-body {
    padding: 2rem;
    background-color: white;
    position: relative;
}

.detail-row {
    display: flex;
    margin-bottom: 1rem;
}


.detail-label {
    flex: 1;
    color: #808083;
    font-weight: 500;
}

.detail-value {
    flex: 2;
    font-weight: 500;
    text-align: right;
    color: #313131;
}

.divider {
    border-top: 2px dashed #e3e6f0;
    margin: 20px 0;
    position: relative;
}

.divider-text {
    position: absolute;
    top: -12px;
    left: 50%;
    transform: translateX(-50%);
    background-color: white;
    padding: 0 1rem;
    color: #989898;
    font-size: 0.8rem;
}
.amount-display {
    font-size: 35px;
    font-weight: 700;
    margin: 1.5rem 0;
    text-align: center;
}

.status-badge {
    font-size: 0.8rem;
    padding: 6px 12px;
    border-radius: 50rem;
}


.alert-light {
    background-color: rgba(244, 244, 244, 0.8);
    border-color: rgba(244, 244, 244, 0.9);
    color: #fff;
    color: #3f475a;
    background-color: #f4f4f4;
}

.receipt-footer {
    background-color: #f8f9fc;
    padding: 1.5rem;
    text-align: center;
    border-top: 1px solid #e3e6f0;
}


.modal-footer {
    flex-wrap: wrap;
}

.receipt-header h4{
    font-size:20px;
}


  </style>
  
</head>

<body>
  <!--wrapper-->
  <div class="wrapper">
    <!--sidebar wrapper -->
    @include('backend/include/sidebar')
    <!--end sidebar wrapper -->
    <!--start header -->
    @include('backend/include/header')
    <!--end header -->

    <!--start page wrapper -->
    <div class="page-wrapper">
  <div class="page-breadcrumb  justify-content-between mt-3 main_header card p-1">
    <div class="row">
    <div class="col-md-6">
    <div class="breadcrumb-title d-flex align-items-center ms-3 border-end-0">
        <i class="bx bx-buildings me-1"></i>
        <span>Transaction Details</span>
    </div>
    </div>
    <div class="col-md-6 text-end">
    <div>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#walletModal">View Receipt
        </button>
    
</div>
</div>
</div>
</div>
      <div class="page-content">

    <div class="transaction-header p-4 mb-4 border border-danger">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h4 class="mb-1">Lead Expense</h4>
                    <p class="mb-0 text-muted">Completed on 05 Sep 2025 03:38:54 PM</p>
                </div>
                <div class="col-md-4 text-md-end">
                    <h3 class="text-danger mb-0">-₹2000</h3>
                    
                    <span class="badge bg-danger">Debit</span>                </div>
            </div>
        </div>
        


<div class="card detail-card mb-4">
            <div class="card-body">
                <h5 class="card-title mb-4"><i class="bx bx-info-circle me-2"></i>Transaction Details</h5>
                
                <div class="row mb-3">
                    <div class="col-md-3 info-label">Transaction ID</div>
                    <div class="col-md-9">TXN68bab6b6581ca3.28648412</div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-3 info-label">Reference No.</div>
                    <div class="col-md-9">REF68bab6b6584698.51893760</div>
                </div>
                
                
                <div class="row mb-3">
                    <div class="col-md-3 info-label">Status</div>
                    <div class="col-md-9">
                        <span class="rounded px-3 py-1" style="color:#fff;background:green;">Complete</span>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-3 info-label">Description</div>
                    <div class="col-md-9">₹2000 has been added to your wallet for completing Lead Expenses#13.</div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-3 info-label">Previous Balance</div>
                    <div class="col-md-9">
                                                
                        ₹88730</div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-3 info-label">New Balance</div>
                    <div class="col-md-9">
                                                ₹86730                        
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-3 info-label">Comment</div>
                    <div class="col-md-9">NAN</div>
                </div>
            </div>
        </div>


      </div>
    </div>


    
<!-- popup form View Receipt---->
<div class="modal fade" id="walletModal" tabindex="-1" aria-labelledby="walletModalLabel" aria-hidden="true">
  <div class="modal-dialog rounded" style="max-width: 600px;">
<div class="modal-content">
                <div class="receipt-card">
                    <!-- Watermark -->
                  
                    <!-- Header -->
                    <div class="receipt-header" style="    border-radius: 7px 7px 0px 0px;">
                      
                        <h4 class="mb-1 text-white"><i class="bx bx-receipt me-2 text-white"></i>PAYMENT RECEIPT</h4>
                        <p class="mb-0 text-white">Official Transaction Confirmation</p>
                    </div>
                    
                    <!-- Body -->
                    <div class="receipt-body">
                        <!-- Transaction Info -->
                        <div class="detail-row">
                            <div class="detail-label">Receipt No.</div>
                           <div class="detail-value">RCT-2025-0152</div>
                        </div>
                        
                        <div class="detail-row">
                            <div class="detail-label">Transaction Date</div>
                            <div class="detail-value">05 Sep 2025 03:38:54 PM</div>
                        </div>
                        
                        <div class="divider">
                            <span class="divider-text">Transaction Details</span>
                        </div>
                        
                        <!-- Amount Display -->
                        <div class="text-center mb-2">
                            <p class="amount-display  my-1 text-danger">-₹2000</p>
                            <span class="rounded px-3 status-badge" style="color:#fff;background:green;">Complete</span>
                        </div>
                        
                        <!-- Transaction Details -->
                        <div class="detail-row">
                            <div class="detail-label">Transaction ID</div>
                            <div class="detail-value">TXN68bab6b6581ca3.28648412</div>
                        </div>
                        
                       
                        
                        <div class="detail-row">
                            <div class="detail-label">Description</div>
                            <div class="detail-value">₹2000 has been added to your wallet for completing Lead Expenses#13.</div>
                        </div>
                        
                        <div class="divider"></div>
                        
                        <!-- Balance Details -->
                        <div class="detail-row">
                            <div class="detail-label">Previous Balance</div>
                            <div class="detail-value">₹88730</div>
                        </div>
                        
                        <div class="detail-row">
                            <div class="detail-label">Transaction Amount</div>
                            <div class="detail-value text-danger">-₹2000</div>
                        </div>
                        
                        <div class="detail-row">
                            <div class="detail-label">New Balance</div>
                            <div class="detail-value">₹86730</div>
                        </div>
                        
                        <div class="divider">
                            <span class="divider-text">User Information</span>
                        </div>
                        
                        <!-- User Info -->
                        
                        
                        <div class="detail-row">
                            <div class="detail-label">Name</div>
                            <div class="detail-value">Admin</div>
                        </div>
                        <div class="detail-row">
                            <div class="detail-label">Mobile Number</div>
                            <div class="detail-value">9079282750</div>
                        </div>
                        
                        <div class="detail-row">
                            <div class="detail-label">Email</div>
                            <div class="detail-value">admin@gmail.com</div>
                        </div>
                        
                        <!-- Verification -->
                        <div class="alert alert-light mt-3 text-center">
                            <div class="security-badge mt-0">
                               <i class="bx bx-lock"></i> Secured Transaction • <i class="bx bx-check-shield"></i> Verified Payment
                            </div>
                        </div>
                    </div>
                    
                    <!-- Footer -->
                    <div class="receipt-footer">
                        <p class="mb-1">Thank you for choosing YourDoorstep </p>
                        <p class="mb-0 text-muted small">
                            This is an computer generated receipt. No signature required.<br>
                            For any queries, contact <strong>support@yourdoorstep.co</strong> or call <strong>+91 9540005064</strong>
                        </p>                    </div>
                </div>
                
                <!-- Modal Footer with Action Buttons -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary " data-bs-dismiss="modal">Close</button>
                    <!--<button type="button" class="btn btn-primary" onclick="window.print()">
                        <i class="fas fa-print me-2"></i>Print
                    </button>-->
                    
                    <button type="button" class="btn btn-primary" id="downloadPdf">
                      <i class="bx bx-download me-2"></i>Download
                    </button>
                </div>
            </div>
  </div>
</div>



    @include('backend/include/footer')
    @include('backend/include/datatableajax/tablescript')

    
</body>

</html>