@include('backend/include/custom')


<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>


@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>User Single View </title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->


<!--start page wrapper -->
<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3">
        <i class="bx bx-user-circle me-1"></i>

        <span>User Single View </span>
    </div>
</div>

    <div class="page-content">
        <div class="row">
            <div class="col-xl-12 mx-auto">
                            <!-- Nav tabs -->
                <div class="card">
                    <div class="bg-light border-bottom-0 pb-0 px-0">
                            <ul class="nav nav-tabs justify-content-start" id="settingsTab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active text-dark" id="others-tab" data-bs-toggle="tab" data-bs-target="#others" type="button" role="tab" aria-controls="others" aria-selected="true">
                                        Profile
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link text-dark" id="logo-tab" data-bs-toggle="tab" data-bs-target="#logo" type="button" role="tab" aria-controls="logo" aria-selected="false">
                                       Cart
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link text-dark" id="attempts-tab" data-bs-toggle="tab" data-bs-target="#attempts" type="button" role="tab" aria-controls="attempts" aria-selected="false">
                                        Activity
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link text-dark" id="attempts-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="attempts" aria-selected="false">
                                       Address
                                    </button>
                                </li>
                            </ul>
                    </div>

                    <div class="card-body p-4">
                    


                            <!-- Tab panes -->
                            <div class="tab-content" id="settingsTabContent">
                               
                                <div class="tab-pane fade show active" id="others" role="tabpanel" aria-labelledby="others-tab">


<style>
    .user-card {
    border-left: 2px solid #e35711;
    transition: transform 0.3s, box-shadow 0.3s;
}
.user-img1 {
border-radius: 50%;
    width: 160px;
    height: 160px;
    object-fit: cover;
    border: 1px solid #e7e5e2;
    box-shadow: 2px 2px 4px #cfcecead;
}

.user-title {
    color: #ec540e;
    font-weight: 600;
    font-size: 1.25rem;
    margin-bottom: 2px;
}

.user-name {
    font-size: 22px;
    color: #153478 !important;
    margin-bottom: 0px;
    font-weight: 400;
    margin-bottom: 5px;
}

.user-address {
    font-size: 14px;
    margin-bottom: 0;
    font-weight: 500;
}

.user-availability {
    font-size: 0.9rem;
    font-weight: 500;
    margin-bottom: 2px;
}

.user-rating{
        color: #fff;
    background: #087844;
    padding: 5px 5px;
        margin-bottom: 10px;
}

.green{
        color: #099d58;
    font-size: 15px;
}

.yellow{
        color: #ff9800;
    font-size: 15px;
}
    
</style>


<div class=" mb-3">
          <div class="row">
      <div class="d-flex flex-wrap align-items-center gap-3 user-info-wrapper">
  <div class="text-center flex-shrink-0">
    @if(!empty($userdata->profile) && file_exists(public_path('uploads/user/' . $userdata->profile)))
      <img class="user-img1 rounded-circle"
           src="{{ asset('uploads/user/' . $userdata->profile) }}"
           alt="{{ $userdata->name }}">
    @else
      <img src="{{asset('frontend/assets/image/user.png')}}"
           alt="User Profile"
           class="img-fluid rounded-circle"
           style="width: 140px; height: 140px; object-fit: cover;">
    @endif
  </div>

  <div class="flex-grow-1">
    <h5 class="user-name mb-1">{{ $userdata->name ?? 'N/A' }}</h5>
    <p class="user-rating badge">{{ $userdata->company_name ?? 'N/A' }}</p>

    <p class="d-flex flex-wrap align-items-center gap-2 mb-1">
      <span class="user-address">
        <i class="bx bx-phone-call me-1 yellow"></i>
        +{{ $userdata->phonecode ?? 'N/A' }} {{ $userdata->phone_number ?? 'N/A' }}
      </span>
      <span class="text-warning fw-semibold">|</span>
      <span class="user-address">
        <i class="bx bx-envelope me-1 yellow"></i> {{ $userdata->email ?? 'N/A' }}
      </span>
    </p>

    @php 
      $country = DB::table('tbl_countries')->where('countries_id',$userdata->countries)->where('cstatus','1')->first();
      $state   = DB::table('tbl_states')->where('state_id',$userdata->state)->where('s_status','1')->first();
      $city    = DB::table('tbl_cities')->where('city_id',$userdata->city)->where('city_status','1')->first();
    @endphp

    <p class="mb-2">
      <i class="bx bx-map me-1 yellow" style="font-size:15px;"></i>
      {{ $userdata->address }},
      @if(isset($country)){{ $country->name }}@endif,
      @if(isset($state)){{ $state->name }}@endif,
      @if(isset($city)){{ $city->name }}@endif,
      {{ $userdata->pincode }}
    </p>
    <p><span class="user-availability text-danger">GST No.:</span> {{ $userdata->gst_number ?? 'N/A' }}</p>
  </div>
</div>

          </div>
        </div>
        
<div class=" my-5">
  <div class="user-card2">
    <h4>User Information</h4>
    <div class="row">
<div class="col-md-3 my-2">
      <div class="item22">
        <span class="label22">Google ID</span>
        <span class="value22">{{$userdata->googleid??''}}</span>
      </div>
</div>
<div class="col-md-3 my-2">
      <div class="item22">
        <span class="label22">Phone Code</span>
        <span class="value22">+{{$userdata->phonecode??''}}</span>
      </div>
 </div>
<div class="col-md-3 my-2">
      <div class="item22">
        <span class="label22">Country</span>
        <span class="value22">@if(isset($country)){{ $country->name??''}}@endif</span>
      </div>
 </div>
<div class="col-md-3 my-2">
      <div class="item22">
        <span class="label22">State</span>
        <span class="value22">@if(isset($state)){{ $state->name??''}}@endif</span>
      </div>
 </div>
<div class="col-md-3 my-2">
      <div class="item22">
        <span class="label22">City</span>
        <span class="value22">@if(isset($city)){{ $city->name??''}}@endif</span>
      </div>
 </div>
<div class="col-md-3 my-2">
      <div class="item22">
        <span class="label22">Pincode</span>
        <span class="value22">{{ $userdata->pincode??'' }}</span>
      </div>
 </div>
<div class="col-md-3 my-2">
      <div class="item22">
        <span class="label22">Verify Status</span>
        <span class="value22 verified22">  {{ $userdata->verify_status == 1 ? 'Verified' : 'Unverified' }}</span>
      </div>
 </div>
<div class="col-md-3 my-2">
      <div class="item22">
        <span class="label22">IP</span>
        <span class="value22">{{ $userdata->ip }}</span>
      </div>
 </div>
<div class="col-md-3 my-2">
      <div class="item22">
        <span class="label22">Token</span>
        <span class="value22" style="font-size: 13px !important;">{{ $userdata->remember_token }}</span>
      </div>
 </div>

<div class="col-md-3 my-2">
      <div class="item22">
        <span class="label22">Strtotime</span>
        <span class="value22">{{ $userdata->strtotime }}</span>
      </div>
 </div>
<div class="col-md-3 my-2">
      <div class="item22">
        <span class="label22">Created</span>
        <span class="value22">{{ $userdata->created_at }}</span>
      </div>
 </div>
<div class="col-md-3 my-2">
      <div class="item22">
        <span class="label22">Updated</span>
        <span class="value22">{{ $userdata->updated_at }}</span>
      </div>
 </div>
    </div>
  </div>
</div>


<style>

.equal-row {
  display: flex;
  flex-wrap: wrap;
  align-items: stretch;
}
@media (max-width: 767px) {
  .user-info-wrapper {
    flex-direction: column;
    align-items: center;
    text-align: center;
  }

  .user-img1 {
    width: 120px;
    height: 120px;
  }
  
  
  .user-info-wrapper .flex-grow-1 {
    text-align: center;
    width: 100%;
  }

  .user-info-wrapper .d-flex {
    justify-content: center;
  }
}
  
  
  
.user-card2 h4 {
margin-bottom: 20px;
    font-weight: 500;
    color: #2c3e50;
    border-bottom: 2px solid #f1f1f1;
    padding-bottom: 8px;
    font-size: 20px;

}



.item22 {
    background: #f9fafb;
    border-radius: 5px;
    padding: 12px 15px;
    border: 1px solid #e7eaee;
    transition: all 0.2s 
ease;
    box-shadow: 0px 0px 8px #e5e5e596;
/*    display: flex;*/
    justify-content: space-between;
    border-left: 2px solid #e97a0c;
}



.label22 {
display: block;
    font-size: 15px;
    color: #125c99;
    font-weight: 500;
    margin-bottom: 4px;
    text-transform: capitalize;
}

.value22 {
font-size: 14px;
    font-weight: 400;
    color: #626262;
    word-break: break-all;
}

.value22.verified22 {
    color: #ffffff;
    background: #087844;
    padding: 3px 8px;
    border-radius: 6px;
    font-size: 13px;
    display: inline-block;
}
    
</style>





        


                                </div>
                                
<div class="tab-pane fade" id="logo" role="tabpanel" aria-labelledby="logo-tab">
<div class="card-body">
<input type="hidden"   class="form-control" id="id" value="{{$userdata->id}}"  name="id" >
<div class="table-responsive">
<table id="basic21"  class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
<thead>
<tr class="hello1">
<th>ID</th>
<th>Service</th>
<th>Plan/ Product</th>
<th>City</th>
<th>Price</th>
<th>Quantity</th>
<th>Days</th>
</tr>
</thead>

<tbody>

</tbody>

</table>
</div>
</div>
</div>

                                <div class="tab-pane fade" id="attempts" role="tabpanel" aria-labelledby="attempts-tab">
                     <div class="card-body">
    <div class="table-responsive">
      <table id="basic21logs"  class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
        <thead>
          <tr class="hello1">
            <th>ID</th>
            <th>Activity Id</th>
            <th>Curd Feature</th>
            <th>Web Url</th>
            <th>Days</th>
          </tr>
        </thead>
        <tbody>
          
 
          
        </tbody>
      </table>
    </div>
  </div>


                                </div>
                                
<div class="tab-pane fade" id="home" role="tabpanel" aria-labelledby="logo-tab">
  <div class="card-body">
    <div class="table-responsive">
      <table id="basic21address"  class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
        <thead>
          <tr class="hello1">
            <th>ID</th>
            <th>Name</th>
            <th>Address</th>
            <th>Company Name</th>
            <th>GST Number</th>
          </tr>
        </thead>
        <tbody>
          
 
          
        </tbody>
      </table>
    </div>
  </div>                                
</div>

                            </div>
                        
                    </div>
                </div>
            </div>
        </div>
        <!--end row-->
    </div>

</div>

<div id="loader" xss=removed>
    <div class="lds-hourglass"></div>
</div>

@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')

<script>
$(document).ready(function () {
    $.ajaxSetup({
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") }
    });

    var userId = $('#id').val();

    $("#basic21").DataTable({
        @include('backend.include.datatableajax.datatablefilter')
        processing: true,
        serverSide: true,
        serverMethod: "POST",
        ajax: {
            url: "{{ asset('backend/cartusersajax') }}",
            type: "POST",
            data: { user_id: userId },
            beforeSend: function () {
                $('#loader').show(); 
            },
            complete: function () {
                $('#loader').hide(); 
            },
            dataSrc: function (json) {
                console.log("AJAX SUCCESS DATA:", json);
                return json.data;
            },
            error: function (xhr) { 
                console.log("AJAX ERROR:", xhr.responseText); 
                $('#loader').hide(); 
            },
        },
        columns: [
            { data: "id" },
            { data: "service" },
            { data: "plan_product_id" },
            { data: "city" },
            { data: "price" },
            { data: "quantity" },
            { data: "days" }
        ],
    });
});
</script>

<script>
$(document).ready(function () {
    $.ajaxSetup({
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") }
    });

    var userId = $('#id').val();

    $("#basic21logs").DataTable({
        @include('backend.include.datatableajax.datatablefilter')
        processing: true,
        serverSide: true,
        serverMethod: "POST",
        ajax: {
            url: "{{ asset('backend/userlogsusersajax') }}",
            type: "POST",
            data: { user_id: userId },
            beforeSend: function () {
                $('#loader').show(); 
            },
            complete: function () {
                $('#loader').hide(); 
            },
            dataSrc: function (json) {
                console.log("AJAX SUCCESS DATA:", json);
                return json.data;
            },
            error: function (xhr) { 
                console.log("AJAX ERROR:", xhr.responseText); 
                $('#loader').hide();
            },
        },
        columns: [
            { data: "id" },
            { data: "activity" },
            { data: "curdfuntion" },
            { data: "weburl" },
            { data: "days" },
        ],
    });
});
</script>

<script>
$(document).ready(function () {
    $.ajaxSetup({
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") }
    });

    var userId = $('#id').val();

    $("#basic21address").DataTable({
        @include('backend.include.datatableajax.datatablefilter')
        processing: true,
        serverSide: true,
        serverMethod: "POST",
        ajax: {
            url: "{{ asset('backend/useraddressajax') }}",
            type: "POST",
            data: { user_id: userId },
            beforeSend: function () {
                $('#loader').show(); 
            },
            complete: function () {
                $('#loader').hide(); 
            },
            dataSrc: function (json) {
                console.log("AJAX SUCCESS DATA:", json);
                return json.data;
            },
            error: function (xhr) { 
                console.log("AJAX ERROR:", xhr.responseText); 
                $('#loader').hide(); 
            },
        },
        columns: [
            { data: "id" },
            { data: "name" },
            { data: "address" },
            { data: "companyname" },
            { data: "gstnumber" },
         
        ],
    });
});
</script>



</body>

</html>