@include('backend/include/custom')


<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>


@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Users</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->
<style>
    
.switcher-wrapper {
top: 0% !important;
	width: 367px;
		right: -367px;
}


.switcher-btn {
  top: 27% !important;
}

</style>

<!--start page wrapper -->
<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3">
        <i class="bx bx-user-circle me-1"></i>

        <span>Users</span>
    </div>
</div>

<div class="switcher-wrapper">
    @if(permission(session('SUPERADMIN_ID'), '30', 'action_view'))
        <div class="switcher-btn">
            <i class='bx bx-filter-alt'></i>
        </div>
    @endif

    <div class="card">
        <div class="card-header text-capitalize usbb d-flex align-items-center">
            <h4 class="mb-0 text-white">Filter</h4>
            <button type="button" class="btn-close ms-auto close-switcher bg-white" aria-label="Close"></button>
        </div>

        <div class="switcher-body">
            @php
                if(!empty($_GET['name'])){
                    $name = $_GET['name'];
                } else {
                    $name = "";
                }
                if(!empty($_GET['email'])){
                    $email = $_GET['email'];
                } else {
                    $email = "";
                }
               
                if(!empty($_GET['number'])){
                    $number = $_GET['number'];
                } else {
                    $number = "";
                }
               
            @endphp

            <form class="row g-3 needs-validation" id="filterForm" novalidate style="margin-top: -16px;">
                <div class="col-md-12">
        <label for="name" class="form-label">Name</label>
        <input type="text" class="form-control" id="name" name="name" placeholder="Enter Name" value="{{ $name }}">
    </div>

    <div class="col-md-12">
        <label for="email" class="form-label">Email</label>
        <input type="email" class="form-control"   oninput="this.value = this.value.replace(/\s+/g, '')" id="email" name="email" placeholder="Enter Email" value="{{  $email  }}">
    </div>

    <div class="col-md-12">
        <label for="number" class="form-label">Phone Number</label>
        <input type="text" class="form-control" id="number"  oninput="this.value = this.value.replace(/[^0-9]/g, '')"  name="number" maxlength="10" placeholder="Enter Phone Number" value="{{$number}}">
    </div>
                <div class="col-md-12"></div>
                <div class="col-md-8">
                    <div>
                        <button type="submit" id="submitBtn" class="btn btn-primary px-3">Apply</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

    <div class="page-content">
        <div class="row">
            <div class="col-xl-12 mx-auto">
                            <!-- Nav tabs -->
<div class="card">
  <div class="card-body">
    <div class="table-responsive">
      <table id="basic21"  class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
        <thead>
          <tr class="hello1">
            <th>ID</th>
            <th>Profile</th>
            <th>Name</th>
            <th>Email</th>
            <th>Status</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>
    </div>
  </div>
</div>


            </div>
    </div>
</div>

            </div>


<div id="loader" xss=removed>
    <div class="lds-hourglass"></div>
</div>

@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')



<script>
  $(document).ready(function () {
    $.ajaxSetup({
      headers: {
        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
      },
    });

    $("#basic21").DataTable({
      @include('backend.include.datatableajax.datatablefilter')
      processing: true,
      serverSide: true,
      serverMethod: "POST",
      ajax: {
        url: "{{ asset('backend/usersajax') }}",
        data: function (d) {
          d.name = $('#name').val();
          d.email = $('#email').val();
          d.number = $('#number').val();
        },
        beforeSend: function () {
          $('#loader').show(); 
        },
        complete: function () {
          $('#loader').hide(); 
        },
        dataSrc: function (json) {
          console.log("AJAX SUCCESS DATA:", json);
          return json.data;
        },
        error: function (xhr, error, thrown) {
          console.log("AJAX ERROR:", xhr.responseText);
          $('#loader').hide(); 
        },
      },
      columns: [
        { data: "id" },
        { data: "profile" },
        { data: "name" },
        { data: "email" },
         { data: "status" },
        { data: "action" },
      ],
    });
  });
</script>


  <script>
      $(document).on('change', '.toggle-flip input[type="checkbox"]', function () {
        let status = $(this).prop('checked') ? 1 : 0;
        let userId = $(this).data('id');

        $.ajax({
          type: "POST",
          url: "{{ asset('backend/usersstatus') }}",
          data: {
            status: status,
            id: userId,
            _token: '{{ csrf_token() }}',
          },
          success: function (response) {
            console.log("Status updated", response);
          },
          error: function (xhr) {
            console.log("AJAX Error:", xhr);
            alert("Something went wrong");
          }
        });
      });
    </script>








    

</body>

</html>