




@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

<!--favicon-->

@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>User Update</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->



<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1" >
    <div class="breadcrumb-title d-flex align-items-center ms-3 " >
          <i class="bx bx-user-circle me-1"></i>
        <span class="">User Update</span>
    </div>
</div>

 
<div class="page-content">
   <div class="row">
					<div class="col-xl-12 mx-auto">
						<div class="card">
						
						
							<div class="card-body">
  <form class="row g-3 needs-validation" onsubmit="return myckediter()" id="formatDistrict-update" method="POST" action="{{ asset('backend/userupdate/' . Crypt::encrypt($userdata->id)) }}" enctype="multipart/form-data" novalidate>
    @csrf
    <section class="mb-4">
      <div class="row">
        <!-- Service Select -->
									<div class="col-md-4 mb-3">
										<label for="name" class="form-label"> Name<span class="text-danger" >*</span></label>
							      <input type="text" class="form-control" name="name"  value="{{ $userdata->name }}" required>
									
									</div>
									<div class="col-md-4 mb-3">
										<label for="company_name" class="form-label"> Company Name<span class="text-danger" >*</span></label>
								  <input type="text" class="form-control" name="company_name" value="{{ $userdata->company_name ?? '' }}" required >
									</div>
										<div class="col-md-4 mb-3">
									  <label for="verify_status" class="form-label">Verify Status <span class="text-danger">*</span></label>
    <select class="form-control" name="verify_status" required>
        <option value="1" {{ (isset($userdata->verify_status) && $userdata->verify_status == 1) ? 'selected' : '' }}>Verified</option>
        <option value="0" {{ (isset($userdata->verify_status) && $userdata->verify_status == 0) ? 'selected' : '' }}>Unverified</option>
    </select>
									</div>
									<div class="col-md-6 mb-3">
										<label for="email" class="form-label"> Email<span class="text-danger" >*</span></label>
								  <input type="text" class="form-control"  name="email" value="{{ $userdata->email }}" oninput="this.value=this.value.replace(/\s+/g,'')" required>
									</div>
									<div class="col-md-6 mb-3">
										<label for="phone_number" class="form-label"> Phone Number<span class="text-danger" >*</span></label>
								  <input type="text" class="form-control"  name="phone_number"  value="{{ $userdata->phone_number }}"  oninput="this.value=this.value.replace(/\s+/g,'')" required>
									</div>
									<div class="col-md-6 mb-3">
									 
									 	<label for="countries" class="form-label"> Countries<span class="text-danger" >*</span></label>
      <select name="countries" class="form-select" id="countries">
        <option value="">Select Countries</option>
        @foreach($countries as $countryData)
            <option value="{{$countryData->countries_id}}" @if($countryData->countries_id == $userdata->countries) selected @endif>
                {{$countryData->name}}
            </option>
        @endforeach
    </select>
									</div>
									<div class="col-md-6 mb-3">
									 
									 	<label for="state" class="form-label"> State<span class="text-danger" >*</span></label>
        <select name="state" class="form-select" id="state" >
                                            {!! locationOptions('state', $userdata->state ?? '') !!}
                                        </select>
									</div>
									<div class="col-md-6 mb-3">
									 
									 	<label for="city" class="form-label"> City<span class="text-danger" >*</span></label>
      
                                        <select name="city" class="form-select" id="city" >
                                            {!! locationOptions('city', $userdata->city ?? '') !!}
                                        </select>
									</div>
									<div class="col-md-6 mb-3">
									 
									 	<label for="pincode" class="form-label"> Pincode<span class="text-danger" >*</span></label>
      
                                          <select name="pincode" class="form-select" id="pincode" >
                                          {!! locationOptions('pincode', $userdata->pincode ?? '') !!}
                                        </select>
									</div>

        <!-- Brand Name -->
<div class="col-md-6 mb-3">
  <label for="gst_number" class="form-label">GST Number<span class="text-danger">*</span></label>
  <input type="text" class="form-control" name="gst_number" value="{{ $userdata->gst_number ?? '' }}">
</div>




<div class="col-md-6 mb-3">
    <label for="profile" class="form-label">Profile Image
        <span class="text-danger">(JPG, PNG, WEBP)</span>
    </label>
    
    <div class="input-group">
        <input type="file" data-value="imageerror1" type="file" class="form-control image @error('image') is-invalid @enderror"  id="profile" name="profile" accept=".jpg,.jpeg,.png,.webp">

        @if(isset($userdata->profile))
            <a href="{{ asset('uploads/user/' . $userdata->profile) }}" 
               data-fancybox="profile" 
               data-caption="Brand Logo">
                <img src="{{ asset('uploads/user/' . $userdata->profile) }}" 
                     alt="Brand Logo" 
                     style="width: 50px; height: 38px; margin-left: 10px;" />
            </a>
        @endif
    </div>

									  <div class="error-message" id="imageerror1" style="color: red;"></div>
										<div class="valid-feedback">
											@error('profile')
                                            <span class="alert text-danger">{{ $message }}</span>
                                        @enderror
										  </div>
</div>

<div class="col-md-12 mb-3">
  <label for="gst_number" class="form-label">Address<span class="text-danger">*</span></label>
 <textarea class="form-control" name="address" rows="5">{{ $userdata->address ?? '' }}</textarea>
</div>




        <div class="col-12 text-end">
<button class="btn btn-primary" type="submit" id="submit-btn" name="submit" value="submit">
  Update
</button>
        </div>
      </div>
    </section>
  </form>
							</div>
						</div>
					</div>
				</div>
</div>
</div>

	


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')
    @include('backend/include/statebycity/statebycity')

<script>
  $(document).ready(function () {
      
    function initSelect2(selector, options = {}) {
      $(selector).select2($.extend({
        theme: "bootstrap-5",
        width: $(selector).data('width') ? $(selector).data('width') : $(selector).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(selector).data('placeholder'),
      }, options));
    }
    initSelect2('#countries');
    initSelect2('#state');
    initSelect2('#city');
    initSelect2('#pincode');
   
  });
</script>

</body>

</html>


		










