

@include('backend/include/custom')


<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>


@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')
<title>Website Settings</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->


<!--start page wrapper -->
<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3">
        <i class="bx bx-home-alt me-1 mb-1"></i>
        <span>Website Settings</span>
    </div>
</div>

    <div class="page-content">
        <div class="row">
            <div class="col-xl-12 mx-auto">
                            <!-- Nav tabs -->
                <div class="card">
                    <div class="bg-light border-bottom-0 pb-0 px-0">
                            <ul class="nav nav-tabs justify-content-start" id="settingsTab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active text-dark" id="others-tab" data-bs-toggle="tab" data-bs-target="#others" type="button" role="tab" aria-controls="others" aria-selected="true">
                                        General Settings
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link text-dark" id="logo-tab" data-bs-toggle="tab" data-bs-target="#logo" type="button" role="tab" aria-controls="logo" aria-selected="false">
                                        Logo & Images
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link text-dark" id="attempts-tab" data-bs-toggle="tab" data-bs-target="#attempts" type="button" role="tab" aria-controls="attempts" aria-selected="false">
                                        Attempts Settings
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link text-dark" id="attempts-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="attempts" aria-selected="false">
                                        Home Settings
                                    </button>
                                </li>
                            </ul>
                    </div>

                    <div class="card-body p-4">
                        <form class="needs-validation" novalidate action="{{asset('backend/websitesettingedit')}}" method="POST" enctype="multipart/form-data">
                            @csrf



                            <!-- Tab panes -->
                            <div class="tab-content" id="settingsTabContent">
                                <!-- Tab 1: Logo & Images -->
                                <div class="tab-pane fade" id="logo" role="tabpanel" aria-labelledby="logo-tab">
                                    <section class="mb-4">
                                        <div class="row mb-3">
                                            <div class="col-md-6 mb-3">
                                                <label for="favicon" class="form-label">Favicon Icon</label>
                                                <div class="input-group">
                                                    <input class="form-control" name="fevicon" type="file" id="fevicon">
                                                    @if($websitedata->fevicon)
                                                    <a href="{{asset('uploads/websitesetting/'.$websitedata->fevicon)}}" data-fancybox="image" data-caption="">
                                                        <img src="{{asset('uploads/websitesetting/'.$websitedata->fevicon)}}" style="width:36px; height:36px; margin-left:10px; padding:0px;">
                                                    </a>
                                                    @endif
                                                    <input type="hidden" class="form-control" name="fevicon_hidden" value="1749124427fevicon.png">
                                                </div>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="header_logo" class="form-label">Header Logo</label>
                                                <div class="input-group">
                                                    <input class="form-control" name="header_logo" type="file" id="header_logo">
                                                    @if($websitedata->header_logo)
                                                    <a href="{{asset('uploads/websitesetting/'.$websitedata->header_logo)}}" data-fancybox="image" data-caption="">
                                                        <img src="{{asset('uploads/websitesetting/'.$websitedata->header_logo)}}" style="width:36px; height:36px; margin-left:10px; padding:0px;">
                                                    </a>
                                                    @endif
                                                    <input type="hidden" class="form-control" name="headerlogo_hidden" value="1749124427header_logo.png">
                                                </div>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="footer_logo" class="form-label">Footer Logo</label>
                                                <div class="input-group">
                                                    <input class="form-control" name="footer_logo" type="file" id="footer_logo">
                                                    @if($websitedata->footer_logo)
                                                    <a href="{{asset('uploads/websitesetting/'.$websitedata->footer_logo)}}" data-fancybox="image" data-caption="">
                                                        <img src="{{asset('uploads/websitesetting/'.$websitedata->footer_logo)}}" style="width:36px; height:36px; margin-left:10px; padding:0px;">
                                                    </a>
                                                    @endif
                                                    <input type="hidden" class="form-control" name="footerlogo_hidden" value="1749124427footer_logo.png">
                                                </div>
                                            </div>
                                            
                                              <div class="col-md-6">
                                                <label for="site_title" class="form-label">File Size</label>
                                                <input type="text" class="form-control" id="file_size" name="file_size" value="{{$websitedata->file_size}}" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1');" >
                                            </div>
                                        </div>
                                    </section>
                                </div>

                                <!-- Tab 2: Other Settings -->
                                <div class="tab-pane fade show active" id="others" role="tabpanel" aria-labelledby="others-tab">

                                    <!-- Basic Information Section -->
                                    <section class="mb-4">
                                        <h6 class="mb-2">Basic Information</h6>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <label for="site_title" class="form-label">Website Name</label>
                                                <input type="text" class="form-control" id="site_title" name="site_title" value="{{$websitedata->site_title}}" required>
                                            </div>
                                        </div>
                                    </section>

                                    <!-- Contact Information Section -->
                                    <section class="mb-4">
                                        <h6 class="mb-2">Contact Information</h6>
                                        <div class="row">
                                            <div class="col-md-4 mb-3">
                                                <label for="mobile_number" class="form-label mb-1">Mobile Number</label>
										        <div class="input-group"> <span class="input-group-text bg-transparent"><i class='bx bxs-phone' ></i></span>
										        	<input type="text" class="form-control" id="mobile_number" maxlength="10" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1');" name="mobile_number" value="{{$websitedata->mobile_number}}" required>
									        	</div>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <label for="email" class="form-label mb-1">Email</label>
                                                <div class="input-group"> <span class="input-group-text bg-transparent"><i class='bx bxs-envelope' ></i></span>
                                                <input type="email" class="form-control" id="email" name="email" value="{{$websitedata->email}}" required>
                                                </div>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <label for="whatsapp" class="form-label mb-1">WhatsApp Link</label>
                                                <input type="text" class="form-control" id="whatsapp" name="whatsapp" value="{{$websitedata->whatsapp}}" required>
                                            </div>
                                       
                                            <div class="col-md-12 mb-3">
                                                <label for="address" class="form-label mb-1">Address</label>
                                                <textarea class="form-control" id="address" name="address" rows="3" required>{{$websitedata->address}}</textarea>
                                            </div>
                                        </div>



                                        
                                       

                                    </section>

                                    <!-- Social Media Section -->
                                    <section class="mb-4">
                                        <h6 class="mb-2">Social Media Links</h6>
                                        <div class="row mb-3">
                                            <div class="col-md-6 mb-3">
                                                <label for="facebook" class="form-label">Facebook</label>
                                                <input type="text" class="form-control" id="facebook" name="facebook" value="{{$websitedata->facebook}}" required>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="linkedin" class="form-label">LinkedIn</label>
                                                <input type="text" class="form-control" id="linkedin" name="linkedin" value="{{$websitedata->linkedin}}" required>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="instagram" class="form-label">Instagram</label>
                                                <input type="text" class="form-control" id="instagram" name="instagram" value="{{$websitedata->instagram}}" required>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="twitter" class="form-label">Twitter</label>
                                                <input type="text" class="form-control" id="twitter" name="twitter" value="{{$websitedata->twitter}}" required>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="youtube" class="form-label">YouTube</label>
                                                <input type="text" class="form-control" id="youtube" name="youtube" value="{{$websitedata->youtube}}" required>
                                            </div>
                                        </div>
                                    </section>

                                    

                                    <!-- URL Settings -->
                                    <section class="mb-4">
                                        <h6 class="mb-2">Basic URL</h6>
                                        <div class="row mb-3">
                                            <div class="col-md-12">
                                                <label for="url" class="form-label">Website URL</label>
                                                <input type="text" class="form-control" id="url" name="web_url" value="{{$websitedata->web_url}}" required>
                                            </div>
                                        </div>
                                    </section>

                                    <!-- SEO Section -->
                                    <section class="mb-4">
                                        <h6 class="mb-2">SEO Settings</h6>
                                        <div class="row mb-1">
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Meta Title</label>
                                                <textarea class="form-control" name="meta_title" rows="2">{{$websitedata->meta_title}}</textarea>
                                            </div>
                                            <div class="col-md-6 mb-1">
                                                <label class="form-label">Meta Keyword</label>
                                                <textarea class="form-control" name="meta_keyword" rows="2">{{$websitedata->meta_keyword}}</textarea>
                                            </div>
                                            <div class="col-md-12 mb-3">
                                                <label class="form-label">Meta Description</label>
                                                <textarea class="form-control" name="meta_description" rows="2">{{$websitedata->meta_description}}</textarea>
                                            </div>
                                        </div>
                                    </section>

                                    <!-- Media & Other Section -->
                                    <section class="mb-4">
                                        <h6 class="mb-2">Media & Other Settings</h6>
                                        <div class="row mb-3">
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Video Link</label>
                                                <textarea class="form-control" name="video_link" rows="2">{{$websitedata->video_link}}</textarea>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Map Link</label>
                                                <textarea class="form-control" name="map_link" rows="2">{{$websitedata->map_link}}</textarea>
                                            </div>
                                        </div>
                                    </section>

                                    <!-- Footer Content Section -->
                                    <section class="mb-4">
                                        <h6 class="mb-2">Footer Content</h6>
                                        <div class="row mb-3">
                                            <div class="col-md-6 mb-3">
                                                <label for="footer_content" class="form-label">Footer Text</label>
                                                <textarea type="text" class="form-control" id="footer_content" name="footer_content" rows="2" required>{{$websitedata->footer_content}}</textarea>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Copyright</label>
                                                <textarea class="form-control" name="copyright" rows="2">{{$websitedata->copyright}}</textarea>
                                            </div>
                                        </div>
                                    </section>

                                </div>
                                <div class="tab-pane fade" id="attempts" role="tabpanel" aria-labelledby="attempts-tab">
                                    <!-- Attempt Settings -->
                                 <section class="mb-4">
    <div class="row">
        <!-- Admin Login Attempt Time -->
        <div class="col-md-4 mb-3">
            <label for="adminloginattempt_time" class="form-label">Admin Login Attempt Time</label>
            <input type="text" class="form-control" id="adminloginattempt_time" name="adminloginattempt_time" value="{{$websitedata->adminloginattempt_time}}" placeholder="Min" required>
        </div>

        <!-- Admin OTP Attempt Count -->
        <div class="col-md-4 mb-3">
            <label for="admin_otp_attempt_count" class="form-label">Admin OTP Attempt Count</label>
            <input type="text" class="form-control" id="admin_otp_attempt_count" name="admin_otp_attempt_count" value="{{$websitedata->admin_otp_attempt_count}}" placeholder="Count" required>
        </div>

        <!-- Admin Login IP Attempt Count -->
        <div class="col-md-4 mb-3">
            <label for="admin_login_ip_attempt_count" class="form-label">Admin Login IP Attempt Count</label>
            <input type="text" class="form-control" id="admin_login_ip_attempt_count" name="admin_login_ip_attempt_count" value="{{$websitedata->admin_login_ip_attempt_count}}" placeholder="Count" required>
        </div>

        <!-- Service Allotted Countries -->
        <div class="col-md-4 mb-3">
            <label for="allotted_countries" class="form-label">Service Allotted Countries</label>
            
            <select class="form-control" id="allotted_countries" name="allotted_countries" required>
        <option value="">Select Countries </option>
        @foreach($country as $data)
            <option value="{{ $data->countries_id }}" {{ $websitedata->allotted_countries == $data->countries_id ? 'selected' : '' }}>
                {{ $data->name }}
            </option>
        @endforeach
    </select>
        </div>
        
        <div class="col-md-4 mb-3">
            <label for="" class="form-label">State</label>
            
            <select class="form-control" id="state" name="state" required>
        <option value="">Select State </option>
        @foreach($state as $Sdata)
            <option value="{{ $Sdata->state_id }}" {{ $websitedata->state == $Sdata->state_id ? 'selected' : '' }}>
                {{ $Sdata->name }}
            </option>
        @endforeach
    </select>
        </div>

        <!-- Login OTP Default Number -->
        <div class="col-md-4 mb-3">
            <label for="otp_defalutnumber" class="form-label">Login OTP Default Number</label>
            <div class="input-group">
                <span class="input-group-text bg-transparent"><i class='bx bxs-phone'></i></span>
                <input class="form-control" onkeydown="noSpaces(event)" maxlength="10" oninput="this.value = this.value.replace(/[^0-9]/g, '')" type="text" id="otp_defalutnumber" name="login_otp_default_number" value="{{$websitedata->login_otp_default_number}}">
            </div>
        </div>

        <!-- Login OTP Default Email -->
        <div class="col-md-4 mb-3">
            <label for="otp_defalutemail" class="form-label">Login OTP Default Email</label>
            <div class="input-group">
                <span class="input-group-text bg-transparent"><i class='bx bxs-envelope'></i></span>
                <input type="email" class="form-control" id="otp_defalutemail" name="login_otp_default_email" value="{{$websitedata->login_otp_default_email}}" required>
            </div>
        </div>
<div class="col-md-4 mb-3">
    <label for="admin_login_ip_attempt_count" class="form-label">Admin OTP Send Type</label>
    <select class="form-select" id="admin_login_ip_attempt_count" name="admin_login_ip_attempt_count" required>
        <option value="1" {{ $websitedata->otp_send_type == 1 ? 'selected' : '' }}>Number</option>
        <option value="2" {{ $websitedata->otp_send_type == 2 ? 'selected' : '' }}>Email</option>
    </select>
</div>
    </div>
    
    <div class="row">
        <!-- Multiple Attempt Status -->
        <div class="col-md-3 mb-3">
            <div class="form-check mt-4">
                <input type="checkbox" class="form-check-input" id="multipal_attempt_status" value="1"
                    {{ old('multipal_attempt_status', $websitedata->multipal_attempt_status ?? 0) == 1 ? 'checked' : '' }}
                    name="multipal_attempt_status">
                <label class="form-check-label" for="multipal_attempt_status">Multiple Attempt Status</label>
            </div>
        </div>

        <!-- Login with OTP Apply -->
        <div class="col-md-3 mb-3">
            <div class="form-check mt-4">
                <input type="checkbox" class="form-check-input" id="login_with_opt_apply" value="1"
                    {{ old('login_with_opt_apply', $websitedata->login_with_opt_apply ?? 0) == 1 ? 'checked' : '' }}
                    name="login_with_opt_apply">
                <label class="form-check-label" for="login_with_opt_apply">Login with OTP Apply</label>
            </div>
        </div>

        <!-- Want to send OTP to this number -->
        <div class="col-md-3 mb-3">
            <div class="form-check mt-4">
                <input type="checkbox" class="form-check-input" id="otp_defalut_status" value="1"
                    {{ old('otp_defalut_status', $websitedata->otp_defalut_status ?? 0) == 1 ? 'checked' : '' }}
                    name="otp_defalut_status">
                <label class="form-check-label" for="otp_defalut_status">Send OTP to this Number</label>
            </div>
        </div>

        <!-- Want to send OTP to this email -->
        <div class="col-md-3 mb-3">
            <div class="form-check mt-4">
                <input type="checkbox" class="form-check-input" id="otp_defalutemail_status" value="1"
                    {{ old('otp_defalutemail_status', $websitedata->otp_defalutemail_status ?? 0) == 1 ? 'checked' : '' }}
                    name="otp_defalutemail_status">
                <label class="form-check-label" for="otp_defalutemail_status">Send OTP to this Email</label>
            </div>
        </div>
        <h3>User</h3>
        
          <div class="col-md-4 mb-3">
            <div class="form-check mt-4">
                <input type="checkbox" class="form-check-input" id="user_multipal_attempt_status" value="1"
                    {{ old('user_multipal_attempt_status', $websitedata->user_multipal_attempt_status ?? 0) == 1 ? 'checked' : '' }}
                    name="user_multipal_attempt_status">
                <label class="form-check-label" for="user_multipal_attempt_status">User Multipal Attempt Status</label>
            </div>
        </div>
          <div class="col-md-3 mb-3">
            <div class="form-check mt-4">
                <input type="checkbox" class="form-check-input" id="user_login_with_opt_apply" value="1"
                    {{ old('user_login_with_opt_apply', $websitedata->user_login_with_opt_apply ?? 0) == 1 ? 'checked' : '' }}
                    name="user_login_with_opt_apply">
                <label class="form-check-label" for="user_login_with_opt_apply">User Login With Otp Apply</label>
            </div>
        </div>
    </div>
</section>

                                </div>
                                
<div class="tab-pane fade" id="home" role="tabpanel" aria-labelledby="logo-tab">
    <section class="mb-4">
@php
    // Decode saved services, default empty array
    $selectedServices = json_decode($website->services ?? '[]', true);
@endphp

<div class="row">
  @for($i = 1; $i <= 4; $i++)
    @php
        // Section-wise selected value (zero-based index)
        $selectedValue = $selectedServices[$i-1] ?? null;
    @endphp
    <div class="col-md-6 mb-3">
      <div class="align-items-center">
        <label for="only_service_id_{{ $i }}" class="form-label fw-bold me-2" style="white-space: nowrap; min-width: 120px;">
          Service Section {{ $i }}
        </label>
        <select class="form-select service-only-select" 
                name="services[]" 
                id="only_service_id_{{ $i }}" 
                style="flex:1;">
          <option value="">Select Service</option>
          @foreach($service as $s)
            <option value="{{ $s->id }}" 
                {{ (string)$s->id === (string)$selectedValue ? 'selected' : '' }}>
                {{ $s->title }}
            </option>
          @endforeach
        </select>
      </div>
    </div>
  @endfor
</div>








<br>
@php
    // Decode service → subservice mapping
    $selectedServices = json_decode($website->home_services ?? '{}', true);
@endphp

<div class="row">
  @for($i = 1; $i <= 4; $i++)
    @php
        // Service IDs list
        $serviceId = array_keys($selectedServices)[$i-1] ?? '';
        $subserviceId = $serviceId ? $selectedServices[$serviceId] : '';
    @endphp

    <!-- Service -->
    <div class="col-md-6 align-items-center gap-2 mb-3">
      <div class="fw-bold me-2" style="white-space: nowrap;">Subservice Section {{ $i }}</div>
      <select class="form-select service-select"
              id="service_id_{{ $i }}"
              name="home_services[]"
              data-subservice="#subservice_id_{{ $i }}"
              style="min-width: 200px;">
        <option value="">Select Service</option>
        @foreach($service as $s)
          <option value="{{ $s->id }}" {{ (string)$s->id === (string)$serviceId ? 'selected' : '' }}>
            {{ $s->title }}
          </option>
        @endforeach
      </select>
    </div>

    <!-- Subservice -->
    <div class="col-md-6 mb-3">
<div class="fw-bold me-2" style="white-space: nowrap; padding: 10px;"></div>
      <select class="form-select"
              id="subservice_id_{{ $i }}"
              name="sub_services[]"
              style="min-width: 200px;">
        <option value="">Select Subservice</option>
        @if($serviceId)
          @php
              $subservices = \DB::table('subservices')
                  ->where('service_id', $serviceId)
                  ->where('status', '1')
                  ->get();
          @endphp
          @foreach($subservices as $sub)
            <option value="{{ $sub->id }}" {{ (string)$sub->id === (string)$subserviceId ? 'selected' : '' }}>
              {{ $sub->title }}
            </option>
          @endforeach
        @endif
      </select>
    </div>
  @endfor
</div>






        <div class="row mb-3">

</div>
    </section>                                    
</div>
<style>
    .select2-container--bootstrap-5 .select2-selection--single {
    padding: 0.375rem 8.25rem .375rem .75rem !important;
    }
</style>
                            </div>
                            <!-- Submit Button -->
                            <div class="col-12 text-end">
                                @if(permission(session('SUPERADMIN_ID'), '2', 'action_edit'))
                                <button class="btn btn-primary" type="submit" name="submit" value="submit">
                                    Update
                                </button>
                                @endif
                            </div>


                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!--end row-->
    </div>
</div>
<!--end page wrapper -->


<div id="loader" style="display:none;">
    <div class="lds-hourglass"></div>
</div>

@include('backend/include/footer')
@include('backend/include/subservicebychildservice/subservicebychildservice')
 @include('backend/include/datatableajax/tablescript')



<script>
  $(document).ready(function () {
      
    function initSelect2(selector, options = {}) {
      $(selector).select2($.extend({
        theme: "bootstrap-5",
        width: $(selector).data('width') ? $(selector).data('width') : $(selector).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(selector).data('placeholder'),
      }, options));
    }

    initSelect2('#allotted_countries');
    initSelect2('#state');
 
    
  
  });
</script>

<script>
  $(document).ready(function () {
    function initSelect2(selector, options = {}) {
      let defaultOptions = {
        theme: "bootstrap-5",
        width: $(selector).data('width') 
            ? $(selector).data('width') 
            : $(selector).hasClass('w-100') 
              ? '100%' 
              : 'style',
        placeholder: $(selector).data('placeholder') || "Select an option",
        allowClear: true
      };

      $(selector).select2($.extend({}, defaultOptions, options));
    }

    $('[id^=service_id_]').each(function () {
      initSelect2(this);
    });

    $('[id^=subservice_id_]').each(function () {
      initSelect2(this);
    });

    $('[id^=only_service_id_]').each(function () {
      initSelect2(this);
    });
  });
</script>


<script>
$(document).ready(function () {
    $(document).on('change', '.service-select', function () {
        const serviceId = $(this).val();
        const subserviceDropdown = $($(this).data('subservice')); 

        if (serviceId) {
            $.ajax({
                url: '{{ url("backend/getsubserviceshome") }}',
                method: 'GET',
                data: { service_id: serviceId },
                  beforeSend: function () {
                    $('#loader').show(); 
                },
                success: function (response) {
                    if (response.subservices && response.subservices.length) {
                        let options = '<option value="">Select Subservice</option>';
                        response.subservices.forEach(function (item) {
                            options += `<option value="${item.id}">${item.title}</option>`;
                        });
                        subserviceDropdown.html(options);
                    } else {
                        subserviceDropdown.html('<option value="">No Subservices Available</option>');
                    }
                },
                error: function () {
                    subserviceDropdown.html('<option value="">Error loading subservices</option>');
                },
                complete: function () {
                    $('#loader').hide(); 
                    $('.switcher-wrapper').removeClass('switcher-toggled'); 
                }
            });
        } else {
            subserviceDropdown.html('<option value="">Select Service First</option>');
        }
    });
});
</script>



</body>

</html>




