@include('backend/include/custom')


<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>


@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Notification</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->
<style>
    
.switcher-wrapper {
top: 0% !important;
	width: 367px;
		right: -367px;
}


.switcher-btn {
  top: 27% !important;
}

</style>

<!--start page wrapper -->
<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3">
        <i class="bx bx-bell me-1"></i>
        <span>Notification</span>
    </div>
</div>

<div class="switcher-wrapper">
    @if(permission(session('SUPERADMIN_ID'), '30', 'action_view'))
        <div class="switcher-btn">
            <i class='bx bx-filter-alt'></i>
        </div>
    @endif

    <div class="card">
        <div class="card-header text-capitalize usbb d-flex align-items-center">
            <h4 class="mb-0 text-white">Filter</h4>
            <button type="button" class="btn-close ms-auto close-switcher bg-white" aria-label="Close"></button>
        </div>

        <div class="switcher-body">
            @php
                if(!empty($_GET['feature'])){
                    $feature = $_GET['feature'];
                } else {
                    $feature = "";
                }
                if(!empty($_GET['activities'])){
                    $activities = $_GET['activities'];
                } else {
                    $activities = "";
                }
               
                if(!empty($_GET['username'])){
                    $username = $_GET['username'];
                } else {
                    $username = "";
                }
               
            @endphp

            <form class="row g-3 needs-validation" id="filterForm" novalidate style="margin-top: -16px;">
                <div class="col-md-12">
                    	<label for="bsValidation1" class="form-label"> Feature</label>
					<select class="form-select @error('title') is-invalid @enderror" id="feature" name="feature"
						>
						<option value="">Select Feature </option>
				 @foreach($features as $featureData)
        <option value="{{ $featureData->id }}" @if($feature == $featureData->id) selected @endif>{{ $featureData->feature }}</option>
    @endforeach
					
					</select>
                </div>
                

				<div class="col-md-12">
					<label for="bsValidation1" class="form-label"> Activity</label>
					<select class='form-control' name="activities"
						id="activities" >
					    	<option value="">Select Activity </option>
					    	@foreach($act as $activitiesData)
						<option value="{{$activitiesData->id}}" @if($activities == $activitiesData->id) selected @endif>{{$activitiesData->activity}}</option>
						@endforeach
					
	
					</select>
				</div>

				<div class="col-md-12">
					<label for="bsValidation1" class="form-label"> User Name</label>
					<select class='form-control' name="username"
						id="username" >
					    	<option value="">Select Option </option>
					    	@foreach($userName as $userData)
						<option value="{{$userData->id}}" @if($username == $userData->id) selected @endif>{{$userData->firstname}}{{$userData->lastname}}</option>
						@endforeach
					
	
					</select>
				</div>
                <div class="col-md-12"></div>
                <div class="col-md-8">
                    <div>
                        <button type="submit" id="submitBtn" class="btn btn-primary px-3">Apply</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="page-content">

        <div class="row">
            <div class="col-xl-12 mx-auto">
                           
<div class="card">

  <div class="card-body">
    <div class=" text-end">
       <button id="read-status" class="btn btn-sm"
    style="background: linear-gradient(135deg, #26C6DA, #00ACC1); color: white; font-weight: 500; border-radius: 20px;">
    Read
</button>
       <button id="delete-selected" class="btn btn-sm" 
        style="background: linear-gradient(135deg, #D50000, #FF1744); color: white; font-weight: 500; border-radius: 20px;">
    Delete Selected
</button>

    </div>
    <div class="table-responsive">
      <table id="basic21"  class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
        <thead>
          <tr class="hello1">
            <th>
                <input type="checkbox" class="mt-0 row-checkbox" id="select-all"><span class="ms-2">ID</span>
            </th>
            <th>Feature ID</th>
            <th>Username</th>
            <th>Curd Functions</th>
            <th>Date Time</th>
            
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>
    </div>
  </div>
</div>


            </div>
    </div>
</div>

            </div>


		



<!--<div id="loader" xss=removed>-->
<!--    <div class="lds-hourglass"></div>-->
<!--</div>-->


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')

<!--//Single Read Ajax-->

<script>
$(document).on('click', '.mark-read-btn', function() {
    var id = $(this).data('id');
    var button = $(this);

    $.ajax({
        url: "{{ route('backend.markSingleRead') }}",
        type: "POST",
        data: {
            _token: "{{ csrf_token() }}",
            id: id
        },
        success: function(response) {
            if(response.status){
                button.fadeOut(300, function() {
                    $(this).remove();
                });

                Lobibox.notify('success', {
                    pauseDelayOnHover: true,
                    continueDelayOnInactiveTab: false,
                    position: 'center top',
                    size: 'mini',
                    msg: response.message
                });
            } else {
                Lobibox.notify('warning', {
                    pauseDelayOnHover: true,
                    continueDelayOnInactiveTab: false,
                    position: 'center top',
                    size: 'mini',
                    msg: response.message
                });
            }
        },
        error: function(xhr){
            console.error(xhr.responseText);
            Lobibox.notify('error', {
                pauseDelayOnHover: true,
                continueDelayOnInactiveTab: false,
                position: 'center top',
                size: 'mini',
                msg: 'Something went wrong while updating!'
            });
        }
    });
});
</script>




<script>
$('#select-all').on('click', function() {
    $('.row-checkbox').prop('checked', this.checked);
});

// Delete Button click
$('#delete-selected').on('click', function() {
    var ids = [];
    $('.row-checkbox:checked').each(function() {
        ids.push($(this).val());
    });

    if (ids.length === 0) {
        alert("Please select at least one row!");
        return;
    }

    if (confirm("Are you sure you want to delete selected records?")) {
        $.ajax({
            url: "{{ route('backend.deletemultiplenotification') }}",
            type: "POST",
            data: {
                ids: ids,
                _token: "{{ csrf_token() }}"
            },
            success: function(res) {
                alert(res.message);
                $('#basic21').DataTable().ajax.reload(); 
            }
        });
    }
});
</script>


<script>
  $(document).ready(function () {
    function initSelect2(selector, options = {}) {
      const defaultOptions = {
        theme: "bootstrap-5",
        width: '100%',
        placeholder: 'Select an option',
        allowClear: true,
        minimumResultsForSearch: 0,
      };

      $(selector).select2($.extend({}, defaultOptions, options));

      $(selector).on('select2:open', function () {
        $('.select2-search__field').css({
          'font-size': '14px',
          'padding': '4px 8px'
        });
      });
    }

    // Apply Select2 to all dropdowns
    initSelect2('#feature');
    initSelect2('#activities');
    initSelect2('#username');
 
  });
</script>








<script>
$(document).ready(function(){

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    var table = $('#basic21').DataTable({
        @include('backend.include.datatableajax.datatablefilter')
        'processing': false,
        'serverSide': true,
        'serverMethod': 'POST',
        'ajax': {
            'url': "{{ asset('backend/notificationsajax') }}",
            data: function (d) {
                d.feature = $('#feature').val();
                d.activities = $('#activities').val();
                d.username = $('#username').val();
            },
        },
        'columns': [
            { data: 'id' },
            { data: "feature_id" },
            { data: "username" },
            { data: "curd_functions" },
            { data: "date_time" },
            { data: "action" }
        ]
    });

    $('#select-all').on('click', function(){
        var checked = this.checked;
        $('.row-checkbox').each(function(){
            this.checked = checked;
        });
    });

    $(document).on('change', '.row-checkbox', function(){
        if(!this.checked){
            $('#select-all').prop('checked', false);
        }
        if($('.row-checkbox:checked').length === $('.row-checkbox').length){
            $('#select-all').prop('checked', true);
        }
    });

    $('#read-status').on('click', function () {
        var selectedIds = [];
        $('.row-checkbox:checked').each(function () {
            let val = $(this).val();
            if($.isNumeric(val)) { 
                selectedIds.push(val);
            }
        });

        let confirmMessage = selectedIds.length > 0
            ? "Are you sure you want to mark the selected notifications as read?"
            : "Are you sure you want to mark ALL unread notifications as read?";

        if (!confirm(confirmMessage)) {
            return;
        }

        $.ajax({
            url: "{{ route('backend.markRead') }}",
            type: "POST",
            data: {
                _token: "{{ csrf_token() }}",
                ids: selectedIds 
            },
            success: function (response) {
                if (response.status) {
                    Lobibox.notify('success', {
                        pauseDelayOnHover: true,
                        continueDelayOnInactiveTab: false,
                        position: 'center top',
                        size: 'mini',
                        msg: response.message 
                    });
                    table.ajax.reload(null, false); 
                } else {
                    Lobibox.notify('error', {
                        pauseDelayOnHover: true,
                        continueDelayOnInactiveTab: false,
                        position: 'center top',
                        size: 'mini',
                        msg: response.message || "Something went wrong!"
                    });
                }
            },
            error: function (xhr) {
                Lobibox.notify('error', {
                    pauseDelayOnHover: true,
                    continueDelayOnInactiveTab: false,
                    position: 'center top',
                    size: 'mini',
                    msg: "AJAX request failed!"
                });
                console.log(xhr.responseText);
            }
        });
    });

});
</script>








 	<script>
	    	$(document).on('change', '.toggle-flip input[type="checkbox"]', function () {
    let status = $(this).prop('checked') ? 1 : 0;
    let userId = $(this).data('id');

    $.ajax({
        type: "POST",
        url: "{{ asset('backend/notificationstatus') }}",
        data: {
            status: status,
            id: userId,
            _token: '{{ csrf_token() }}',
        },
        success: function (response) {
            console.log("Status updated", response);
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr);
            alert("Something went wrong");
        }
    });
});
	</script>   

</body>

</html>
