

@include('backend/include/custom')


<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>


@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')
<title>Additional Settings</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->


<!--start page wrapper -->
<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3">
        <i class="bx bx-home-alt me-1 mb-1"></i>
        <span>Additional  Settings</span>
    </div>
</div>

    <div class="page-content">
        <div class="row">
            <div class="col-xl-12 mx-auto">
                            <!-- Nav tabs -->
                <div class="card">
                    <div class="bg-light border-bottom-0 pb-0 px-0">
                            <ul class="nav nav-tabs justify-content-start" id="settingsTab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active text-dark" id="others-tab" data-bs-toggle="tab" data-bs-target="#others" type="button" role="tab" aria-controls="others" aria-selected="true">
                                        SMTP Settings
                                    </button>
                                </li>
                                 <li class="nav-item" role="presentation">
                                    <button class="nav-link text-dark" id="logo-tab" data-bs-toggle="tab" data-bs-target="#logo" type="button" role="tab" aria-controls="logo" aria-selected="false">
                                    Google Settings
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
    <button class="nav-link text-dark" id="location-tab" data-bs-toggle="tab" data-bs-target="#location" type="button" role="tab" aria-controls="location" aria-selected="false">
        Location Settings
    </button>
</li>
                               
                            </ul>
                    </div>

                    <div class="card-body p-4">
                        <form class="row g-3 needs-validation" novalidate action="{{ asset('backend/additionalsettingupdate/' . Crypt::encrypt($additionalsetting->id)) }}" method="POST" enctype="multipart/form-data">
                            @csrf


                       


                            <!-- Tab panes -->
                            <div class="tab-content" id="settingsTabContent">
                               

                                <!-- Tab 1: Other Settings -->
                                <div class="tab-pane fade show active" id="others" role="tabpanel" aria-labelledby="others-tab">

                                   
                                    <section class="mb-4">
                                        
                                        <div class="row">
                                            <div class="col-md-4 mb-3">
                                               <label for="site_title" class="form-label">Port <span class="text-danger">*</span> </label>
										          <input type="text" class="form-control" id="port" name="port" required value="{{$additionalsetting->port}}" >
									        
                                            </div>
                                          
                                            <div class="col-md-4 mb-3">
                                                <label for="email" class="form-label mb-1">Email/Username</label>
                                                <div class="input-group"> <span class="input-group-text bg-transparent"><i class='bx bxs-envelope' ></i></span>
                                                <input type="text" class="form-control" id="email" name="email"  value="{{$additionalsetting->email}}" >
                                                </div>
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <label for="password" class="form-label mb-1">Password</label>
                                                <input type="text" class="form-control" id="password"  name="password" value="{{$additionalsetting->password}}" >
                                            </div>
                                            <div class="col-md-4 mb-3">
                                                <label for="host" class="form-label mb-1">Host</label>
                                                <input type="host" class="form-control" id="host" name="host"  value="{{$additionalsetting->host}}" >
                                            </div>
                                          <div class="col-md-4 mb-3">
                                                <label for="smtpsecure" class="form-label mb-1">SMTP Secure</label>
                                                <select class="form-select" id="smtpsecure" name="smtpsecure" >
                                                    <option value="">Select Option</option>
                                                    <option value="ssl" {{ ($additionalsetting->smtpsecure ?? '') == 'ssl' ? 'selected' : '' }}>SSL</option>
                                                    <option value="tls" {{ ($additionalsetting->smtpsecure ?? '') == 'tls' ? 'selected' : '' }}>TLS</option>
                                                </select>
                                            </div>
                                            


                                            <div class="col-md-4 mb-3 mt-4">
                                               <input type="number" class="form-control" id="smtpsecure_no" name="smtpsecure_no" required value="{{$additionalsetting->smtpsecure_no}}" >
                                            </div>
                                            
                                            
                                            
                                               <div class="col-12 text-end">
                               
                                <button class="btn btn-primary" type="submit" name="submit" value="submit">
                                    Update
                                </button>
                              
                            </div>
                                       
                                        </div>

                                    </section>
                                </div>
                               <div class="tab-pane fade" id="logo" role="tabpanel" aria-labelledby="logo-tab">
                                    <section class="mb-4">
                                        <div class="row mb-3">
                                           <div class="col-md-6 mb-3">
                                                <label for="host" class="form-label mb-1">Captchasitekey</label>
                                                <input type="host" class="form-control" id="host" name="captchasitekey" required value="{{$additionalsetting->captchasitekey}}" >
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="host" class="form-label mb-1">Captchasecretkey</label>
                                                <input type="host" class="form-control" id="host" name="captchasecretkey" required value="{{$additionalsetting->captchasecretkey}}" >
                                            </div>
                                              <!-- Google OAuth Keys -->
        <div class="col-md-4 mb-3">
            <label for="google_client_id" class="form-label mb-1">Google Client ID</label>
            <input type="text" class="form-control" id="google_client_id" name="google_client_id"
                required value="{{ $additionalsetting->google_client_id }}">
        </div>
        <div class="col-md-4 mb-3">
            <label for="google_client_secret" class="form-label mb-1">Google Client Secret</label>
            <input type="text" class="form-control" id="google_client_secret" name="google_client_secret"
                required value="{{ $additionalsetting->google_client_secret }}">
        </div>
        <div class="col-md-4 mb-3">
            <label for="google_redirect_url" class="form-label mb-1">Google Redirect URL</label>
            <input type="text" class="form-control" id="google_redirect_url" name="google_redirect_url"
                required value="{{ $additionalsetting->google_redirect_url }}">
        </div>
        <div class="col-md-4 mb-3">
            <label for="google_api" class="form-label mb-1">Google API</label>
            <input type="text" class="form-control" id="google_api" name="google_api"
                required value="{{ $additionalsetting->google_api }}">
        </div>
                                            
                               <div class="col-md-12 d-flex justify-content-end">
                                    <button class="btn btn-primary" type="submit" name="submit"  value="submit">
                                    Update
                                </button>
                               </div>
                                        </div>
                                    </section>
                                </div>
  <div class="tab-pane fade" id="location" role="tabpanel" aria-labelledby="location-tab">
@php
    $location = DB::table('additionalsettings')->get();
@endphp

<div class="row">
    {{-- Location API Section --}}
    <div class="col-md-3">
        <strong>Location API</strong>
    </div>
    <div class="col-md-9">
        <div class="form-check form-switch d-inline-block me-3">
            <input 
                class="form-check-input api-switch" 
                type="checkbox" 
                id="osm" 
                data-value="1" 
                data-type="api"
                {{ $location->where('location_api',1)->first() ? 'checked' : '' }}>
            <label class="form-check-label" for="osm">OpenStreetMap</label>
        </div>
        <div class="form-check form-switch d-inline-block me-3">
            <input 
                class="form-check-input api-switch" 
                type="checkbox" 
                id="google" 
                data-value="2" 
                data-type="api"
                {{ $location->where('location_api',2)->first() ? 'checked' : '' }}>
            <label class="form-check-label" for="google">Google</label>
        </div>
    </div>

    {{-- Location Functionality Section --}}
    <div class="col-md-3 mt-3">
        <strong>Location Functionality</strong>
    </div>
    <div class="col-md-9 mt-3">
        <div class="form-check form-switch d-inline-block me-3">
            <input 
                class="form-check-input api-switch" 
                type="checkbox" 
                id="reload" 
                data-value="1" 
                data-type="func"
                {{ $location->where('location_functlity',1)->first() ? 'checked' : '' }}>
            <label class="form-check-label" for="reload">Reload</label>
        </div>
        <div class="form-check form-switch d-inline-block me-3">
            <input 
                class="form-check-input api-switch" 
                type="checkbox" 
                id="ajax" 
                data-value="2" 
                data-type="func"
                {{ $location->where('location_functlity',2)->first() ? 'checked' : '' }}>
            <label class="form-check-label" for="ajax">Ajax</label>
        </div>
    </div>
     <div class="col-md-4 mt-3">
            <label for="latitude" class="form-label mb-1">Latitude</label>
            <input type="text" class="form-control" id="latitude" name="latitude"
                required value="{{ $additionalsetting->latitude }}">
        </div>
     <div class="col-md-4 mt-3">
            <label for="longitude" class="form-label mb-1">Longitude</label>
            <input type="text" class="form-control" id="longitude" name="longitude"
                required value="{{ $additionalsetting->longitude }}">
        </div>
          <div class="col-md-12 d-flex justify-content-end">
                                    <button class="btn btn-primary" type="submit" name="submit"  value="submit">
                                    Update
                                </button>
                               </div>
        
</div>
</div>
                     
                    </div>
                    </form>
                </div>
            </div>
        </div>
        <!--end row-->
    </div>
</div>
<!--end page wrapper -->


<div id="loader" style="display:none;">
    <div class="lds-hourglass"></div>
</div>




@include('backend/include/footer')
 @include('backend/include/datatableajax/tablescript')


<script>
  $(document).ready(function () {
    function initSelect2(selector, options = {}) {
      const defaultOptions = {
        theme: "bootstrap-5",
        width: '100%',
        placeholder: 'Select an option',
        allowClear: true,
        minimumResultsForSearch: 0,
      };

      $(selector).select2($.extend({}, defaultOptions, options));

      $(selector).on('select2:open', function () {
        $('.select2-search__field').css({
          'font-size': '14px',
          'padding': '4px 8px'
        });
      });
    }

    // Apply Select2 to all dropdowns
    initSelect2('#smtpsecure');
   
 
  });
</script>
<script>
$(document).on('change', '.api-switch', function () {
    let value = $(this).data('value'); // 1 or 2
    let type = $(this).data('type');
    let checked = $(this).is(':checked') ? value : 0;

    if ($(this).is(':checked')) {
        $('.api-switch[data-type="'+type+'"]').not(this).prop('checked', false);
    }

    $.ajax({
        url: "{{ route('backend.locationsetting') }}",
        method: "POST",
        data: {
            _token: "{{ csrf_token() }}",
            value: checked,
            type: type
        },
        success: function (res) {
            // console.log('Setting updated:', res);
            Lobibox.notify('success', { 
                pauseDelayOnHover: true, 
                continueDelayOnInactiveTab: false, 
                position: 'center top', 
                size: 'mini', 
                msg: res.message 
            });
        },
        error: function (err) {
            // console.error('Error updating setting:', err);
            Lobibox.notify('error', { 
                pauseDelayOnHover: true, 
                continueDelayOnInactiveTab: false, 
                position: 'center top', 
                size: 'mini', 
                msg: 'Something went wrong while updating!' 
            });
        }
    });
});
</script>



</body>

</html>




