
@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

  <!--favicon-->

  @include('backend/include/head')
  @include('backend/include/datatableajax/tablelink')

  <title>Service</title>
</head>

<body>
  <!--wrapper-->
  <div class="wrapper">
    <!--sidebar wrapper -->
    @include('backend/include/sidebar')
    <!--end sidebar wrapper -->
    <!--start header -->
    @include('backend/include/header')
    <!--end header -->

    <!--start page wrapper -->
    <div class="page-wrapper">
      <div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
        <div class="breadcrumb-title d-flex align-items-center ms-3">
          <i class="bx bx-shape-square me-1 mb-1"></i>
          <span>Services</span>
        </div>
      </div>
      <div class="page-content">

        <div class="row">
          <div class="col-xl-12">
            <div class="card">
              <div class="bg-light border-bottom-0 pb-0 px-0">
                <ul class="nav nav-tabs justify-content-start" id="settingsTab" role="tablist">
                    @if(permission(session('SUPERADMIN_ID'), '5', 'action_view'))
                  <li class="nav-item" role="presentation">
                    <button class="nav-link active text-dark" id="others-tab" data-bs-toggle="tab"
                      data-bs-target="#others" type="button" role="tab" aria-controls="others" aria-selected="true">
                      View
                    </button>
                  </li>
                  @endif
                  @if(permission(session('SUPERADMIN_ID'), '5', 'action_add'))
                  <li class="nav-item" role="presentation">
                    <button class="nav-link text-dark" id="logo-tab" data-bs-toggle="tab" data-bs-target="#logo"
                      type="button" role="tab" aria-controls="logo" aria-selected="false">
                      Add
                    </button>
                  </li>
                  @endif
                </ul>
              </div>

              <div class="card-body ">
                <div class="tab-content" id="settingsTabContent">
                  <!-- Tab 1: Logo & Images -->
                  <div class="tab-pane fade" id="logo" role="tabpanel" aria-labelledby="logo-tab">

                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-9">
                    <form class="row g-3 needs-validation" onsubmit="return myckediter()" novalidate method="post" action="{{asset('backend/servicescreate')}}" enctype="multipart/form-data">
								    @csrf
								<div class="row">
								    
								
									<div class="col-md-12">
										<label for="bsValidation1" class="form-label">Cateory Name<span class="text-danger" >*</span></label>
										<input type="text" class="form-control @error('title') is-invalid @enderror"  id="title"  name="title" required>
										<br>
									</div>
							
										<div class="col-md-4">
										<label for="bsValidation1" class="form-label">Slug<span class="text-danger" >*</span></label>
										<input type="text" class="form-control @error('slug') is-invalid @enderror" id="slug"  name="slug" required>
										<div id="slug-error" class="text-danger" ></div>
										<div class="invalid-feedback">
										@error('slug')
                                            <span class="alert text-danger">{{ $message }}</span>
                                        @enderror
										  </div>
									</div>
										<div class="col-md-4">
    <label for="bsValidation5" class="form-label"> Ordering By<span class="text-danger">*</span></label>
    <input type="number" class="form-control " id="ordering_by" name="ordering_by" required>
   
</div>
	<div class="col-md-6 mt-2" >
										<label for="bsValidation2" class="form-label">Image<span class="text-danger" >*(Only Upload Jpg,Png,WEBP)</span></label>
										<input data-value="imageerror1" type="file" class="form-control image @error('image') is-invalid @enderror" id="bsValidation2" name="image"  accept=".jpg,.png" >
									  <div class="error-message" id="imageerror1" style="color: red;"></div>
										<div class="valid-feedback">
											@error('image')
                                            <span class="alert text-danger">{{ $message }}</span>
                                        @enderror
										  </div>
									</div>
									
										<div class="col-md-6 mt-2" >
    <label for="bsValidation5" class="form-label"> Image Description <span class="text-danger">*</span></label>
    <input type="text" class="form-control image" id="img_description" data-value="imageerror1" name="img_description" required>
    <div class="invalid-feedback">
        @error('img_description')
            <span class="alert text-danger">{{ $message }}</span>
        @enderror
    </div>
</div>

									
							
									
</div>
								
								
								
                         <div class="d-md-flex justify-content-end d-grid align-items-left ">
											<button type="submit" id="submit-btn" class="btn btn-primary px-4">Submit</button>
										
										</div>       
                            </div>
                            {{-- <div class="col-md-3">
                                   <!-- Tax Section -->
            <div class="col-md-12 mt-3 p-3" style="background-color:#f5f8ff; border-left:6px solid #2e55a2; border-radius:10px;">
                <h5 class="fw-semibold mb-3" style="color:#2e55a2;">Tax Details</h5>
                <div class="row g-3">
                    <div class="col-md-12">
                        <label for="cgst" class="form-label fw-semibold">CGST (%)<span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="cgst" name="cgst" value="9" required min="0" step="0.01">
                    </div>
                     <div class="col-md-12">
                        <label for="igst" class="form-label fw-semibold">IGST (%)<span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="igst" name="igst" value="18" required min="0" step="0.01">
                    </div>
                    <div class="col-md-12">
                        <label for="sgst" class="form-label fw-semibold">SGST (%)<span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="sgst" name="sgst" value="9" required min="0" step="0.01">
                    </div>
                   
                </div>
            </div>
                            </div> --}}
                            
                            </form>
                        </div>
                    </div>

                  </div>


                  <!-- Tab 2: Other Settings -->
                  <div class="tab-pane fade show active" id="others" role="tabpanel" aria-labelledby="others-tab">
                    <div class="card-body">
                      	<div class="table-responsive">
							<table id="basic21" class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
								<thead>
									<tr>
										<th>ID</th>
										<th>Ordering By</th>
										<th>Title</th>
									    <th>Status</th>
									     <th>Action</th>
									</tr>
								</thead>
								<tbody>
								</tbody>
							</table>
						</div>
                    </div>
                  </div>
                </div>

              </div>
            </div>
          </div>

        </div>


      </div>
    </div>


   
<div id="loader" style="display:none;">
    <div class="lds-hourglass"></div>
</div>

    




    @include('backend/include/footer')
    @include('backend/include/datatableajax/tablescript')
    @include('backend/include/dynamicvalidation/slugvalidation')
<!--//Service view ajax-->
 <script>
	    $(document).ready(function(){
   
    $.ajaxSetup({
    headers: {
    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
    });  

    $('#basic21').DataTable({
          @include('backend.include.datatableajax.datatablefilter')
        'processing': false,
        'serverSide': true,
        'serverMethod': 'POST',
        'ajax': {
        'url': "{{asset('backend/servicesajax')}}",
        beforeSend: function () {
                    $('#loader').show(); 
                    },
                    complete: function () {
                    $('#loader').hide(); 
                   
                     }
        },
        'columns': [
            { data: 'id' },
            { data: 'ordering_by' },
            { data: 'title' },
			{ data: 'status' },
			{ data: 'action' },
        ]
    });
});
	</script>
	<!--//Service view ajax-->
	
	<!--Service Status-->
	<script>
	    	$(document).on('change', '.toggle-flip input[type="checkbox"]', function () {
    let status = $(this).prop('checked') ? 1 : 0;
    let userId = $(this).data('id');

    $.ajax({
        type: "POST",
        url: "{{ asset('backend/servicesstatus') }}",
        data: {
            status: status,
            id: userId,
            _token: '{{ csrf_token() }}',
        },
        success: function (response) {
            console.log("Status updated", response);
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr);
            alert("Something went wrong");
        }
    });
});
	</script>
	
		<!--Service Status-->
	
	
	
    


</body>

</html>





