@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

<!--favicon-->

@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Product Update</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->



<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1" >
    <div class="breadcrumb-title d-flex align-items-center ms-3 " >
        <i class="bx bx-package me-1"></i>
        <span class="">Promocode Incentive Price  </span>
    </div>
</div>

 
<div class="page-content">
   <div class="row">
      <div class="col-xl-12 mx-auto">
         <div class="card">
            <div class="card-body">
               <div class="text-end">
                  <button id="addRowBtn" type="button" class="btn btn-success mb-3">Add</button>
               </div>
               <form class="row needs-validation" novalidate method="POST" enctype="multipart/form-data" action="{{ asset('backend/promocodeincentivecreate') }}">
                  @csrf
                  <input type="hidden" name="promocode_id" value="{{ $promocode->id }}">
                  <table class="table table-bordered" id="pricingTable">
                     <thead class="bg-light">
                        <tr>
                           <th>Start Price</th>
                           <th>End Price</th>
                           <th>Incentive Price</th>
                           <th>Action</th>
                        </tr>
                     </thead>
                     <tbody>
                        @foreach($incentive as $data)
                        <tr>
                           <input type="hidden" name="insentiveid[]" value="{{ $data->id }}">
                           <td><input type="number" name="start_price[]" value="{{ $data->start_price }}" class="form-control start-price" required placeholder="0.00" step="0.01"></td>
                           <td><input type="number" name="end_price[]" value="{{ $data->end_price }}" class="form-control end-price" required placeholder="0.00" step="0.01"></td>
                           <td><input type="number" name="incentive_price[]" value="{{ $data->incentive_price }}" class="form-control incentive-price" required placeholder="0.00" step="0.01"></td>
                           <td>
                               <a class="btn btn-danger btn-sm px-2" onclick="return check_delete()" href="{{asset('backend/incentivedelete/'.Crypt::encrypt($data->id))}}"><i class="bx bx-trash"></i></a></td>
                           </td>
                        </tr>
                        @endforeach
                     </tbody>
                  </table>
                  <div class="text-end mt-3">
                     <button type="submit" id="savePricingBtn" class="btn btn-primary mb-3">Save</button>
                  </div>
               </form>
            </div>
         </div>
      </div>
   </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
  const addRowBtn = document.getElementById('addRowBtn');
  const pricingTable = document.getElementById('pricingTable').getElementsByTagName('tbody')[0];

  addRowBtn.addEventListener('click', function() {
    const newRow = document.createElement('tr');
    newRow.innerHTML = `
      <input type="hidden" name="insentiveid[]" value="0">
      <td><input type="number" name="start_price[]" required class="form-control start-price" placeholder="0.00" step="0.01"></td>
      <td><input type="number" name="end_price[]" required class="form-control end-price" placeholder="0.00" step="0.01"></td>
      <td><input type="number" name="incentive_price[]" required class="form-control incentive-price" placeholder="0.00" step="0.01"></td>
      <td><button type="button" class="btn btn-danger btn-sm remove-row px-2"><i class="bx bx-x"></i></button></td>
    `;
    pricingTable.appendChild(newRow);
  });

  pricingTable.addEventListener('click', function(e) {
    if (e.target.closest('.remove-row')) {
      e.target.closest('tr').remove();
    }
  });
});
</script>
@endpush


</div>


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')




</body>

</html>