@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

<!--favicon-->

@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Product Update</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->



<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1" >
    <div class="breadcrumb-title d-flex align-items-center ms-3 " >
        <i class="bx bx-package me-1"></i>
        <span class="">Promocode Update</span>
    </div>
</div>

 
<div class="page-content">
   <div class="row">
					<div class="col-xl-12 mx-auto">
						<div class="card">
						
						
							<div class="card-body">
  <form class="row g-3 needs-validation" onsubmit="return myckediter()" id="formatDistrict-update" method="POST" action="{{ asset('backend/promocodeupdate/' . Crypt::encrypt($promocode->id)) }}" enctype="multipart/form-data" novalidate>
    @csrf
    <section class="mb-4">
<div class="row g-3"> <!-- Added spacing between inputs -->

    <!-- Title -->
    
   	<div class="col-md-4">
										<label for="bsValidation1" class="form-label">Title<span class="text-danger" >*</span></label>
										<input type="text" class="form-control @error('title') is-invalid @enderror" value="{{$promocode->title}}" id="title"  name="title" required>
									
									</div>

    <!-- Promocode Type -->
    <div class="col-md-4">
        <label for="promocode_type" class="form-label">Promocode Type <span class="text-danger">*</span></label>
        <select class="form-select" id="promocode_type" name="promocode_type" required>
            <option value="">Select Option</option>
            <option value="1" {{ $promocode->promocode_type == 1 ? 'selected' : '' }}>Fixed Price</option>
<option value="2" {{ $promocode->promocode_type == 2 ? 'selected' : '' }}>Percentage</option>

        </select>
    </div>
	<div class="col-md-4">
    <label for="promocode_status" class="form-label">Payment Type <span class="text-danger">*</span></label>
    <select class="form-select" id="promocode_status" name="promocode_status" required>
        <option value="">Select Payment Type</option>
        <option value="1" {{ isset($promocode) && $promocode->promocode_status == 1 ? 'selected' : '' }}>Cash</option>
        <option value="2" {{ isset($promocode) && $promocode->promocode_status == 2 ? 'selected' : '' }}>Online</option>
        <option value="3" {{ isset($promocode) && $promocode->promocode_status == 3 ? 'selected' : '' }}>Any</option>
    </select>
</div>
    <!-- Price / Percentage -->
    <div class="col-md-4">
        <label for="pricr_per" class="form-label">Price & Percentage <span class="text-danger">*</span></label>
        <input type="text" class="form-control" id="pricr_per" value="{{$promocode->pricr_per}}" name="pricr_per" required oninput="this.value = this.value.replace(/[^0-9]/g, '')">
    </div>


    <!-- Promocode -->
    <div class="col-md-4">
        <label for="promocode" class="form-label">Promocode <span class="text-danger">*</span></label>
        <input type="text" class="form-control" id="promocode" value="{{$promocode->promocode}}" name="promocode" required>
    </div>

    <!-- Use Range Limit -->
    <div class="col-md-4">
        <label for="use_range" class="form-label">Use Range Limit <span class="text-danger">*</span></label>
        <input type="text" class="form-control" id="use_range" value="{{$promocode->use_range}}" name="use_range" required oninput="this.value = this.value.replace(/[^0-9]/g, '')">
    </div>

    <!-- User Range Limit -->
    <div class="col-md-6">
        <label for="user_range" class="form-label">User Range Limit <span class="text-danger">*</span></label>
        <input type="text" class="form-control" id="user_range" value="{{$promocode->user_range}}" name="user_range" required oninput="this.value = this.value.replace(/[^0-9]/g, '')">
    </div>

    <!-- Start Date -->
    <div class="col-md-6">
        <label for="startdate" class="form-label">Valid Start Date <span class="text-danger">*</span></label>
        <input type="text" id="startdate" class="form-control datepicker" value="{{$promocode->startdate}}" name="startdate" required />
    </div>

    <!-- End Date -->
    <div class="col-md-6">
        <label for="enddate" class="form-label">Valid End Date <span class="text-danger">*</span></label>
        <input type="text" id="enddate" class="form-control datepicker" value="{{$promocode->enddate}}" name="enddate" required />
    </div>

    <!-- Ordering By -->
    <div class="col-md-6">
        <label for="ordering_by" class="form-label">Ordering By</label>
        <input type="number" class="form-control" id="ordering_by" value="{{$promocode->ordering_by}}" name="ordering_by">
    </div>

    <!-- Countries -->
    <div class="col-md-3">
        <label for="countries" class="form-label">Countries</label>
        <select class="form-select" name="countries" id="countries">
            <option value="">Select Countries</option>
        @foreach($country as $countryData)
            <option value="{{$countryData->countries_id}}" @if($countryData->countries_id == $promocode->countries) selected @endif>
                {{$countryData->name}}
            </option>
        @endforeach
        </select>
    </div>

    <!-- State -->
    <div class="col-md-3">
        <label for="state" class="form-label">State</label>
        <select name="state" class="form-select" id="state">
         <option value="">Select State</option>
        @php
            $states = DB::table('tbl_states')
                ->where('country_id', $promocode->countries)
                ->where('s_status', '1')
                ->get();
        @endphp
        @foreach($states as $stateData)
            <option value="{{ $stateData->state_id }}" 
                @if($promocode->state ==$stateData->state_id  ) selected @endif>
                {{ $stateData->name }}
            </option>
        @endforeach

        </select>
    </div>

    <!-- City -->
    <div class="col-md-3">
        <label for="city" class="form-label">City</label>
        <select name="city" class="form-select" id="city">
             <option value="">Select City</option>
             @php
            $city = DB::table('tbl_cities')->where('stateid', $promocode->state)->where('city_status', '1')
                ->get();
        @endphp
        
         @foreach($city as $cityData)
            <option value="{{ $cityData->city_id }}" 
                @if($promocode->city ==$cityData->city_id  ) selected @endif>
                {{ $cityData->name }}
            </option>
        @endforeach
       
        </select>
    </div>

    <!-- Pincode -->
 <div class="col-md-3">
    <label for="pincode" class="form-label">Pincode</label>
    <select name="pincode" class="form-select" id="pincode">
        <option value="">Select Pincode</option>
        @php
            $pincodes = DB::table('pincodes')
                ->where('city', $promocode->city)
                ->where('status', '1')
                ->get();
        @endphp

        @foreach($pincodes as $pincodeData)
            <option value="{{ $pincodeData->pincode }}" 
                @if($promocode->pincode == $pincodeData->id) selected @endif>
                {{ $pincodeData->pincode }}
            </option>
        @endforeach
    </select>
</div>


    <!-- Service -->
   <div class="col-md-3">
    <label for="service_id" class="form-label">Service</label>
    <select class="form-select" name="service_id" id="service_id">
        <option value="">Select Service</option>
        @php
            // Page load par selected city ke services populate
            $serviceIds = DB::table('serviceallottedcities')->where('countries_id', $promocode->countries)->where('state_id', $promocode->state)->where('city_id', $promocode->city)->where('status','1') ->where('service_type', '1') ->pluck('serviceid');

            $services = DB::table('services')->whereIn('id', $serviceIds)->where('status', '1')->select('id', 'title')->get();
        @endphp

        @foreach($services as $service)
            <option value="{{ $service->id }}" 
                @if($promocode->service_id == $service->id) selected @endif>
                {{ $service->title }}
            </option>
        @endforeach
    </select>
</div>

    <!-- Subservice -->
   <div class="col-md-3">
    <label for="subservice_id" class="form-label">Subservice</label>
    <select name="subservice_id" class="form-select" id="subservice_id">
        <option value="">Select Subservice</option>
        @if($promocode->service_id)
            @php
                $subserviceIds = DB::table('subservices')->where('service_id', $promocode->service_id)->where('status','1')->pluck('id');

                $allowedSubserviceIds = DB::table('serviceallottedcities')
                    ->where('countries_id', $promocode->countries)
                    ->where('state_id', $promocode->state)
                    ->where('city_id', $promocode->city)
                    ->where('status','1')
                    ->where('service_type','2')
                    ->whereIn('serviceid',$subserviceIds)
                    ->pluck('serviceid');

                $subservices = DB::table('subservices')->whereIn('id', $allowedSubserviceIds)->get();
            @endphp

            @foreach($subservices as $sub)
                <option value="{{ $sub->id }}" 
                    @if($promocode->subservice_id == $sub->id) selected @endif>
                    {{ $sub->title }}
                </option>
            @endforeach
        @endif
    </select>
</div>

<!-- Child Service -->
<div class="col-md-3">
    <label for="childservice_id" class="form-label">Child Service</label>
    <select name="childservice_id" class="form-select" id="childservice_id">
        <option value="">Select Child Service</option>
        @if($promocode->subservice_id)
            @php
                $childIds = DB::table('child_services')->where('subservice_id', $promocode->subservice_id)->where('status','1')->pluck('id');

                $allowedChildIds = DB::table('serviceallottedcities')
                    ->where('countries_id', $promocode->countries)
                    ->where('state_id', $promocode->state)
                    ->where('city_id', $promocode->city)
                    ->where('status','1')
                    ->where('service_type','3')
                    ->whereIn('serviceid',$childIds)
                    ->pluck('serviceid');

                $childservices = DB::table('child_services')->whereIn('id', $allowedChildIds)->get();
            @endphp

            @foreach($childservices as $child)
                <option value="{{ $child->id }}" 
                    @if($promocode->childservice_id == $child->id) selected @endif>
                    {{ $child->title }}
                </option>
            @endforeach
        @endif
    </select>
</div>

<!-- Service Plan -->
<div class="col-md-3">
    <label for="serviceplan_id" class="form-label">Service Plan</label>
    <select name="serviceplan_id" class="form-select" id="serviceplan_id">
        <option value="">Select Plan</option>
        @if($promocode->subservice_id)
            @php
                $planIds = DB::table('service_plans')->where('subservice_id', $promocode->subservice_id)->where('status','1')->pluck('id');

                $allowedPlanIds = DB::table('serviceallottedcities')->where('countries_id', $promocode->countries)->where('state_id', $promocode->state)->where('city_id', $promocode->city)->where('status','1')->where('service_type','4')->whereIn('serviceid',$planIds)->pluck('serviceid');

                $plans = DB::table('service_plans')->whereIn('id',$allowedPlanIds)->get();
            @endphp

            @foreach($plans as $plan)
                <option value="{{ $plan->id }}" 
                    @if($promocode->serviceplan_id == $plan->id) selected @endif>
                    {{ $plan->title }}
                </option>
            @endforeach
        @endif
    </select>
</div>


<div style="border: 1px solid #ced4da; border-radius: 5px; display: flex; align-items: center; padding: 10px;">
    <div class="col-md-3" style="border-right: 1px solid #ced4da; padding-right: 10px;">
        <strong>Incentive Price Status <span class="text-danger">*</span></strong>
    </div>
    <div class="col-md-9" style="padding-left: 10px;">
        <div class="form-check form-check-inline">
            <input class="form-check-input" type="radio" name="incentive_status" id="incentiveActive" required  value="1" 
                {{ $promocode->incentive_status == 1 ? 'checked' : '' }}>
            <label class="form-check-label" for="incentiveActive">Active Incentive Price</label>
        </div>
        <div class="form-check form-check-inline">
            <input class="form-check-input" type="radio" name="incentive_status" id="incentiveInactive" required value="0" 
                {{ $promocode->incentive_status == 0 ? 'checked' : '' }}>
            <label class="form-check-label" for="incentiveInactive">Inactive Incentive Price</label>
        </div>
    </div>
</div>
 <div class="text-end">
                  <button id="addRowBtn" type="button" class="btn btn-success mb-3">Add</button>
               </div>

  <input type="hidden" name="promocode_id" value="{{ $promocode->id }}">
                  <table class="table table-bordered" id="pricingTable">
                     <thead class="bg-light">
                        <tr>
                           <th>Start Price</th>
                           <th>End Price</th>
                           <th>Incentive Price</th>
                           <th>Action</th>
                        </tr>
                     </thead>
                     <tbody>
                        @foreach($incentive as $data)
                        <tr>
                           <input type="hidden" name="insentiveid[]" value="{{ $data->id }}">
                           <td><input type="number" name="start_price[]" value="{{ $data->start_price }}" class="form-control start-price" required placeholder="0.00" step="0.01"></td>
                           <td><input type="number" name="end_price[]" value="{{ $data->end_price }}" class="form-control end-price" required placeholder="0.00" step="0.01"></td>
                           <td><input type="number" name="incentive_price[]" value="{{ $data->incentive_price }}" class="form-control incentive-price" required placeholder="0.00" step="0.01"></td>
                           <td>
                               <a class="btn btn-danger btn-sm px-2" onclick="return check_delete()" href="{{asset('backend/incentivedelete/'.Crypt::encrypt($data->id))}}"><i class="bx bx-trash"></i></a></td>
                           </td>
                        </tr>
                        @endforeach
                     </tbody>
                  </table>
                 
    <!-- Submit Button -->
    <div class="col-12 text-end mt-3">
        <button class="btn btn-primary" type="submit" id="savePricingBtn" name="submit" value="submit">
            Update
        </button>
    </div>

</div>

    </section>
  </form>
							</div>
						</div>
					</div>
				</div>
</div>
</div>

	

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
  const addRowBtn = document.getElementById('addRowBtn');
  const pricingTable = document.getElementById('pricingTable').getElementsByTagName('tbody')[0];
  const incentiveRadios = document.querySelectorAll('input[name="incentive_status"]');

  function updateRequired() {
    const isActive = document.getElementById('incentiveActive').checked;
    document.querySelectorAll('.start-price, .end-price, .incentive-price').forEach(input => {
      if(isActive){
        input.setAttribute('required','required');
      } else {
        input.removeAttribute('required');
      }
    });
  }

  // On page load
  updateRequired();

  // On status change
  incentiveRadios.forEach(radio => {
    radio.addEventListener('change', updateRequired);
  });

  // Add new row
  addRowBtn.addEventListener('click', function() {
    const newRow = document.createElement('tr');
    newRow.innerHTML = `
      <input type="hidden" name="insentiveid[]" value="0">
      <td><input type="number" name="start_price[]" class="form-control start-price" placeholder="0.00" step="0.01"></td>
      <td><input type="number" name="end_price[]" class="form-control end-price" placeholder="0.00" step="0.01"></td>
      <td><input type="number" name="incentive_price[]" class="form-control incentive-price" placeholder="0.00" step="0.01"></td>
      <td><button type="button" class="btn btn-danger btn-sm remove-row px-2"><i class="bx bx-x"></i></button></td>
    `;
    pricingTable.appendChild(newRow);
    updateRequired(); // Apply required if status active
  });

  // Remove row
  pricingTable.addEventListener('click', function(e) {
    if (e.target.closest('.remove-row')) {
      e.target.closest('tr').remove();
    }
  });
});
</script>
@endpush
@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')

<script>
$(document).ready(function () {

    // On country change
    $('#countries').change(function () {
        const countryId = $(this).val();
        if (countryId) {
            $.ajax({
                url: '{{ url("backend/promocodestatebycity") }}',
                method: 'GET',
                data: { country_id: countryId },
                beforeSend: () => $('#loader').show(),
                success: function (response) {
                    let options = '<option value="">Select State</option>';
                    response.states.forEach(item => {
                        options += `<option value="${item.state_id}">${item.name}</option>`;
                    });
                    $('#state').html(options);
                    $('#city, #pincode, #service_id, #subservice_id, #childservice_id, #serviceplan_id').html('<option value="">Select</option>');
                },
                complete: () => $('#loader').hide()
            });
        }
    });

    // On state change
    $('#state').change(function () {
        const stateId = $(this).val();
        const countryId = $('#countries').val();
        if (stateId) {
            $.ajax({
                url: '{{ url("backend/promocodestatebycity") }}',
                method: 'GET',
                data: { state_id: stateId, country_id: countryId },
                beforeSend: () => $('#loader').show(),
                success: function (response) {
                    let options = '<option value="">Select City</option>';
                    response.cities.forEach(item => {
                        options += `<option value="${item.city_id}">${item.name}</option>`;
                    });
                    $('#city').html(options);
                    $('#pincode, #service_id, #subservice_id, #childservice_id, #serviceplan_id').html('<option value="">Select</option>');
                },
                complete: () => $('#loader').hide()
            });
        }
    });

    // On city change
    $('#city').change(function () {
        const cityId = $(this).val();
        const countryId = $('#countries').val();
        const stateId = $('#state').val();

        if (cityId) {
            $.ajax({
                url: '{{ url("backend/promocodestatebycity") }}',
                method: 'GET',
                data: { city_id: cityId, country_id: countryId, state_id: stateId },
                beforeSend: () => $('#loader').show(),
                success: function (response) {
                    let pincodeOptions = '<option value="">Select Pincode</option>';
                    response.pincodes.forEach(item => {
                        pincodeOptions += `<option value="${item.id}">${item.pincode}</option>`;
                    });
                    $('#pincode').html(pincodeOptions);

                    let serviceOptions = '<option value="">Select Service</option>';
                    response.services.forEach(item => {
                        serviceOptions += `<option value="${item.id}">${item.title}</option>`;
                    });
                    $('#service_id').html(serviceOptions);

                    $('#subservice_id, #childservice_id, #serviceplan_id').html('<option value="">Select</option>');
                },
                complete: () => $('#loader').hide()
            });
        }
    });

    // On service change
    $('#service_id').change(function () {
        const serviceId = $(this).val();
        const countryId = $('#countries').val();
        const stateId = $('#state').val();
        const cityId = $('#city').val();

        if (serviceId) {
            $.ajax({
                url: '{{ url("backend/promocodestatebycity") }}',
                method: 'GET',
                data: { service_id: serviceId, country_id: countryId, state_id: stateId, city_id: cityId },
                beforeSend: () => $('#loader').show(),
                success: function (response) {
                    let subOptions = '<option value="">Select Subservice</option>';
                    response.subservices.forEach(item => {
                        subOptions += `<option value="${item.id}">${item.title}</option>`;
                    });
                    $('#subservice_id').html(subOptions);
                    $('#childservice_id, #serviceplan_id').html('<option value="">Select</option>');
                },
                complete: () => $('#loader').hide()
            });
        }
    });

    // On subservice change → get childservices + plans
   // On subservice change → get childservices + plans
$('#subservice_id').change(function () {
    const subserviceId = $(this).val();
    const countryId = $('#countries').val();
    const stateId = $('#state').val();
    const cityId = $('#city').val();

    if (subserviceId) {
        $.ajax({
            url: '{{ url("backend/promocodestatebycity") }}',
            method: 'GET',
            data: { subservice_id: subserviceId, country_id: countryId, state_id: stateId, city_id: cityId },
            beforeSend: () => $('#loader').show(),
            success: function (response) {
              
                let childOptions = '<option value="">Select Child Service</option>';
                response.childservices.forEach(item => {
                    childOptions += `<option value="${item.id}">${item.title}</option>`;
                });
                $('#childservice_id').html(childOptions);

               
                let planOptions = '<option value="">Select Plan</option>';
                response.plans.forEach(item => {
                    planOptions += `<option value="${item.id}">${item.title}</option>`;
                });
                $('#serviceplan_id').html(planOptions);
            },
            complete: () => $('#loader').hide()
        });
    }
});


});
</script>

<script>
    $(document).ready(function() {
        let startDatePicker = flatpickr("#startdate", {
            dateFormat: "d-m-Y",
            minDate: "today", 
            onChange: function(selectedDates, dateStr, instance) {
               
                endDatePicker.set("minDate", dateStr);
            }
        });

        let endDatePicker = flatpickr("#enddate", {
            dateFormat: "d-m-Y",
            minDate: "today"
        });
    });
</script>

<script>
  $(document).ready(function () {
      
    function initSelect2(selector, options = {}) {
      $(selector).select2($.extend({
        theme: "bootstrap-5",
        width: $(selector).data('width') ? $(selector).data('width') : $(selector).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(selector).data('placeholder'),
      }, options));
    }
    initSelect2('#countries');
    initSelect2('#state');
    initSelect2('#city');
    initSelect2('#pincode');
    initSelect2('#service_id');
    initSelect2('#subservice_id');
    initSelect2('#childservice_id');
    initSelect2('#serviceplan_id');
  });
</script>


</body>

</html>