




@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

<!--favicon-->

@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Product Update</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->



<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1" >
    <div class="breadcrumb-title d-flex align-items-center ms-3 " >
        <i class="bx bx-package me-1"></i>
        <span class="">Product Update</span>
    </div>
</div>

 
<div class="page-content">
   <div class="row">
					<div class="col-xl-12 mx-auto">
						<div class="card">
						
						
							<div class="card-body">
  <form class="row g-3 needs-validation" onsubmit="return myckediter()" id="formatDistrict-update" method="POST" action="{{ asset('backend/productupdate/' . Crypt::encrypt($product->id)) }}" enctype="multipart/form-data" novalidate>
    @csrf
    <section class="mb-4">
      <div class="row">
        <!-- Service Select -->
									<div class="col-md-4 mb-3">
										<label for="bsValidation1" class="form-label"> Services<span class="text-danger" >*</span></label>
									<select class="form-select @error('title') is-invalid @enderror" id="service_id" name="service_id" required>
    <option value="">Select Option</option>
    @foreach($services as $data)
<option value="{{ $data->id }}" {{ $product->service_id == $data->id ? 'selected' : '' }}>
    {{ $data->title }}
</option>
    @endforeach
    </select>
									
									</div>
									<div class="col-md-4 mb-3">
										<label for="bsValidation1" class="form-label"> Subservices<span class="text-danger" >*</span></label>
									<select class='form-control' value="" name="subservice_id" id="subservice_id" required>
									   {!! serviceOptions('subservice', $product->subservice_id ?? '') !!}

									</select>
									</div>

				<div class="col-md-4 mb-3">
					<label for="bsValidation1" class="form-label"> Brand<span class="text-danger">*</span></label>
					<select class='form-control'  name="brand_id"
						id="brand_id" required>
						{!! serviceOptions('brand', $product->brand_id ?? '') !!}
					</select>
				</div>



				<!-- Product Item -->
				<div class="col-md-6 mb-3">
					<label for="product_item" class="form-label">Product Item <span class="text-danger">*</span></label>
					<input type="text" class="form-control @error('product_item') is-invalid @enderror"
						id="title" value="{{$product->product_item}}" name="product_item" required>
					<div class="invalid-feedback">
						@error('product_item')
						<span class="alert text-danger">{{ $message }}</span>
						@enderror
					</div>
				</div>

<!-- Slug -->
<div class="col-md-6 mb-3">
  <label for="slug" class="form-label">Slug<span class="text-danger">*</span></label>
  <input type="text"  class="form-control @error('slug') is-invalid @enderror" id="slug" value="{{$product->slug}}"  name="slug" required>
  <div id="slug-error" class="text-danger"></div>
  <div class="invalid-feedback">
    @error('slug')
      <span class="alert text-danger">{{ $message }}</span>
    @enderror
  </div>
</div>


<div class="col-md-4 mb-3">
    <label for="image" class="form-label">Product Image
        <span class="text-danger">*(JPG, PNG, WEBP)</span>
    </label>
    
    <div class="input-group">
        <input 
            type="file" data-value="imageerror1" type="file" class="form-control image @error('image') is-invalid @enderror" 
            id="image" 
            name="image" 
            accept=".jpg,.jpeg,.png,.webp"
        >

        @if(isset($product->image))
            <a href="{{ asset('uploads/product/' . $product->image) }}" 
               data-fancybox="image" 
               data-caption="">
                <img src="{{ asset('uploads/product/' . $product->image) }}" 
                     alt="" 
                     style="width: 50px; height: 38px; margin-left: 10px;" />
            </a>
        @endif
    </div>

									  <div class="error-message" id="imageerror1" style="color: red;"></div>
										<div class="valid-feedback">
											@error('image')
                                            <span class="alert text-danger">{{ $message }}</span>
                                        @enderror
										  </div>
</div>
<div class="col-md-4">
    <label for="bsValidation2" class="form-label">
        Multiple Image 
        <span class="text-danger">( Jpg, Png, WEBP)</span>
    </label>
    <div class="d-flex ">
        <input data-value="imageerror2" type="file"  class="form-control image"  id="multiple_image"  name="multiple_image[]" multiple    accept=".jpg,.png,.webp">

        @if(isset($product->multiple_image))
            @php
               
                $images = is_array($product->multiple_image) ? 
                          $product->multiple_image : 
                          json_decode($product->multiple_image, true);


                if(!is_array($images)){
                    $images = explode(',', $product->multiple_image);
                }
            @endphp

            @foreach($images as $img)
                <a href="{{ asset('uploads/product/'.$img) }}"  data-fancybox="gallery" data-caption=""><img src="{{ asset('uploads/product/'.$img) }}" alt="image"style="width: 50px; height: 38px; margin: 5px; object-fit: cover;"></a>
            @endforeach
        @endif  
    </div>

    <div class="error-message" id="imageerror1" style="color: red;"></div>
</div>
<div class="col-md-4">
    <label for="bsValidation5" class="form-label"> Image Description <span class="text-danger">*</span></label>
    
    <input type="text" class="form-control" id="img_description" name="img_description" value="{{$product->img_description}}" required>
    
    
</div>




				<div class="col-md-4 mb-3">
					<label for="default_price" class="form-label">Default Price<span class="text-danger">*</span></label>
					<input type="text" step="0.01" class="form-control @error('default_price') is-invalid @enderror"
						id="default_price" value="{{$product->default_price}}" oninput="this.value = this.value.replace(/[^0-9]/g, '')" name="default_price" required>
					<div class="invalid-feedback">
						@error('default_price')
						<span class="alert text-danger">{{ $message }}</span>
						@enderror
					</div>
				</div>
    <div class="col-md-4 mb-3">
        <label for="mrp_price" class="form-label">
            MRP <span class="text-danger">*</span>
        </label>
        <input type="text" step="0.01"
               class="form-control @error('mrp_price') is-invalid @enderror" id="mrp_price" name="mrp_price"
               oninput="this.value = this.value.replace(/[^0-9]/g, '')" value="{{$product->mrp_price}}"
               required>
        <div class="invalid-feedback">
            @error('mrp_price')
            <span class="alert text-danger">{{ $message }}</span>
            @enderror
        </div>
    </div>

				<!-- Ordering By -->
				<div class="col-md-4 mb-3">
					<label for="ordering_by" class="form-label">Ordering By <span class="text-danger">*</span></label>
					<input type="number" class="form-control @error('ordering_by') is-invalid @enderror"
						id="ordering_by" value="{{$product->ordering_by}}" name="ordering_by" required>
					<div class="invalid-feedback">
						@error('ordering_by')
						<span class="alert text-danger">{{ $message }}</span>
						@enderror
					</div>
				</div>

								


<div class="col-md-12 mb-3">
  <label for="description" class="form-label">Description</label>
  <!-- Hidden field to store Quill HTML content on submit -->
  <textarea name="description" class="d-none" id="description">{{ $product->description }}</textarea>

  <!-- Editor container with fixed height and styling -->
  <div id="editor-container" style="height: 200px; border: 1px solid #ced4da; border-radius: 4px;">{!!$product->description!!}</div>
</div>
  <div class="col-md-6 mb-3">
    <label for="meta_title" class="form-label">Meta Title<span class="text-danger">*</span></label>
    <input type="text" name="meta_title" id="metatitle" class="form-control" value="{{ $product->meta_title }}" placeholder="" required>
  </div>

  <div class="col-md-6 mb-3">
    <label for="meta_keyword" class="form-label">Meta Keywords</label>
    <input type="text" name="meta_keyword" id="meta_keyword" class="form-control" value="{{ $product->meta_keyword }}" placeholder="">
  </div>
    <div class="col-md-12 mb-3">
    <label for="meta_description" class="form-label">Meta Description</label>
    <textarea name="meta_description" id="meta_description" class="form-control" rows="3" placeholder="">{{ $product->meta_description }}</textarea>
  </div>
        <div class="col-12 text-end">
<button class="btn btn-primary" type="submit" id="submit-btn" name="submit" value="submit">
  Update
</button>
        </div>
      </div>
    </section>
  </form>
							</div>
						</div>
					</div>
				</div>
</div>
</div>

	


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')
@include('backend/include/subservicebychildservice/subservicebychildservice')
@include('backend/include/dynamicvalidation/slugvalidation')
	




</body>

</html>


		










