
@include('backend/include/custom')


<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>


@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Product</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->


<!--start page wrapper -->
<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3">
        <i class="bx bx-package me-1"></i>
        <span>Product</span>
    </div>
</div>
<div class="page-content">
<div class="row row-cols-1 row-cols-md-2 row-cols-xl-5">
    @if(permission(session('SUPERADMIN_ID'), '16', 'action_add'))
                <!--['color' => 'info', 'label' => 'Total Service', 'value' => $servicescount, 'icon' => 'bx bx-list-check'],-->
                <!--['color' => 'danger', 'label' => 'Active Service', 'value' => $activeservice, 'icon' => 'bx bx-check-circle'],-->
        @php
            $boxes = [
                ['color' => 'success', 'label' => 'Total Product', 'value' => $productcount, 'icon' => 'bx bx-box'],
                ['color' => 'warning', 'label' => 'Active Product', 'value' => $activeproduct, 'icon' => 'bx bx-cart'],
                ['color' => 'danger', 'label' => 'Inactive Product', 'value' => $inactiveproduct, 'icon' => 'bx bx-block'],
            ];
        @endphp

        @foreach($boxes as $box)
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-{{ $box['color'] }}" style="width: 200px;">
                    <div class="card-body py-2 px-2"> {{-- Reduced vertical padding --}}
                        <div class="text-center">
                            <div class="d-flex align-items-center justify-content-center gap-2">
                                <i class="{{ $box['icon'] }} fs-5 text-{{ $box['color'] }}"></i> {{-- Slightly smaller icon --}}
                                <span class="text-secondary" style="font-size: 0.85rem; white-space: nowrap;">
                                    {{ $box['label'] }}:
                                    <span class="text-{{ $box['color'] }}" style="font-weight: 600;">
                                        {{ $box['value'] }}
                                    </span>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    @endif
</div>

        <div class="row">
            <div class="col-xl-12 mx-auto">
                            <!-- Nav tabs -->
<div class="card">
    <!-- Tabs Header -->
    <div class="bg-light border-bottom-0 pb-0 px-0">
        <ul class="nav nav-tabs" id="settingsTab" role="tablist">
            @if(permission(session('SUPERADMIN_ID'), '16', 'action_view'))
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="others-tab" data-bs-toggle="tab" data-bs-target="#others" type="button" role="tab" aria-controls="others" aria-selected="true">
                    View
                </button>
            </li>
            @endif
            @if(permission(session('SUPERADMIN_ID'), '16', 'action_add'))
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="logo-tab" data-bs-toggle="tab" data-bs-target="#logo" type="button" role="tab" aria-controls="logo" aria-selected="false">
                    Add
                </button>
            </li>
            @endif
        </ul>
    </div>

    <!-- Tabs Content -->
    <div class="card-body p-4">

            <div class="tab-content" id="settingsTabContent">
<div class="tab-pane fade show active" id="others" role="tabpanel" aria-labelledby="others-tab">
  <div class="card-body">
    <div class="table-responsive">
      <table id="basic21"  class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
        <thead>
          <tr class="hello1">
            <th>ID</th>
            <th>Ordering By</th>
            <th>Service</th>
            <!--<th>Subservice</th>-->
            <th>Brand</th>
            <th>Product Item</th>
            <th>Product Image</th>
            <!--<th>Meta Title</th>-->
            <!--<th>Meta Keyword</th>-->
            <th>Price</th>
            <!--<th>mrp_price</th>-->
            <th>Status</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>
    </div>
  </div>
</div>


<div class="switcher-wrapper">
    @if(permission(session('SUPERADMIN_ID'), '16', 'action_view'))
        <div class="switcher-btn">
            <i class='bx bx-filter-alt'></i>
        </div>
    @endif

    <div class="card">
        <div class="card-header text-capitalize usbb d-flex align-items-center">
            <h4 class="mb-0 text-white">Filter</h4>
            <button type="button" class="btn-close ms-auto close-switcher bg-white" aria-label="Close"></button>
        </div>

        <div class="switcher-body">
            @php
                if(!empty($_GET['service_id'])){
                    $filterservice_id = $_GET['service_id'];
                } else {
                    $filterservice_id = "";
                }
                if(!empty($_GET['subservice_id'])){
                    $filtersubservice_id = $_GET['subservice_id'];
                } else {
                    $filtersubservice_id = "";
                }
                if(!empty($_GET['brand_id'])){
                    $filterbrand_id = $_GET['brand_id'];
                } else {
                    $filterbrand_id = "";
                }
               if (isset($_GET['status']) && $_GET['status'] !== '') {
    $status = $_GET['status'];
} else {
    $status = "";
}

            @endphp

            <form class="row g-3 needs-validation" id="filterForm" novalidate style="margin-top: -16px;">
                <div class="col-md-12">
                    	<label for="bsValidation1" class="form-label"> Services</label>
					<select class="form-select @error('title') is-invalid @enderror" id="filterservice_id" name="service_id"
						required>
						<option value="">Select Service </option>
						@foreach($services as $data)
						<option value="{{$data->id}}"@if($filterservice_id == $data->id) selected @endif>{{$data->title}}</option>
						@endforeach
					</select>
                </div>
                

				<div class="col-md-12">
					<label for="bsValidation1" class="form-label"> Subservices<span class="text-danger">*</span></label>
					<select class='form-control @error(' subservice_id') is-invalid @enderror' name="subservice_id"
						id="filtersubservice_id" required>
						{!! serviceOptions('subservice', $filtersubservice_id ?? '') !!}
	
					</select>
				</div>
                <div class="col-md-12">
                   	<label for="bsValidation1" class="form-label"> Brand <span class="text-danger">*</span></label>
					<select class='form-select @error(' brand_id') is-invalid @enderror' name="brand_id"
						id="filterbrand_id" required>
					{!! serviceOptions('brand', $filterbrand_id ?? '') !!}
			
					</select>
                </div>
               <div class="col-md-12 mb-3">
    <label for="status" class="form-label">Status</label>
    <select class="form-select @error('status') is-invalid @enderror" name="status" id="status">
        <option value="">Select Status</option>
        <option value="1" {{ $status === '1' ? 'selected' : '' }}>Active</option>
        <option value="0" {{ $status === '0' ? 'selected' : '' }}>Inactive</option>
    </select>
</div>


                <div class="col-md-12"></div>
                <div class="col-md-8">
                    <div>
                        <button type="submit" id="submitBtn" class="btn btn-primary px-3">Apply</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="tab-pane fade" id="logo" role="tabpanel" aria-labelledby="logo-tab">
	<form class="row g-3 needs-validation" onsubmit="return myckediter()" id="formatDistrict-update" method="POST"
		action="{{asset('backend/productcreate')}}" enctype="multipart/form-data" novalidate>
		@csrf
		<section class="mb-4">
			<div class="row">
				<!-- Service Select -->
				<div class="col-md-4 mb-3">
					<label for="bsValidation1" class="form-label"> Services<span class="text-danger">*</span></label>
					<select class="form-select @error('title') is-invalid @enderror" id="service_id" name="service_id"
						required>
						<option value="">Select Service </option>
						@foreach($services as $data)
						<option value="{{$data->id}}">{{$data->title}}</option>
						@endforeach
					</select>

				</div>
				<div class="col-md-4 mb-3">
					<label for="bsValidation1" class="form-label"> Subservices<span class="text-danger">*</span></label>
					<select class='form-control @error(' subservice_id') is-invalid @enderror' name="subservice_id"
						id="subservice_id" required>
						<option value="" selected disable>Select Subservice</option>
					</select>
				</div>
				<div class="col-md-4 mb-3">
					<label for="bsValidation1" class="form-label"> Brand<span class="text-danger">*</span></label>
					<select class='form-control @error(' brand_id') is-invalid @enderror' name="brand_id"
						id="brand_id" required>
						<option value="" selected disable>Select Brand</option>
					</select>
				</div>



				<!-- Product Item -->
				<div class="col-md-6 mb-3">
					<label for="product_item" class="form-label">Product Item <span class="text-danger">*</span></label>
					<input type="text" class="form-control @error('product_item') is-invalid @enderror"
						id="title" name="product_item" required>
					<div class="invalid-feedback">
						@error('product_item')
						<span class="alert text-danger">{{ $message }}</span>
						@enderror
					</div>
				</div>
				<!-- Slug -->
				<div class="col-md-6 mb-3">
					<label for="slug" class="form-label">Slug<span class="text-danger">*</span></label>
					<input type="text" class="form-control @error('slug') is-invalid @enderror" id="slug" name="slug"
						required>
					<div id="slug-error" class="text-danger"></div>
					<div class="invalid-feedback">
						@error('slug')
						<span class="alert text-danger">{{ $message }}</span>
						@enderror
					</div>
				</div>

				<div class="col-md-4 mb-3">
					<label for="brand_logo" class="form-label">Product Image<span class="text-danger">*(JPG, PNG,
							WEBP)</span></label>
					<input data-value="imageerror1" type="file"
						class="form-control image @error('image') is-invalid @enderror" id="image" name="image"
						accept=".jpg,.jpeg,.png,.webp" required>
					<div class="error-message" id="imageerror1" style="color: red;"></div>
					<div class="valid-feedback">
						@error('image')
						<span class="alert text-danger">{{ $message }}</span>
						@enderror
					</div>
				</div>
	                                <div class="col-md-4">
										<label for="bsValidation2" class="form-label"> Multiple Image<span class="text-danger" >*( Jpg,Png,WEBP)</span></label>
										<input data-value="imageerror2" type="file" class="form-control image" id="multiple_image" name="multiple_image[]" multiple  required accept=".jpg,.png" >
									  <div class="error-message" id="imageerror2" style="color: red;"></div>
										<div class="valid-feedback">
											@error('image')
                                            <span class="alert text-danger">{{ $message }}</span>
                                        @enderror
										  </div>
									</div>				
<div class="col-md-4">
    <label for="bsValidation5" class="form-label"> Image Description <span class="text-danger">*</span></label>
    <input type="text" class="form-control" id="img_description" name="img_description" required>
    <div class="invalid-feedback">
        @error('img_description')
            <span class="alert text-danger">{{ $message }}</span>
        @enderror
    </div>
</div>
				<!-- Default Price -->
				<div class="col-md-4 mb-3">
					<label for="default_price" class="form-label">Default Price<span class="text-danger">*</span></label>
					<input type="text" step="0.01" class="form-control @error('default_price') is-invalid @enderror"
						id="default_price" oninput="this.value = this.value.replace(/[^0-9]/g, '')" name="default_price"required>
					<div class="invalid-feedback" >
						@error('default_price')
						<span class="alert text-danger">{{ $message }}</span>
						@enderror
					</div>
				</div>

    <div class="col-md-4 mb-3">
        <label for="mrp_price" class="form-label">
            MRP <span class="text-danger">*</span>
        </label>
        <input type="text" step="0.01"
               class="form-control @error('mrp_price') is-invalid @enderror"
               id="mrp_price"
               name="mrp_price"
               oninput="this.value = this.value.replace(/[^0-9]/g, '')"
               required>
        <div class="invalid-feedback">
            @error('mrp_price')
            <span class="alert text-danger">{{ $message }}</span>
            @enderror
        </div>
    </div>

				<!-- Ordering By -->
				<div class="col-md-4 mb-3">
					<label for="ordering_by" class="form-label">Ordering By <span class="text-danger">*</span></label>
					<input type="number" class="form-control @error('ordering_by') is-invalid @enderror"
						id="ordering_by" name="ordering_by" required>
					<div class="invalid-feedback">
						@error('ordering_by')
						<span class="alert text-danger">{{ $message }}</span>
						@enderror
					</div>
				</div>



				<!-- Description -->
				<div class="col-md-12 mb-3">
					<label for="description" class="form-label">Description</label>
					<!-- Hidden field to store Quill HTML content on submit -->
					<textarea name="description" class="d-none" id="description"></textarea>

					<!-- Editor container with fixed height and styling -->
					<div id="editor-container" style="height: 200px; border: 1px solid #ced4da; border-radius: 4px;">
					</div>
				</div>
  <div class="col-md-6 mb-3">
    <label for="meta_title" class="form-label">Meta Title<span class="text-danger">*</span></label>
    <input type="text" name="meta_title" id="metatitle" class="form-control" value="" placeholder="" required>
  </div>

  <div class="col-md-6 mb-3">
    <label for="meta_keyword" class="form-label">Meta Keywords</label>
    <input type="text" name="meta_keyword" id="meta_keyword" class="form-control" value="" placeholder="">
  </div>
  <div class="col-md-12 mb-3">
    <label for="meta_description" class="form-label">Meta Description</label>
    <textarea name="meta_description" id="meta_description" class="form-control" rows="3" placeholder=""></textarea>
  </div>

				<div class="col-12 text-end">
					<button class="btn btn-primary" type="submit" id="submit-btn" name="submit" value="submit">
						Submit
					</button>
				</div>
			</div>
		</section>
	</form>
</div>

            </div>
    </div>
</div>

            </div>
        </div>
        <!--end row-->
    </div>
</div>

		



<style>
    .plus-wrapper {

	width: 280px;

	height: 100%;

	position: fixed;

	right: -280px;

  top: -21% !important;

	bottom: 0;

	z-index: 1;

	background: #fff;

	border-left: 0 solid #d2d2d2;

	box-shadow: 0 .3rem .6rem rgba(0, 0, 0, .13);

	transition: all .2s ease-out

}


.plus-btn {

	width: 40px;

	height: 40px;

	line-height: 40px;

	font-size: 24px;

	background: #008cff;

	box-shadow: 0 .3rem .6rem rgba(0, 0, 0, .13);

	color: #fff;

	text-align: center;

	border-top-left-radius: 10px;

	border-bottom-left-radius: 10px;

	position: absolute;

	top: 40%;

	right: 100%;

	cursor: pointer

}



.plus-wrapper.plus-toggled {

	right: 0

}



.plus-body {

	padding: 1.25rem

}



.plus-body .form-check .form-check-input,

.plus-body .form-check .form-check-label {

	cursor: pointer




}



.switcher-wrapper {
top: 0% !important;
	width: 367px;
		right: -367px;
}


.switcher-btn {
  top: 27% !important;
}




</style>


<div id="loader" xss=removed>
    <div class="lds-hourglass"></div>
</div>


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')
@include('backend/include/subservicebychildservice/subservicebychildservice')
@include('backend/include/dynamicvalidation/slugvalidation')



<script>
$(document).ready(function(){

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });  

    var table = $('#basic21').DataTable({
        @include('backend.include.datatableajax.datatablefilter')
        'processing': false,
        'serverSide': true,
        'serverMethod': 'POST',
        'ajax': {
            'url': "{{ asset('backend/productajax') }}",
            data: function (d) {
    d.service_id = $('#service_id').val();
    d.subservice_id = $('#subservice_id').val();
    d.brand_id = $('#brand_id').val();
    d.status = $('#status').val();
},
 beforeSend: function () {
                    $('#loader').show(); 
                    },
                    complete: function () {
                    $('#loader').hide(); 
                   
                     }
        },
        'columns': [
            { data: 'id' },
            { data: "ordering_by" },
            { data: "service" },
            { data: "brand_id" },
            { data: "product_item" },
            { data: 'image' },
            { data: "price" },
            // { data: "mrp_price" },
            { data: "status" },
            { data: "action" }
        ]
    });

   
});
</script>


<script>
  $(document).ready(function () {
    function initSelect2(selector, options = {}) {
      const defaultOptions = {
        theme: "bootstrap-5",
        width: '100%',
        placeholder: 'Select an option',
        allowClear: true,
        minimumResultsForSearch: 0,
      };

      $(selector).select2($.extend({}, defaultOptions, options));

      $(selector).on('select2:open', function () {
        $('.select2-search__field').css({
          'font-size': '14px',
          'padding': '4px 8px'
        });
      });
    }

    // Apply Select2 to all dropdowns
    initSelect2('#service_id');
    initSelect2('#subservice_id');
    initSelect2('#brand_id');
    initSelect2('#filterservice_id');
    initSelect2('#filtersubservice_id');
    initSelect2('#filterbrand_id');
  });
</script>
<script>
$(document).on('change', '.toggle-flip input[type="checkbox"]', function () {
    let checkbox = $(this);
    let status   = checkbox.prop('checked') ? 1 : 0;
    let userId   = checkbox.data('id');

    $.ajax({
        type: "POST",
        url: "{{ asset('backend/productstatus') }}",
        data: {
            status: status,
            id: userId,
            _token: '{{ csrf_token() }}',
        },
        success: function (response) {
            console.log("Status updated", response);

            checkbox.prop('checked', response.status == 1);

            Lobibox.notify(response.success ? 'success' : 'error', {
                pauseDelayOnHover: true,
                size: 'mini',
                rounded: true,
                icon: response.success ? 'bx bx-check-circle' : 'bx bx-error',
                delayIndicator: false,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                msg: response.message || (response.success ? 'Status successfully updated.' : 'Update failed.')
            });
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr);

            // revert to old value if error
            checkbox.prop('checked', !status);

            let msg = 'Something went wrong';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                msg = xhr.responseJSON.message;
            }

            Lobibox.notify('error', {
                pauseDelayOnHover: true,
                size: 'mini',
                rounded: true,
                icon: 'bx bx-error',
                delayIndicator: false,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                msg: msg
            });
        }
    });
});
</script>
    

</body>

</html>