@include('backend/include/custom')


<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>
@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')
<title>Partner Single View </title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
@include('backend/include/sidebar')	
@include('backend/include/header')	

<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3">
        <i class="bx bx-user-circle me-1"></i>
        <span>Partner Single View </span>
    </div>
</div>

<div class="page-content">
    <div class="row">
        <div class="col-xl-12 mx-auto">
            <div class="card">
                <div class="bg-light border-bottom-0 pb-0 px-0">
                    <ul class="nav nav-tabs justify-content-start" id="settingsTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active text-dark" id="others-tab" data-bs-toggle="tab" data-bs-target="#others" type="button" role="tab" aria-controls="others" aria-selected="true">
                                Profile
                            </button>
                        </li>
                       <li class="nav-item" role="presentation">
                            <button class="nav-link text-dark" id="attempts-tab" data-bs-toggle="tab" data-bs-target="#attempts" type="button" role="tab" aria-controls="attempts" aria-selected="false">
                                Verify Status
                            </button>
                        </li>
                       
                    </ul>
                </div>

                <div class="card-body p-4">
                    <div class="tab-content" id="settingsTabContent">
                        <div class="tab-pane fade show active" id="others" role="tabpanel" aria-labelledby="others-tab">

<div class="">
  <div class="row align-items-center">
<div class="d-flex flex-wrap align-items-center gap-3 partner-info-wrapper bg-white">

  <!-- Partner Image -->
  <div class="text-center flex-shrink-0">
    @if(!empty($partnerdata->profile) && file_exists(public_path('uploads/partner/' . $partnerdata->profile)))
      <img src="{{ asset('uploads/partner/' . $partnerdata->profile) }}" 
           alt="{{ $partnerdata->name }}" 
           class="rounded-circle shadow-sm partner-img"
           style="width:160px; height:160px; object-fit:cover;">
    @else
      <img src="{{ asset('frontend/assets/image/user.png') }}" 
           alt="User" 
           class="rounded-circle shadow-sm partner-img"
           style="width:160px; height:160px; object-fit:cover;">
    @endif
  </div>

  <!-- Partner Info -->
  <div class="flex-grow-1">
    <h4 class="user-name mb-1">{{ $partnerdata->name ?? 'N/A' }}</h4>
    <p class="text-muted mb-2">{{ $partnerdata->partner_code ? 'Partner Code: '.$partnerdata->partner_code : 'N/A' }}</p>
    <p class="mb-1"><i class="bx bx-envelope text-primary"></i> {{ $partnerdata->email ?? 'N/A' }}</p>
    <p class="mb-2"><i class="bx bx-phone text-success"></i> {{ $partnerdata->mobile_number ?? 'N/A' }}</p>

    <div class="d-flex flex-wrap align-items-center gap-2 mt-2">
      <span class="badge user-rating mb-0">Status: 
        {{ $partnerdata->salary_status == 1 ? 'Salary' : ($partnerdata->salary_status == 2 ? 'Commission' : 'N/A') }}
      </span>
      @if($partnerdata->commission)
        <span class="badge user-rating2">Commission: ₹{{ $partnerdata->commission }}</span>
      @endif
    </div>
  </div>
</div>

  </div>

  <hr class="mt-4 mb-3">

  <div class="row">
    <div class="col-md-3 mb-0">
      <span class="part_span">Date of Birth:</span> {{ $partnerdata->dob ?? 'N/A' }}
    </div>
    <div class="col-md-3 mb-0">
      <span class="part_span">ID Proof Type:</span> 
      @php 
        $idproof = DB::table('id_proof_selects')->where('id', $partnerdata->id_proof_select)->first();
      @endphp
      {{ $idproof->title ?? 'N/A' }}
    </div>
    <div class="col-md-3 mb-0">
       <span class="part_span">ID Proof Number:</span> {{ $partnerdata->id_number ?? 'N/A' }}
    </div>
  <div class="col-md-3 mb-0">
    <span class="part_span">ID Proof:</span>
    @php
        $proofFiles = [];
        if (!empty($partnerdata->id_proof)) {
            $decoded = json_decode($partnerdata->id_proof, true);
            if (is_array($decoded)) {
                $proofFiles = $decoded;
            } else {
                $proofFiles = [$partnerdata->id_proof];
            }
        }
    @endphp

    @if(!empty($proofFiles))
        @foreach($proofFiles as $file)
            <a href="{{ asset('uploads/partner/' . $file) }}" target="_blank">{{ $file }}</a>@if(!$loop->last), @endif
        @endforeach
    @else
        N/A
    @endif
</div>

  </div>

  @if($partnerdata->salary_status == 1)
  <hr class="mt-3 mb-4">
  <div class="row">
    <div class="col-md-4 mb-3">
     <span class="part_span">Salary:</span> ₹{{ $partnerdata->salary ?? 'N/A' }}
    </div>
    <div class="col-md-4 mb-3">
     <span class="part_span">Total Days:</span> {{ $partnerdata->total_days ?? 'N/A' }}
    </div>
    <div class="col-md-4 mb-3">
    <span class="part_span">Per Day Salary:</span> ₹{{ $partnerdata->per_day_salary ?? 'N/A' }}
    </div>
    <div class="col-md-4 mb-3">
     <span class="part_span">Per Day Hourly:</span> {{ $partnerdata->per_day_hourly ?? 'N/A' }}
    </div>
    <div class="col-md-4 mb-3">
    <span class="part_span">Per Hours Salary:</span> ₹{{ $partnerdata->per_hours_salary ?? 'N/A' }}
    </div>
    <div class="col-md-4 mb-3">
    <span class="part_span">Break Hours:</span> {{ $partnerdata->take_breack_hours ?? 'N/A' }}
    </div>
  </div>
  @endif

  <hr class="my-4">

  <div class="row">
    <div class="col-md-12">
      <h5 class="user-add mb-2"><i class="bx bx-map "></i> Address Details</h5>
      @php 
        $country = DB::table('tbl_countries')->where('countries_id',$partnerdata->countries)->first();
        $state   = DB::table('tbl_states')->where('state_id',$partnerdata->state)->first();
        $city    = DB::table('tbl_cities')->where('city_id',$partnerdata->city)->first();
      @endphp
      <p class="mb-1">{{ $partnerdata->address ?? '' }}</p>
      <p class="mb-1">{{ $city->name ?? '' }}, {{ $state->name ?? '' }}, {{ $country->name ?? '' }}</p>
      <p class="mb-0"><span class="part_span">Pincode:</span> {{ $partnerdata->pincode ?? 'N/A' }}</p>
    </div>
  
  </div>
 
  
</div>

                        </div>
                        
<div class="tab-pane fade" id="attempts" role="tabpanel" aria-labelledby="attempts-tab">
<section class="mb-4">
    <form class="row g-3 needs-validation" id="formatDistrict-update" method="POST" enctype="multipart/form-data" action="{{ url('backend/partnerverify') }}" novalidate>
        @csrf
        <input type="hidden" name="partner_id" id="partner_id" value="{{ Crypt::encrypt($partnerdata->id) }}">
        <input type="hidden" id="partner_email" value="{{ $partnerdata->email }}">
        <input type="hidden" id="partner_mobile" value="{{ $partnerdata->mobile_number }}">

        <div class="row">
            <div class="col-md-2 mb-3">
                <div class="form-check form-switch mt-4">
                    <input type="checkbox" class="form-check-input verify-switch" id="email_verify" value="1" data-type="2" name="email_verify"
                        {{ isset($verifydata) && $verifydata->email_verify == 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="email_verify">Email Verify</label>
                </div>
            </div>
            <div class="col-md-2 mb-3">
                <div class="form-check form-switch mt-4">
                    <input type="checkbox" class="form-check-input verify-switch" id="mobile_verify" value="1" data-type="1" name="mobile_verify"
                        {{ isset($verifydata) && $verifydata->mobile_verify == 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="mobile_verify">Mobile Verify</label>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="form-check form-switch mt-4">
                    <input type="checkbox" class="form-check-input verify-switch" id="document_status" value="1" data-type="3" name="document_status"
                        {{ isset($verifydata) && $verifydata->document_status == 1 ? 'checked' : '' }}>
                    <label class="form-check-label" for="document_status">Document Status</label>
                </div>
            </div>
        </div>
    </form>
</section>




</div>



                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')
<script>
$(document).ready(function() {

    $('.verify-switch').on('change', function() {
        var partner_id = $('#partner_id').val();
        var email = $('#partner_email').val();
        var mobile = $('#partner_mobile').val();
        var type = $(this).data('type');

        var email_verify = $('#email_verify').is(':checked') ? 1 : 0;
        var mobile_verify = $('#mobile_verify').is(':checked') ? 1 : 0;
        var document_status = $('#document_status').is(':checked') ? 1 : 0;

        $.ajax({
            url: "{{ url('backend/partnerverify') }}",
            type: "POST",
            data: {
                _token: "{{ csrf_token() }}",
                partner_id: partner_id,
                email: email,
                mobile_number: mobile,
                type: type,
                email_verify: email_verify,
                mobile_verify: mobile_verify,
                document_status: document_status
            },
            dataType: "json",
            success: function(response) {
                if (response.status === 'success') {
                    Lobibox.notify('success', {
                        pauseDelayOnHover: true,
                        continueDelayOnInactiveTab: false,
                        position: 'center bottom',
                        size: 'mini',
                        msg: 'Partner verification updated successfully!'
                    });
                } else {
                    Lobibox.notify('error', {
                        pauseDelayOnHover: true,
                        continueDelayOnInactiveTab: false,
                        position: 'center bottom',
                        size: 'mini',
                        msg: 'Something went wrong. Please try again later.'
                    });
                }
            },
            error: function(xhr) {
                console.error(xhr.responseText);
                Lobibox.notify('error', {
                    pauseDelayOnHover: true,
                    continueDelayOnInactiveTab: false,
                    position: 'center bottom',
                    size: 'mini',
                    msg: 'Server Error! Please refresh and try again.'
                });
            }
        });
    });

});
</script>

</body>
</html>
