




@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

<!--favicon-->

@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Partner Update</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->



<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1" >
    <div class="breadcrumb-title d-flex align-items-center ms-3 " >
        <i class="bx bx-package me-1"></i>
        <span class="">Partner Update</span>
    </div>
</div>

 
<div class="page-content">
   <div class="row">
					<div class="col-xl-12 mx-auto">
						<div class="card">
						
						
							<div class="card-body">
<form class="row g-3 needs-validation" id="partner-update" method="POST" enctype="multipart/form-data" action="{{ url('backend/partnerupdate/' . encrypt($partner->id)) }}" novalidate>
                                @csrf

                                <section class="mb-4">
                                    <div class="row">
                                        <!-- Name -->
                                         <div class="col-md-4 mb-3">
      <label for="email" class="form-label">Name<span class="text-danger">*</span></label>
      <div class="input-group">
        <span class="input-group-text bg-transparent"><i class='bx bxs-user'></i></span>
        <input type="text" class="form-control"   id="name" name="name" value="{{ $partner->name }}"  required>
      </div>
    </div>
                                      

                                        <!-- Email -->
                                        <div class="col-md-4 mb-3">
                                            <label for="email" class="form-label">Email<span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-transparent"><i class='bx bxs-envelope'></i></span>
                                                <input type="email" class="form-control" id="email" name="email"
                                                    oninput="this.value = this.value.replace(/\s+/g, '')"
                                                    value="{{ $partner->email }}" required>
                                            </div>
                                        </div>

                                        <!-- Mobile Number -->
                                        <div class="col-md-4 mb-3">
                                            <label for="mobile_number" class="form-label">Mobile Number<span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-transparent"><i class='bx bxs-phone'></i></span>
                                                <input type="text" class="form-control" id="mobile_number" name="mobile_number"
                                                    maxlength="10" oninput="this.value = this.value.replace(/[^0-9]/g, '')"
                                                    value="{{ $partner->mobile_number }}" required>
                                            </div>
                                        </div>
                       <div class="col-md-4 mb-3">
    <label for="dob" class="form-label">ID Proof Select <span class="text-danger">*</span></label>
    <select name="id_proof_select" class="form-control" required>
        <option value="">Select ID Proof</option>
        @foreach($id_proof_select as $Data)
            <option value="{{ $Data->id }}" 
                @if($partner->id_proof_select == $Data->id) selected @endif>
                {{ $Data->title }}
            </option>
        @endforeach
    </select>
</div>

              
    <div class="col-md-4 mb-3">
    <label for="id_number" class="form-label">ID Number<span class="text-danger">*</span></label>
    <input type="text" class="form-control" id="id_number" name="id_number" value="{{ $partner->id_number }}"  required>
   
</div>
 <div class="col-md-4 mb-3">
    <label for="id_proof" class="form-label">ID Proof<span class="text-danger">*</span></label>
    <input type="file" class="form-control" id="id_proof" name="id_proof[]" multiple>

    @php
        $idFiles = !empty($partner->id_proof) ? json_decode($partner->id_proof, true) : [];
    @endphp

    @if(!empty($idFiles) && is_array($idFiles))
        <small class="text-success d-block mt-1">
            Current Files:
            @foreach($idFiles as $file)
                <a href="{{ asset('uploads/partner/' . $file) }}" target="_blank">{{ $file }}</a>@if(!$loop->last), @endif
            @endforeach
        </small>
    @endif
</div>


      <div class="col-md-4 mb-3">
    <label for="dob" class="form-label">DOB<span class="text-danger">*</span></label>
    <input type="text" class="form-control datepicker" id="dob" name="dob" value="{{ $partner->dob }}"  required>
   
</div>
    <div class="col-md-4 mb-3">
    <label for="id_proof" class="form-label">Profile<span class="text-danger">*</span></label>
    <div class="d-flex">
  	<input data-value="imageerror1" type="file" class="form-control image " id="bsValidation2" name="profile"  accept=".jpg,.png" >
										 @if(isset($partner->profile))
										<a href="{{asset('uploads/partner/'.$partner->profile)}}" data-fancybox="image" data-caption=""><img src="{{asset('uploads/partner/'.$partner->profile)}}" alt="image"style=" width: 50px;height:38px; margin-left: 10px !important;
                                 padding: 0 !important;" ></a> @endif 
                                 </div>
                                  <div class="error-message" id="imageerror1" style="color: red;"></div>
                                 </div>
									  
   


                                        <!-- ID Proof -->
                                       

                                        <!-- Partner Code -->
                                        <div class="col-md-4 mb-3">
                                            <label for="partner_code" class="form-label">Partner Code<span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="partner_code" name="partner_code"
                                                value="{{ $partner->partner_code }}" required>
                                        </div>

                                        <!-- Salary Section -->
                                      <div class="row">
    <div class="col-md-6 mb-3">
        <label for="type" class="form-label">Salary Status <span class="text-danger">*</span></label>
        <select class="form-control" id="type" name="salary_status" required>
            <option value="">Select</option>
            <option value="1" {{ $partner->salary_status == 1 ? 'selected' : '' }}>Salary</option>
            <option value="2" {{ $partner->salary_status == 2 ? 'selected' : '' }}>Commission</option>
        </select>
    </div>

    <!-- Salary Field -->
    <div id="salaryFirst" class="col-md-6 mb-3" style="display: {{ $partner->salary_status == 1 ? 'block':'none' }};">
        <label class="form-label">Salary <span class="text-danger">*</span></label>
        <input class="form-control" id="salary" type="number" name="salary"
            onkeyup="salarycalculation()" value="{{ $partner->salary }}" {{ $partner->salary_status == 1 ? 'required' : '' }}>
    </div>

    <!-- Salary Details -->
    <div id="salaryMore" class="row w-100 mx-0" style="display: {{ $partner->salary_status == 1 ? 'flex':'none' }};">
        <div class="col-md-4 mb-2">
            <label class="form-label">Total Days <span class="text-danger">*</span></label>
            <input class="form-control" id="total_days" type="number" name="total_days"
                onkeyup="salarycalculation()" value="{{ $partner->total_days }}" {{ $partner->salary_status == 1 ? 'required' : '' }}>
        </div>
        <div class="col-md-4 mb-2">
            <label class="form-label">Per Day Salary <span class="text-danger">*</span></label>
            <input class="form-control" id="per_day_salary" type="text" readonly name="per_day_salary"
                value="{{ $partner->per_day_salary }}" {{ $partner->salary_status == 1 ? 'required' : '' }}>
        </div>
        <div class="col-md-4 mb-2">
            <label class="form-label">Per Day Hourly <span class="text-danger">*</span></label>
            <input class="form-control" id="per_day_hourly" type="text" name="per_day_hourly"
                onkeyup="salarycalculation()" value="{{ $partner->per_day_hourly }}" {{ $partner->salary_status == 1 ? 'required' : '' }}>
        </div>
        <div class="col-md-4 mb-2">
            <label class="form-label">Per Hours Salary <span class="text-danger">*</span></label>
            <input id="per_hours_salary" type="text" readonly name="per_hours_salary"
                class="form-control" value="{{ $partner->per_hours_salary }}" {{ $partner->salary_status == 1 ? 'required' : '' }}>
        </div>
        <div class="col-md-4 mb-2">
            <label class="form-label">Take Break Hours <span class="text-danger">*</span></label>
            <input type="number" name="take_breack_hours" class="form-control"
                value="{{ $partner->take_breack_hours }}" {{ $partner->salary_status == 1 ? 'required' : '' }}>
        </div>
    </div>

    <!-- Commission -->
    <div id="commissionInput" class="col-md-6 mb-3" style="display: {{ $partner->salary_status == 2 ? 'block':'none' }};">
        <label class="form-label">Commission <span class="text-danger">*</span></label>
        <input type="text" class="form-control" name="commission"
            oninput="this.value=this.value.replace(/[^0-9]/g,'')" value="{{ $partner->commission }}" {{ $partner->salary_status == 2 ? 'required' : '' }}>
    </div>
</div>

                                        <!-- Address Info -->
                                        <div class="col-md-6">
                                            <label for="countries" class="form-label">Countries<span class="text-danger">*</span></label>
                                            <select class="form-control" name="countries" id="countries" required>
                                                <option value="">Select Country</option>
                                                @foreach($country as $countryData)
                                                    <option value="{{$countryData->countries_id}}" {{ $partner->countries == $countryData->countries_id ? 'selected' : '' }}>
                                                        {{$countryData->name}}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-md-6">
                                            <label for="state" class="form-label">State<span class="text-danger">*</span></label>
                                            <select name="state" class="form-select" id="state" required>
                                              {!! locationOptions('state', $partner->state ?? '') !!}
                                            </select>
                                        </div>

                                        <div class="col-md-6 mt-3">
                                            <label for="city" class="form-label">City<span class="text-danger">*</span></label>
                                            <select name="city" class="form-select" id="city" required>
                                                {!! locationOptions('city', $partner->city ?? '') !!}
                                            </select>
                                        </div>

                                        <div class="col-md-6 mt-3">
                                            <label for="pincode" class="form-label">Pincode<span class="text-danger">*</span></label>
                                            <select name="pincode[]" class="form-select" id="pincode" required multiple>
                                       {!! locationOptions('pincode', $partner->pincode ?? '') !!}
                                            </select>
                                        </div>

                                        <div class="col-12 text-end mt-2">
                                            <button class="btn btn-primary" type="submit">Update</button>
                                        </div>
                                    </div>
                                </section>
                            </form>
							</div>
						</div>
					</div>
				</div>
</div>
</div>

	


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')
 @include('backend/include/statebycity/statebycity')

<script>
const type = document.getElementById('type');
const salaryFirst = document.getElementById('salaryFirst');
const salaryMore = document.getElementById('salaryMore');
const commissionInput = document.getElementById('commissionInput');

function toggleSalaryCommission() {
    const v = type.value;
    salaryFirst.style.display = salaryMore.style.display = commissionInput.style.display = 'none';
    document.querySelectorAll('#salaryFirst input, #salaryMore input, #commissionInput input')
        .forEach(i => i.removeAttribute('required'));

    if (v === '1') {
        salaryFirst.style.display = 'block';
        salaryMore.style.display = 'flex';
        document.querySelectorAll('#salaryFirst input, #salaryMore input')
            .forEach(i => i.setAttribute('required', 'required'));
    } else if (v === '2') {
        commissionInput.style.display = 'block';
        document.querySelector('#commissionInput input').setAttribute('required', 'required');
    }
}

// On change event
type.addEventListener('change', toggleSalaryCommission);

// Page load: trigger toggle to ensure required attributes are correct
window.addEventListener('DOMContentLoaded', toggleSalaryCommission);
</script>

<script>
    function salarycalculation(value){
        var salary = $('#salary').val();
        var total_days = $('#total_days').val();
        var per_day_hourly = $('#per_day_hourly').val();
         $("#per_day_salary").val(salary/total_days);
         $("#per_hours_salary").val(Math.round((salary/total_days)/per_day_hourly * 100) / 100);
    }
</script>

    
    <script>
       $( '#pincode' ).select2( {
        theme: "bootstrap-5",
        width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
        placeholder: $( this ).data( 'placeholder' ),
        closeOnSelect: false,
    } );
  $(document).ready(function () {
      
    function initSelect2(selector, options = {}) {
      $(selector).select2($.extend({
        theme: "bootstrap-5",
        width: $(selector).data('width') ? $(selector).data('width') : $(selector).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(selector).data('placeholder'),
      }, options));
    }
    initSelect2('#countries');
    initSelect2('#state');
    initSelect2('#city');
 
   
  });
</script>
<script>
    	$(".datepicker").flatpickr();
</script>

</body>

</html>


		










