
@include('backend/include/custom')


<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>


@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Media</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->


<!--start page wrapper -->
<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3">
        <i class="bx bx-buildings me-1"></i>
        <span>Media</span>
    </div>
</div>

    <div class="page-content">
        <div class="row">
            <div class="col-xl-12 mx-auto">
                            <!-- Nav tabs -->
<div class="card">
    <!-- Tabs Header -->
    <div class="bg-light border-bottom-0 pb-0 px-0">
        <ul class="nav nav-tabs" id="settingsTab" role="tablist">
            @if(permission(session('SUPERADMIN_ID'), '11', 'action_view'))
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="others-tab" data-bs-toggle="tab" data-bs-target="#others" type="button" role="tab" aria-controls="others" aria-selected="true">
                    View
                </button>
            </li>
            @endif
            @if(permission(session('SUPERADMIN_ID'), '11', 'action_add'))
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="logo-tab" data-bs-toggle="tab" data-bs-target="#logo" type="button" role="tab" aria-controls="logo" aria-selected="false">
                    Add
                </button>
            </li>
            @endif
        </ul>
    </div>

    <!-- Tabs Content -->
    <div class="card-body p-4">

            <div class="tab-content" id="settingsTabContent">
<div class="tab-pane fade show active" id="others" role="tabpanel" aria-labelledby="others-tab">
  <div class="card-body">
    <div class="table-responsive">
      <table id="basic21"  class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
        <thead>
          <tr class="hello1">
            <th>ID</th>
            <th>Title</th>
            <th>Media Type</th>
            <th>Media File</th>
           
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>
    </div>
  </div>
</div>

                <!-- Tab 2: Logo & Images -->
<div class="tab-pane fade" id="logo" role="tabpanel" aria-labelledby="logo-tab">
  <form class="row g-3 needs-validation" onsubmit="return myckediter()" id="formatDistrict-update" method="POST" action="{{asset('backend/mediacreate')}}" enctype="multipart/form-data" novalidate>
    @csrf
    <section class="mb-4">
      <div class="row">
      

        <!-- Title Name -->
<div class="col-md-6 mb-3">
  <label for="title" class="form-label">Title<span class="text-danger">*</span></label>
  <input type="text" class="form-control" id="title" name="title" placeholder="" required>
   
</div>

<!-- Media Type  -->
<div class="col-md-6 mb-3">
  <label for="media_type" class="form-label">Media Type <span class="text-danger">*</span></label>
  <select class="form-select" id="media_type" name="media_type" required >
    <option value="">Select Media Type</option>
    <option value="audio">Audio</option>
    <option value="video">Video</option>
    <option value="image">Image</option>
  </select>

</div>

<!-- Media File  -->
<div class="col-md-6 mb-3">
  <label for="media_file" class="form-label">Media File <span class="text-danger">*</span></label>
  <input type="file" class="form-control" id="media_file" name="media_file" required>
</div>

<!-- Media Url  -->
<div class="col-md-6 mb-3">
  <label for="media_url" class="form-label">Media Url </label>
  <input type="text" class="form-control" id="media_url" name="media_url" >
</div>

<!-- User ID  -->
<!--<div class="col-md-6 mb-3">-->
<!--  <label for="user_id" class="form-label">User ID <span class="text-danger">*</span></label>-->
<!--  <input type="text" class="form-control" id="user_id" name="user_id" placeholder="" >-->
<!--</div>-->

<!-- Panel ID  -->
<!--<div class="col-md-6 mb-3">-->
<!--  <label for="user_id" class="form-label">Panel ID <span class="text-danger">*</span></label>-->
<!--  <input type="text" class="form-control" id="panel_id" name="panel_id" placeholder="" >-->
<!--</div>-->

        <div class="col-12 text-end">
<button class="btn btn-primary" type="submit" id="submit-btn" name="submit" value="submit">
  Submit
</button>
        </div>
      </div>
    </section>
  </form>
</div>

            </div>
    </div>
</div>

            </div>
        </div>
        <!--end row-->
    </div>
</div>

<div id="loader" xss=removed>
    <div class="lds-hourglass"></div>
</div>


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')





    <script>


      $(document).ready(function () {
        $.ajaxSetup({
          headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
          },
        });

        $("#basic21").DataTable({
             @include('backend.include.datatableajax.datatablefilter')
          processing: true,
          serverSide: true,
          serverMethod: "POST",
          ajax: {
            url: "{{ asset('backend/mediaajax') }}",
            dataSrc: function (json) {
              console.log("AJAX SUCCESS DATA:", json);
              return json.data;
            },
            error: function (xhr, error, thrown) {
              console.log("AJAX ERROR:", xhr.responseText);
            },
            beforeSend: function () {
                    $('#loader').show(); 
                    },
                    complete: function () {
                    $('#loader').hide(); 
                   
                     }
          },
          columns: [
            { data: "id" },
            { data: "title" },
            { data: "media_type" },
            { data: 'media_file' },
            { data: "action" }
          ],
        });
      });



    </script>


</body>

</html>

