
@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

<!--favicon-->

@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Store Update</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->



<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1" >
    <div class="breadcrumb-title d-flex align-items-center ms-3 " >
        <i class="bx bx-store me-1"></i>
        <span class="">Store Update</span>
    </div>
</div>

 
<div class="page-content">
   <div class="row">
					<div class="col-xl-12 mx-auto">
						<div class="card">
						
						
							<div class="card-body">
  <form class="row g-3 needs-validation" onsubmit="return myckediter()" id="formatDistrict-update" method="POST" action="{{ asset('backend/storeupdate/' . Crypt::encrypt($store->id)) }}" enctype="multipart/form-data" novalidate>
    @csrf
<section class="mb-4">

  <!-- Start stacked input fields -->
  <div class="row">

    <div class="col-md-6 mt-2">
      <label for="name" class="form-label">Name <span class="text-danger">*</span></label>
      <input type="text" class="form-control" id="title" value="{{ $store->name }}" name="name" required>
    </div>
    
    	<div class="col-md-6 mt-2">
										<label for="bsValidation1" class="form-label">Slug<span class="text-danger" >*</span></label>
										<input type="text" class="form-control " id="slug"  name="slug" value="{{$store->slug}}" required>
										<div id="slug-error" class="text-danger" ></div>
									</div>

    <div class="col-md-4 mt-2">
      <label for="number" class="form-label">Number <span class="text-danger">*</span></label>
      <input type="text" class="form-control" id="number" value="{{ $store->number }}" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,10)" maxlength="10" name="number" required>
    </div>

    <div class="col-md-4 mt-2">
      <label for="whatsapp" class="form-label">WhatsApp Number</label>
      <input type="tel" class="form-control" id="whatsapp" value="{{ $store->whatsapp }}" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,10)" maxlength="10" name="whatsapp">
    </div>
    
    <div class="col-md-4 mt-2">
      <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
      <input type="email" class="form-control" value="{{ $store->email }}" id="email" name="email" required>
    </div>
    
    <div class="col-md-6 mt-2">
      <label for="latitude" class="form-label">Latitude</label>
      <input type="text" class="form-control" id="latitude" value="{{ $store->latitude }}" oninput="this.value = this.value.replace(/[^0-9]/g, '')" name="latitude">
    </div>

    <div class="col-md-6 mt-2">
      <label for="longitude" class="form-label">Longitude</label>
      <input type="text" class="form-control" id="longitude" value="{{ $store->longitude }}" oninput="this.value = this.value.replace(/[^0-9]/g, '')" name="longitude">
    </div>

    <div class="col-md-3 mt-2">
      <label for="countries" class="form-label">Countries <span class="text-danger">*</span></label>
      <select class="form-select" name="countries" id="countries" required>
        <option value="">Select Countries</option>
        @foreach($country as $countryData)
            <option value="{{$countryData->countries_id}}" @if($countryData->countries_id == $store->countries) selected @endif>
                {{$countryData->name}}
            </option>
        @endforeach
      </select>
    </div>

    <div class="col-md-3 mt-2">
      <label for="state" class="form-label">State <span class="text-danger">*</span></label>
      <select class="form-select" name="state" id="state" required>
        {!! locationOptions('state', $store->state ?? '') !!}
      </select>
    </div>

    <div class="col-md-3 mt-2">
      <label for="city" class="form-label">City <span class="text-danger">*</span></label>
      <select class="form-select" name="city" id="city" required>
        {!! locationOptions('city', $store->city ?? '') !!}
      </select>
    </div>

    <div class="col-3 mt-2">
      <label for="pincode" class="form-label">Pincode <span class="text-danger">*</span></label>
      <select class="form-select" name="pincode" id="pincode" required>
        {!! locationOptions('pincode', $store->pincode ?? '') !!}
      </select>
    </div>

  <div class="col-md-6 mt-2">
    <label for="start_time" class="form-label">Start Time</label>
    <input type="text" class="form-control time-picker" value="{{ $store->start_time }}" name="start_time" id="start_time" />
  </div>

  <!-- End Time -->
  <div class="col-md-6 mt-2">
    <label for="end_time" class="form-label">End Time</label>
    <input type="text" class="form-control time-picker" value="{{ $store->end_time }}" name="end_time" id="end_time" />
  </div>

<div class="col-md-12 mt-2">
  <label for="multiple-select-field" class="form-label">Close</label>
  <select class="form-select" id="multiple-select-field" name="close[]" multiple required>
    @php
        $days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
        // If stored as JSON string, decode it
        $selectedDays = is_array($store->close) ? $store->close : json_decode($store->close, true);
    @endphp

    @foreach($days as $day)
      <option value="{{ $day }}" 
        {{ (is_array($selectedDays) && in_array($day, $selectedDays)) ? 'selected' : '' }}>
        {{ $day }}
      </option>
    @endforeach
  </select>
</div>



    <div class="col-12 mt-2">
      <label for="map_url" class="form-label">Map URL</label>
      <textarea class="form-control" id="map_url" name="map_url" rows="3">{{$store->map_url}}</textarea>
    </div>

    <div class="col-12 mt-2">
      <label for="address" class="form-label">Address<span class="text-danger">*</span></label>
      <textarea class="form-control" id="address" name="address" rows="3" required>{{$store->address}}</textarea>
    </div>
    

									<div class="col-md-12 mt-3">
										<div class="d-md-flex d-grid align-items-center gap-3">
											<button type="submit" id="submit-btn" class="btn btn-primary px-4">Update</button>
										
										</div>
									</div>
  </div>



    </div>
</section>
  </form>
							</div>
						</div>
					</div>
				</div>
</div>
</div>

	


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')
@include('backend/include/dynamicvalidation/slugvalidation')
@include('backend/include/subservicebychildservice/subservicebychildservice')
@include('backend/include/statebycity/statebycity')
	<script>
  $(document).ready(function() {
    $('#multiple-select-field').select2({
      placeholder: "",
      width: '100%'
    });
  });
</script>
 	<script>
		$(".time-picker").flatpickr({
				enableTime: true,
				noCalendar: true,
				dateFormat: "H:i",
			});
	</script>  

<script>
  $(document).ready(function () {
      
    function initSelect2(selector, options = {}) {
      $(selector).select2($.extend({
        theme: "bootstrap-5",
        width: $(selector).data('width') ? $(selector).data('width') : $(selector).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(selector).data('placeholder'),
      }, options));
    }
    initSelect2('#countries');
    initSelect2('#state');
    initSelect2('#city');
    initSelect2('#pincode');
  });
</script>


</body>

</html>