


@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

<!--favicon-->

@include('backend/include/head')
 
@include('backend/include/datatableajax/tablelink')

<title>Cities</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->



<div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
  <div class="modal-dialog ">
    <form id="editEmailTemplateForm" method="POST" action="{{ asset('backend/cityupdate') }}">
      @csrf
      <input type="hidden" name="id" id="id" />

      <div class="modal-content">
        <div class="modal-header p-2 usbb">
          <h5 class="modal-title text-white " id="editModalLabel"> City Update</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">

          <div class="col-md-12">
            <label class="form-label">Countries <span class="text-danger">*</span></label>
            <select name="country_id" id="country_id" class="form-control" required>
              <option value="">Select Country</option>
              @foreach($country as $item)
                  <option value="{{ $item->countries_id }}">{{ $item->name }}</option>
              @endforeach
            </select>
          </div>

          <div class="col-md-12 mt-2">
            <label class="form-label">State <span class="text-danger">*</span></label>
            <select name="state_id" id="state_id" class="form-control" required>
              <option value="">Select State</option>
            </select>
          </div>

          <div class="col-md-12 mt-2">
            <label class="form-label">City Name <span class="text-danger">*</span></label>
            <input type="text" name="name" id="name" class="form-control" required>
          </div>

        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Update</button>
        </div>
      </div>
    </form>
  </div>
</div>






<div class="page-wrapper">
      <div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
        <div class="breadcrumb-title d-flex align-items-center ms-3">
          <i class="bx bx-map me-1 mb-1"></i>
          <span>Cities</span>
        </div>
      </div>
      <div class="page-content">
           <div class="switcher-wrapper">
    @if(permission(session('SUPERADMIN_ID'), '10', 'action_view'))
        <div class="switcher-btn">
            <i class='bx bx-filter-alt'></i>
        </div>
    @endif

    <div class="card">
        <div class="card-header text-capitalize usbb d-flex align-items-center">
            <h4 class="mb-0 text-white">Filter</h4>
            <button type="button" class="btn-close ms-auto close-switcher bg-white" aria-label="Close"></button>
        </div>

        <div class="switcher-body">
            <div class="row">
                <div class="col-md-12">
                    <div class="card radius-10">
                        <div class="card-body d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary"><b>Total Count</b></p>
                                <h4 id="city_count" class="my-1">{{ $citycount }}</h4>
                            </div>
                            <div class="widgets-icons bg-light-success text-success ms-auto">
                                <i class="bx bx-up-arrow-circle"></i>
                            </div>
                        </div>
                    </div>
                </div>

                @php
                    if (!empty($_GET['countries'])) {
                        $countriesfilter = $_GET['countries'];
                    } else {
                        $countriesfilter = "";
                    }

                    if (!empty($_GET['state'])) {
                        $statefilter = $_GET['state'];
                    } else {
                        $statefilter = "";
                    }
                @endphp

                <form class="row g-3 needs-validation" id="filterForm" novalidate style="margin-top: -16px;">
                    <div class="col-md-12">
                        <label for="userSelect" class="form-label">Countries</label>
                        <select class="form-control" name="countries" id="countriesfilter">
                            <option value="">Select Countries</option>
                            @foreach($country as $data)
                                <option value="{{ $data->countries_id }}" @if($countriesfilter == $data->countries_id) selected @endif>
                                    {{ $data->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-12">
                        <label for="userSelect" class="form-label">States</label>
                        <select class="form-control" name="state" id="statefilter">
                            <option value="">Select State</option>
                        </select>
                    </div>

                    <div class="col-md-12"></div>
                    <div class="col-md-8">
                        <div>
                            <button type="submit" id="submitBtn" class="btn btn-primary px-3">Apply</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


        <div class="row">
          <div class="col-xl-12">
            <div class="card">
              <div class="bg-light border-bottom-0 pb-0 px-0">
                <ul class="nav nav-tabs justify-content-start" id="settingsTab" role="tablist">
                    @if(permission(session('SUPERADMIN_ID'), '10', 'action_view'))
                  <li class="nav-item" role="presentation">
                    <button class="nav-link active text-dark" id="others-tab" data-bs-toggle="tab"
                      data-bs-target="#others" type="button" role="tab" aria-controls="others" aria-selected="true">
                      View
                    </button>
                  </li>
                  @endif
                  @if(permission(session('SUPERADMIN_ID'), '10', 'action_add'))
                  <li class="nav-item" role="presentation">
                    <button class="nav-link text-dark" id="logo-tab" data-bs-toggle="tab" data-bs-target="#logo"
                      type="button" role="tab" aria-controls="logo" aria-selected="false">
                      Add
                    </button>
                  </li>
                  @endif
                </ul>
              </div>

              <div class="card-body ">
                <div class="tab-content" id="settingsTabContent">
                  <!-- Tab 1: Logo & Images -->
                  <div class="tab-pane fade" id="logo" role="tabpanel" aria-labelledby="logo-tab">

                    <div class="card-body">
                     <form id="editEmailTemplateForm" method="POST" action="{{ asset('backend/cityadd') }}">
    <div class="row">
         <div class="col-md-6">
            <label class="form-label">Countries <span class="text-danger">*</span></label>
            <select name="country_id" id="single-select-field" class="form-control" required>
              <option value="">Select Country</option>
              @foreach($country as $item)
                  <option value="{{ $item->countries_id }}">{{ $item->name }}</option>
              @endforeach
            </select>
          </div>

          <div class="col-md-6">
            <label class="form-label">State <span class="text-danger">*</span></label>
            <select name="state_id" id="single-select-fieldd" class="form-control" required>
              <option value="">Select State</option>
            </select>
          </div>

          <div class="col-md-12 mt-2">
            <label class="form-label">City Name <span class="text-danger">*</span></label>
            <input type="text" name="name" id="name" class="form-control" required>
          </div>

   
          <div class="col-12 text-end mt-3">
              <button type="submit" class="btn btn-primary">Submit</button>
          </div>
    </div>
   
        
    </form>
                    </div>

                  </div>


                  <!-- Tab 2: Other Settings -->
                  <div class="tab-pane fade show active" id="others" role="tabpanel" aria-labelledby="others-tab">
                    <div class="card-body">
                     	<div class="table-responsive">
							<table id="basic21" class="table table-striped  dataTable border table-bordered no-footer " style="width:100%">
								<thead>
									<tr class="hello1">
    							  <th>ID</th>
                                            <th>Cities</th>
                                            <th>States</th>
                                            <th>Countries</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                           
    								    
									</tr>
								</thead>
								<tbody>
								</tbody>
							</table>
						</div>
                    </div>
                  </div>
                </div>

              </div>
            </div>
          </div>

        </div>


      </div>
    </div>
   
    <!-- Loader HTML -->

<div id="loader" style="display:none;">
    <div class="lds-hourglass"></div>
</div>
<style>
    .switcher-wrapper {
top: 0% !important;
	width: 367px;
		right: -367px;
}


.switcher-btn {
  top: 18% !important;
}
</style>
	


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')


<script>
$(document).ready(function () {
    function bindCountryToState(countrySelector, stateSelector) {
        $(countrySelector).change(function () {
            const countryId = $(this).val();
            if (countryId) {
                $.ajax({
                    url: '{{ asset("backend/getCountryByState") }}',
                    method: 'GET',
                    data: { country: countryId },
                    success: function (response) {
                        if (response.states) {
                            let options = response.states.map(item =>
                                `<option value="${item.state_id}">${item.name}</option>`
                            ).join('');
                            $(stateSelector).html(options);
                        } else {
                            $(stateSelector).html('<option value="">No states found</option>');
                        }
                    },
                    error: function () {
                        $(stateSelector).html('<option value="">Error loading state</option>');
                    }
                });
            } else {
                $(stateSelector).html('<option value="">Select Countries First</option>');
            }
        });
    }

    bindCountryToState('#single-select-field', '#single-select-fieldd');
    bindCountryToState('#countriesfilter', '#statefilter');
    bindCountryToState('#country_id', '#state_id');
});

function cityedit(row) {
    $('#id').val(row.city_id);
    $('#name').val(row.name);

    $.ajax({
        url: '{{ asset("backend/getCountryByState") }}', 
        method: 'GET',
        data: { state_id: row.stateid },
        success: function (response) {
            if (response.country_id) {
                $('#country_id').val(response.country_id).trigger('change');

                setTimeout(function () {
                    $('#state_id').val(row.stateid).trigger('change');
                }, 500);
            }
        }
    });
}
</script>






<script>
  $(document).ready(function () {
    function initSelect2(selector, options = {}) {
      let defaultOptions = {
        theme: "bootstrap-5",
        width: $(selector).data('width') ? $(selector).data('width') : $(selector).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(selector).data('placeholder'),
      };

      $(selector).select2($.extend({}, defaultOptions, options));
    }

    initSelect2('#single-select-field');
    initSelect2('#single-select-fieldd');
    initSelect2('#countriesfilter');
    initSelect2('#statefilter');

    initSelect2('#country_id', {
      width: '100%',
      placeholder: "Select Country",
      dropdownParent: $('#editModal'),  
      minimumResultsForSearch: 0
    });

    initSelect2('#state_id', {
      width: '100%',
      placeholder: "Select State",
      dropdownParent: $('#editModal'),
      minimumResultsForSearch: 0
    });
  });
</script>







<script>
    $(document).ready(function () {
        $.ajaxSetup({
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
        });

      
        var table = $("#basic21").DataTable({
            @include('backend.include.datatableajax.datatablefilter')
            processing: false,
            serverSide: true,
            serverMethod: "POST",
            ajax: {
                url: "{{ asset('backend/ajaxcitiesview') }}",
                data: function (d) {
                    d.countries = $('#countriesfilter').val();
                    d.state = $('#statefilter').val();
                },
                dataSrc: function (json) {
                    $('#city_count').text(json.cityCount); 
                    return json.data;
                },
                beforeSend: function () {
                    $('#loader').show(); // Loader start
                },
                complete: function () {
                    $('#loader').hide(); // Loader hide
                    $('.switcher-wrapper').removeClass('switcher-toggled'); // Filter close
                }
            },
            columns: [
                { data: "id", title: "Sr. No." },
                { data: "cities", title: "Cities" },
                { data: "states", title: "States" },
                { data: "countries", title: "Countries" },
                { data: "status", title: "Status" },
                { data: "action"},
            ]
        });

        // Apply button click
        $('#submitBtn').on('click', function (e) {
            e.preventDefault();
            const country = $('#countriesfilter').val();
            const state = $('#statefilter').val();

            const url = new URL(window.location.href);
            country ? url.searchParams.set('countries', country) : url.searchParams.delete('countries');
            state ? url.searchParams.set('state', state) : url.searchParams.delete('state');

            window.history.pushState({}, '', url);

            table.ajax.reload();
        });

       
        if ($('#countriesfilter').val() || $('#statefilter').val()) {
            table.ajax.reload();
        }
    });
</script>





<script>
    $(document).on('change', '.js-switch', function () {
        let status = $(this).prop('checked') === true ? 1 : 0;
        let userId = $(this).data('id');

        $.ajax({
            type: "post",
            dataType: "json",
            url: "{{asset('backend/citiesstatus')}}",
            data: {
                'status': status,
                'id': userId,
                '_token': '{{ csrf_token() }}',
            },
            success: function (data) {
                console.log("AJAX Success: ", data);
            },
            error: function (error) {
                console.log("AJAX Error: ", error);
                alert("Error occurred!");
            }
        });
    });
</script>
</body>

</html>
