<div class="container-fluid my-3">
    <div class="card shadow-sm border-0 rounded-3">
        <div class="card-body p-3">

            <div class="row g-3">
                <!-- Left Column -->
                <div class="col-md-6">
                    <div class="p-2 bg-light rounded mb-2">
                        <small class="text-muted d-block">Name</small>
                        <span class="fw-semibold" id="name"></span>
                    </div>

                    <div class="p-2 bg-light rounded mb-2">
                        <small class="text-muted d-block">Phone</small>
                        <span class="fw-semibold" id="phone"></span>
                    </div>

                    <div class="p-2 bg-light rounded mb-2">
                        <small class="text-muted d-block">Email</small>
                        <span class="fw-semibold" id="leademail"></span>
                    </div>

                    <div class="p-2 bg-light rounded mb-2">
                        <small class="text-muted d-block">Position</small>
                        <span class="fw-semibold" id="position"></span>
                    </div>

                    <div class="p-2 bg-light rounded mb-2">
                        <small class="text-muted d-block">Status</small>
                        <span class="fw-semibold" id="leadstatussingle"></span>
                    </div>

                    <div class="p-2 bg-light rounded mb-2">
                        <small class="text-muted d-block">Source</small>
                        <span class="fw-semibold" id="sourcesingle"></span>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="col-md-6">
                    <div class="p-2 bg-light rounded mb-2">
                        <small class="text-muted d-block">Company</small>
                        <span class="fw-semibold" id="company"></span>
                    </div>

                    <div class="p-2 bg-light rounded mb-2">
                        <small class="text-muted d-block">Website</small>
                        <span class="fw-semibold" id="Website"></span>
                    </div>

                    <div class="p-2 bg-light rounded mb-2">
                        <small class="text-muted d-block">Lead Value</small>
                        <span class="fw-semibold" id="lead_value"></span>
                    </div>
                </div>
            </div>

            <!-- Address -->
            <div class="p-2 bg-light rounded mb-2 mt-2">
                <small class="text-muted d-block">Address</small>
                <span id="address"></span>
            </div>

            <!-- Description -->
            <div class="p-2 bg-light rounded mb-2">
                <small class="text-muted d-block">Description</small>
                <span id="descriptionsingle"></span>
            </div>

            <!-- Tags -->
            <div class="p-2 bg-light rounded">
                <small class="text-muted d-block">Tags</small>
                <div id="tagsingle"></div>
            </div>

        </div>
    </div>
</div>

<!--//Lead Single View-->
<script>
function alldatainlead(row){
    $('#id').val(row.id);
    const statusMap = {
        1: 'In Progress',
        2: 'Approved',
        3: 'Not Responded',
        4: 'Reject',
        5: 'Hold'
    };
    const sourceMap = {
        1: 'Business',
        2: 'Client'
    };

    $('#name').html('<i class="bx bx-user text-primary me-1"></i> ' + (row.name ?? ''));
    $('#phone').html('<i class="bx bx-phone text-success me-1"></i> ' + (row.phone ?? ''));
    $('#leademail').html('<i class="bx bx-envelope text-info me-1"></i> ' + (row.email_address ?? ''));
    $('#position').html('<i class="bx bx-briefcase text-warning me-1"></i> ' + (row.position ?? ''));
    $('#company').html('<i class="bx bx-buildings text-secondary me-1"></i> ' + (row.company ?? ''));
    $('#Website').html('<i class="bx bx-globe text-danger me-1"></i> ' + (row.website ?? ''));
    $('#lead_value').html('<i class="bx bx-money text-success me-1"></i> ' + (row.lead_value ?? ''));

    $('#leadstatussingle').html('<i class="bx bx-info-circle text-primary me-1"></i> ' + (statusMap[row.leadstatus] ?? ''));
    $('#sourcesingle').html('<i class="bx bx-share-alt text-success me-1"></i> ' + (sourceMap[row.source] ?? ''));

    let parts = [];
    if (row.address) parts.push(row.address);
    if (row.city) parts.push(row.city);
    if (row.state) parts.push(row.state);
    if (row.country) parts.push(row.country);
    if (row.pincode) parts.push(row.pincode);
    let fullAddress = parts.join(', ');
    $('#address').html('<i class="bx bx-map text-primary me-1"></i> ' + fullAddress);

    $('#descriptionsingle').html(row.description ?? '');

    // Tags
    $('#tagsingle').html(row.tags ?? '');
}
</script>
<!--//Lead Single View-->
