<script>
$(document).ready(function () {
    // Common function
    function initLocationDropdown(countrySelector, stateSelector, citySelector, pincodeSelector) {
        // On country change -> get states
        $(countrySelector).change(function () {
            const countryId = $(this).val();
            if (countryId) {
                $.ajax({
                    url: '{{ asset("statebycity") }}',
                    method: 'GET',
                    data: { country_id: countryId },
                    beforeSend: function () {
                        $('#loader').show();
                    },
                    success: function (response) {
                        let options = '<option value="">Select State</option>';
                        response.states.forEach(item => {
                            options += `<option value="${item.state_id}">${item.name}</option>`;
                        });
                        $(stateSelector).html(options);
                        $(citySelector).html('<option value="">Select City</option>');
                        $(pincodeSelector).html('<option value="">Select Pincode</option>');
                    },
                    complete: function () {
                        $('#loader').hide();
                    }
                });
            }
        });

        // On state change -> get cities
        $(stateSelector).change(function () {
            const stateId = $(this).val();
            if (stateId) {
                $.ajax({
                    url: '{{ asset("statebycity") }}',
                    method: 'GET',
                    data: { state_id: stateId },
                    beforeSend: function () {
                        $('#loader').show();
                    },
                    success: function (response) {
                        let options = '<option value="">Select City</option>';
                        response.cities.forEach(item => {
                            options += `<option value="${item.city_id}">${item.name}</option>`;
                        });
                        $(citySelector).html(options);
                        $(pincodeSelector).html('<option value="">Select Pincode</option>');
                    },
                    complete: function () {
                        $('#loader').hide();
                    }
                });
            }
        });

        // On city change -> get pincodes
        $(citySelector).change(function () {
            const cityId = $(this).val();
            if (cityId) {
                $.ajax({
                    url: '{{ asset("statebycity") }}',
                    method: 'GET',
                    data: { city_id: cityId },
                    beforeSend: function () {
                        $('#loader').show();
                    },
                    success: function (response) {
                        let options = '<option value="">Select Pincode</option>';
                        response.pincodes.forEach(item => {
                            options += `<option value="${item.pincode}">${item.pincode}</option>`;
                        });
                        $(pincodeSelector).html(options);
                    },
                    complete: function () {
                        $('#loader').hide();
                    }
                });
            }
        });
    }

    // Filter form ke liye
    initLocationDropdown('#filtercountries', '#filterstate', '#filtercity', '#filterpincode');

    // Add form ke liye
    initLocationDropdown('#countries', '#state', '#city', '#pincode');
});
</script>
