
@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

<!--favicon-->

@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Slider Update</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->



<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3 " >
        <i class="bx bx-carousel me-1"></i>
        <span class="">Slider Update</span>
    </div>
</div>

 
<div class="page-content">
   <div class="row">
					<div class="col-xl-12 mx-auto">
						<div class="card">
						
						
							<div class="card-body">
  <form class="row g-3 needs-validation" onsubmit="return myckediter()" id="formatDistrict-update" method="POST" action="{{ asset('backend/sliderupdate/' . Crypt::encrypt($slider->id)) }}" enctype="multipart/form-data" novalidate>
    @csrf
    <section class="mb-4">
      <div class="row">

									<div class="col-md-6 mb-3">
										<label for="bsValidation1" class="form-label"> Services</label>
									<select class="form-select @error('title') is-invalid @enderror" id="service_id" name="service_id">
    <option value="">Select Option</option>
    @foreach($services as $data)
<option value="{{ $data->id }}" {{ $slider->service_id == $data->id ? 'selected' : '' }}>
    {{ $data->title }}
</option>
    @endforeach
    </select>
									
									</div>
									<div class="col-md-6 mb-3">
										<label for="bsValidation1" class="form-label"> Subservices</label>
									<select class='form-control' value="" name="subservice_id" id="subservice_id">
									   {!! serviceOptions('subservice', $slider->subservice_id ?? '') !!}

									</select>
									</div>


<div class="col-md-4 mb-3">
  <label for="title" class="form-label">Title<span class="text-danger">*</span></label>
  <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" value="{{$slider->title}}" name="title" placeholder="" required>
</div>
<div class="col-md-4 mb-3">
  <label for="tagline" class="form-label">Tagline</label>
  <input type="text" class="form-control @error('tagline') is-invalid @enderror" id="tagline" value="{{$slider->tagline}}" name="tagline" placeholder="">
</div>
				<!-- Ordering By -->
				<div class="col-md-4 mb-3">
					<label for="ordering_by" class="form-label">Ordering By <span class="text-danger">*</span></label>
					<input type="number" class="form-control @error('ordering_by') is-invalid @enderror"
						id="ordering_by" value="{{$slider->ordering_by}}" name="ordering_by" required>
					<div class="invalid-feedback">
						@error('ordering_by')
						<span class="alert text-danger">{{ $message }}</span>
						@enderror
					</div>
				</div>
<div class="col-md-4 mb-3">
    <label for="image" class="form-label">Slider Image
        <span class="text-danger">*(JPG, PNG, WEBP)</span>
    </label>
    
    <div class="input-group">
        <input 
            type="file" data-value="imageerror1" type="file" class="form-control image @error('image') is-invalid @enderror" 
            id="image" 
            name="image" 
            accept=".jpg,.jpeg,.png,.webp"
        >

        @if(isset($slider->image))
            <a href="{{ asset('uploads/slider/' . $slider->image) }}" 
               data-fancybox="image" 
               data-caption="">
                <img src="{{ asset('uploads/slider/' . $slider->image) }}" 
                     alt="" 
                     style="width: 50px; height: 38px; margin-left: 10px;" />
            </a>
        @endif
    </div>
</div>
<div class="col-md-4 mb-3">
  <label for="button_name" class="form-label">Button Name</label>
  <input type="text" class="form-control @error('button_name') is-invalid @enderror" id="button_name" value="{{$slider->button_name}}" name="button_name" placeholder="">
</div>
<div class="col-md-4 mb-3">
  <label for="button_url" class="form-label">Button url</label>
  <input type="text" class="form-control @error('button_url') is-invalid @enderror" id="button_url" value="{{$slider->button_url}}" name="button_url" placeholder="">
</div>
	<div class="col-md-4 mb-3">
										<label for="bsValidation7" class="form-label">Country</label>
							
										                              <select name="country" class="form-select" id="countries">
        <option value="">Select Countries</option>
        @foreach($country as $countryData)
            <option value="{{$countryData->countries_id}}" @if($countryData->countries_id == $slider->country) selected @endif>
                {{$countryData->name}}
            </option>
        @endforeach
    </select>
									
									</div>
									
									<div class="col-md-4 mb-3">
										<label for="bsValidation8" class="form-label">State</label>
									                                    <select name="state" class="form-select" id="state">
        {!! locationOptions('state', $slider->state ?? '') !!}
    </select>
									
									</div>
									<div class="col-md-4 mb-3">
										<label for="bsValidation9" class="form-label">City</label>
									  <select name="city" class="form-select" id="city" >
                                            {!! locationOptions('city', $slider->city ?? '') !!}
                                        </select>
									
									</div>

    <div class="col-md-12 mb-3">
    <label for="image_description" class="form-label">Image Description</label>
    <textarea name="image_description" id="image_description" class="form-control" rows="3" placeholder="">{{$slider->image_description}}</textarea>
  </div>
        <div class="col-12 text-end">
<button class="btn btn-primary" type="submit" id="submit-btn" name="submit" value="submit">
  Update
</button>
        </div>
      </div>
    </section>
  </form>
							</div>
						</div>
					</div>
				</div>
</div>
</div>

	


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')
@include('backend/include/statebycity/statebycity')
@include('backend/include/subservicebychildservice/subservicebychildservice') 



<script>
  $(document).ready(function () {
      
    function initSelect2(selector, options = {}) {
      $(selector).select2($.extend({
        theme: "bootstrap-5",
        width: $(selector).data('width') ? $(selector).data('width') : $(selector).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(selector).data('placeholder'),
      }, options));
    }
    initSelect2('#countries');
    initSelect2('#state');
    initSelect2('#city');
    initSelect2('#pincode');
    initSelect2('#service_id');
    initSelect2('#subservice_id');
    initSelect2('#childservice_id');
    initSelect2('#serviceplan_id');
  });
</script>



</body>

</html>