
@include('backend/include/custom')


<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>


@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Slider</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->


<!--start page wrapper -->
<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3">
        <i class="bx bx-carousel me-1"></i>

        <span>Slider</span>
    </div>
</div>

    <div class="page-content">
        <div class="row">
            <div class="col-xl-12 mx-auto">
                            <!-- Nav tabs -->
<div class="card">
    <!-- Tabs Header -->
    <div class="bg-light border-bottom-0 pb-0 px-0">
        <ul class="nav nav-tabs" id="settingsTab" role="tablist">
            @if(permission(session('SUPERADMIN_ID'), '18', 'action_view'))
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="others-tab" data-bs-toggle="tab" data-bs-target="#others" type="button" role="tab" aria-controls="others" aria-selected="true">
                    View
                </button>
            </li>
            @endif
            @if(permission(session('SUPERADMIN_ID'), '18', 'action_add'))
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="logo-tab" data-bs-toggle="tab" data-bs-target="#logo" type="button" role="tab" aria-controls="logo" aria-selected="false">
                    Add
                </button>
            </li>
            @endif
        </ul>
    </div>

    <!-- Tabs Content -->
    <div class="card-body p-4">

            <div class="tab-content" id="settingsTabContent">
<div class="tab-pane fade show active" id="others" role="tabpanel" aria-labelledby="others-tab">
  <div class="card-body">
    <div class="table-responsive">
      <table id="basic21"  class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
        <thead>
          <tr class="hello1">
            <th>ID</th>
            <th>Ordering By</th>
            <th>Service</th>
            <th>Title</th>
            <th>Image</th>
            <th>Status</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>
    </div>
  </div>
</div>

                <!-- Tab 2: Logo & Images -->
<div class="tab-pane fade" id="logo" role="tabpanel" aria-labelledby="logo-tab">
  <form class="row g-3 needs-validation" onsubmit="return myckediter()" id="formatDistrict-update" method="POST" action="{{asset('backend/slidercreate')}}" enctype="multipart/form-data" novalidate>
    @csrf
    <section class="mb-4">
      <div class="row">
				<div class="col-md-6 mb-3">
					<label for="bsValidation1" class="form-label"> Services</label>
					<select class="form-select @error('title') is-invalid @enderror" id="service_id" name="service_id">
						<option value="">Select Service </option>
						@foreach($services as $data)
						<option value="{{$data->id}}">{{$data->title}}</option>
						@endforeach
					</select>

				</div>
				<div class="col-md-6 mb-3">
					<label for="bsValidation1" class="form-label"> Subservices</label>
					<select class='form-control @error(' subservice_id') is-invalid @enderror' name="subservice_id"
						id="subservice_id">
						<option value="" selected disable>Select Subservice</option>
					</select>
				</div>
<div class="col-md-4 mb-3">
  <label for="title" class="form-label">Title<span class="text-danger">*</span></label>
  <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" name="title" placeholder="" required>
</div>
<div class="col-md-4 mb-3">
  <label for="tagline" class="form-label">Tagline</label>
  <input type="text" class="form-control @error('tagline') is-invalid @enderror" id="tagline" name="tagline" placeholder="">
</div>
				<!-- Ordering By -->
				<div class="col-md-4 mb-3">
					<label for="ordering_by" class="form-label">Ordering By <span class="text-danger">*</span></label>
					<input type="number" class="form-control @error('ordering_by') is-invalid @enderror"
						id="ordering_by" name="ordering_by" required>
					<div class="invalid-feedback">
						@error('ordering_by')
						<span class="alert text-danger">{{ $message }}</span>
						@enderror
					</div>
				</div>
<div class="col-md-4 mb-3">
    <label for="image" class="form-label">Image<span class="text-danger">*(JPG, PNG, WEBP)</span></label>
    <input data-value="imageerror1" type="file" class="form-control image @error('image') is-invalid @enderror" id="image" name="image" accept=".jpg,.jpeg,.png,.webp" required>
		<div class="error-message" id="imageerror1" style="color: red;"></div>
			<div class="valid-feedback">
			@error('image')
            <span class="alert text-danger">{{ $message }}</span>
            @enderror
	    </div>
</div>
<div class="col-md-4 mb-3">
  <label for="button_name" class="form-label">Button Name</label>
  <input type="text" class="form-control @error('button_name') is-invalid @enderror" id="button_name" name="button_name" placeholder="">
</div>
<div class="col-md-4 mb-3">
  <label for="button_url" class="form-label">Button url</label>
  <input type="text" class="form-control @error('button_url') is-invalid @enderror" id="button_url" name="button_url" placeholder="">
</div>

<div class="col-md-4 mb-3">
    <label for="bsValidation7" class="form-label">Country</label>
    
    <select class=" form-control"  name="country" id="countries">
    <option value="">Select Countries</option>
    @foreach($country as $countryData)
    <option value="{{$countryData->countries_id }}" >{{$countryData->name}}</option>
    @endforeach
    
    </select>
    
    </div>
    
    <div class="col-md-4 mb-3">
    <label for="bsValidation8" class="form-label">State</label>
    
    <select name="state" class="form-select" id="state">
    <option value="">Select State</option>
    </select>
    </div>
    
    
    <div class="col-md-4 mb-3">
    <label for="bsValidation9" class="form-label">City</label>
    
    <select name="city" class="form-select" id="city">
    <option value="">Select City</option>
    </select>
    
    </div>
    <div class="col-md-12 mb-3">
    <label for="image_description" class="form-label">Image Description</label>
    <textarea name="image_description" id="image_description" class="form-control" rows="3" placeholder=""></textarea>
  </div>


 

        <div class="col-12 text-end">
<button class="btn btn-primary" type="submit" id="submit-btn" name="submit" value="submit">
  Submit
</button>
        </div>
      </div>
    </section>
  </form>
</div>

            </div>
    </div>
</div>

            </div>
        </div>
        <!--end row-->
    </div>
</div>

<div id="loader" xss=removed>
    <div class="lds-hourglass"></div>
</div>


@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')
@include('backend/include/statebycity/statebycity')
@include('backend/include/subservicebychildservice/subservicebychildservice')




    <script>


      $(document).ready(function () {
        $.ajaxSetup({
          headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
          },
        });

        $("#basic21").DataTable({
             @include('backend.include.datatableajax.datatablefilter')
          processing: true,
          serverSide: true,
          serverMethod: "POST",
          ajax: {
            url: "{{ asset('backend/sliderajax') }}",
            dataSrc: function (json) {
              console.log("AJAX SUCCESS DATA:", json);
              return json.data;
            },
            error: function (xhr, error, thrown) {
              console.log("AJAX ERROR:", xhr.responseText);
            },
            beforeSend: function () {
                    $('#loader').show(); 
                    },
                    complete: function () {
                    $('#loader').hide(); 
                   
                     }
          },
          columns: [
            { data: "id" },
            { data: "ordering_by" },
            { data: "service" },
            { data: "title" },
            // { data: "tagline" },
            { data: "image" },
            // { data: 'button_name' },
            // { data: "button_url" },
            { data: "status" },
            { data: "action" }
          ],
        });
      });



    </script>







  <script>
      $(document).on('change', '.toggle-flip input[type="checkbox"]', function () {
        let status = $(this).prop('checked') ? 1 : 0;
        let userId = $(this).data('id');

        $.ajax({
          type: "POST",
          url: "{{ asset('backend/sliderstatus') }}",
          data: {
            status: status,
            id: userId,
            _token: '{{ csrf_token() }}',
          },
          success: function (response) {
            console.log("Status updated", response);
          },
          error: function (xhr) {
            console.log("AJAX Error:", xhr);
            alert("Something went wrong");
          }
        });
      });
    </script>

<script>
  $(document).ready(function () {
      
    function initSelect2(selector, options = {}) {
      $(selector).select2($.extend({
        theme: "bootstrap-5",
        width: $(selector).data('width') ? $(selector).data('width') : $(selector).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(selector).data('placeholder'),
      }, options));
    }
    initSelect2('#countries');
    initSelect2('#state');
    initSelect2('#city');
    initSelect2('#pincode');
    initSelect2('#service_id');
    initSelect2('#subservice_id');
    initSelect2('#childservice_id');
    initSelect2('#serviceplan_id');
  });
</script>
    

</body>

</html>