@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

  <!--favicon-->

  @include('backend/include/head')
  @include('backend/include/datatableajax/tablelink')

  <title>Email Template</title>
</head>

<body>
  <!--wrapper-->
  <div class="wrapper">
    <!--sidebar wrapper -->
    @include('backend/include/sidebar')
    <!--end sidebar wrapper -->
    <!--start header -->
    @include('backend/include/header')
    <!--end header -->

    <!--start page wrapper -->
    <div class="page-wrapper">
      <div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
        <div class="breadcrumb-title d-flex align-items-center ms-3">
          <i class="bx bx-envelope me-1"></i>
          <span>Email Template</span>
        </div>
      </div>
      <div class="page-content">

        <div class="row">
          <div class="col-xl-12">
            <div class="card">
              <div class="bg-light border-bottom-0 pb-0 px-0">
                <ul class="nav nav-tabs justify-content-start" id="settingsTab" role="tablist">
                    @if(permission(session('SUPERADMIN_ID'), '7', 'action_view'))
                  <li class="nav-item" role="presentation">
                    <button class="nav-link active text-dark" id="others-tab" data-bs-toggle="tab"
                      data-bs-target="#others" type="button" role="tab" aria-controls="others" aria-selected="true">
                      View
                    </button>
                  </li>
                  @endif
                  @if(permission(session('SUPERADMIN_ID'), '7', 'action_add'))
                  <li class="nav-item" role="presentation">
                    <button class="nav-link text-dark" id="logo-tab" data-bs-toggle="tab" data-bs-target="#logo"
                      type="button" role="tab" aria-controls="logo" aria-selected="false">
                      Add
                    </button>
                  </li>
                  @endif
                </ul>
              </div>

              <div class="card-body ">
                <div class="tab-content" id="settingsTabContent">
                  <!-- Tab 1: Logo & Images -->
                  <div class="tab-pane fade" id="logo" role="tabpanel" aria-labelledby="logo-tab">

                    <div class="card-body">
                      <form class="row g-3 needs-validation" method="POST"
                        action="{{ asset('backend/emailtemplateadd') }}" novalidate>
                        @csrf

                        <div class="col-md-12">
                          <label for="add_title" class="form-label">Title<span class="text-danger">*</span></label>
                          <input type="text" name="title" id="add_title" class="form-control" placeholder="" required>
                        </div>

                        <div class="col-md-12">
                          <label for="add_subject" class="form-label">Subject <span class="text-danger">*</span></label>
                          <textarea name="subject" id="add_subject" class="form-control" rows="2"
                            placeholder="" required></textarea>
                        </div>

                        <div class="col-md-12">
                          <label for="add_content" class="form-label">Content<span class="text-danger">*</span></label>
                          <textarea name="content" id="description" class="form-control" rows="4"
                            placeholder="" required></textarea>
                        </div>

                        <div class="col-12 text-end">
                          <button type="submit" class="btn btn-primary mt-3">Submit</button>
                        </div>
                      </form>
                    </div>

                  </div>


                  <!-- Tab 2: Other Settings -->
                  <div class="tab-pane fade show active" id="others" role="tabpanel" aria-labelledby="others-tab">
                    <div class="card-body">
                      <div class="table-responsive">
                        <table id="basic25" class="table table-striped  dataTable border table-bordered no-footer"
                          style="width:100%">
                          <thead>
                            <tr>
                              <th>ID</th>

                              <th>Title</th>
                              <th>Subject</th>
                              <!--<th>Contant</th>-->

                              <th>Status</th>
                              <th>Action</th>
                            </tr>
                          </thead>
                          <tbody>
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>

              </div>
            </div>
          </div>

        </div>


      </div>
    </div>


 

    <!-- Edit Modal -->
    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-lg">
        <form class="g-3 needs-validation" id="editEmailTemplateForm"  method="POST" action="{{ asset('backend/emailtemplateupdate') }}" novalidate>
          @csrf
          <input type="hidden" name="id" id="id" />

          <div class="modal-content">
            <div class="modal-header p-2 usbb">
              <h5 class="modal-title text-white " id="editModalLabel"> Email Template Update</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <div class="mb-3">
                <label for="edit_title" class="form-label">Title <span class="text-danger"> *</span></label>
                <input type="text" name="title" id="edit_title" class="form-control" placeholder="" required>
              </div>
              <div class="mb-3">
                <label for="edit_subject" class="form-label">Subject <span class="text-danger"> *</span></label>
                <textarea name="subject" id="edit_subject" class="form-control" rows="2" placeholder=""
                  required></textarea>
              </div>

              <div class="mb-3">
                <label for="edit_content" class="form-label">Content <span class="text-danger"> *</span></label>
                <textarea name="content" id="edit_content" class="form-control" rows="4"
                  placeholder="" required></textarea>
              </div>

            </div>
            <div class="modal-footer">
              <button type="submit" class="btn btn-primary">Update</button>
            </div>
          </div>
        </form>
      </div>
    </div>


<div id="loader" xss=removed>
    <div class="lds-hourglass"></div>
</div>

    @include('backend/include/footer')
    @include('backend/include/datatableajax/tablescript')

    <script>
      function emailtemplateedit(row) {

        $('#id').val(row.id);

        $('#edit_title').val(row.title);
        $('#edit_subject').val(row.subject);
        $('#edit_content').val(row.content);
        CKEDITOR.instances.edit_content.setData(row.content);



      }
    </script>

    <script>


      $(document).ready(function () {
        $.ajaxSetup({
          headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
          },
        });

        $("#basic25").DataTable({
             @include('backend.include.datatableajax.datatablefilter')
          processing: true,
          serverSide: true,
          serverMethod: "POST",
          ajax: {
            url: "{{ asset('backend/emailtemplateviewajax') }}",
            dataSrc: function (json) {
              console.log("AJAX SUCCESS DATA:", json);
              return json.data;
            },
            error: function (xhr, error, thrown) {
              console.log("AJAX ERROR:", xhr.responseText);
            },
            beforeSend: function () {
                    $('#loader').show(); 
                    },
                    complete: function () {
                    $('#loader').hide(); 
                   
                     }

          },
          columns: [
            { data: "id" },
            { data: "title" },
            { data: "subject" },
            // { data: "content" },
            { data: "status" },
            { data: "action" }
          ],
        });
      });



    </script>

    <script>
      $(document).on('change', '.toggle-flip input[type="checkbox"]', function () {
        let status = $(this).prop('checked') ? 1 : 0;
        let userId = $(this).data('id');

        $.ajax({
          type: "POST",
          url: "{{ asset('backend/emailtemplatestatus') }}",
          data: {
            status: status,
            id: userId,
            _token: '{{ csrf_token() }}',
          },
          success: function (response) {
            console.log("Status updated", response);
          },
          error: function (xhr) {
            console.log("AJAX Error:", xhr);
            alert("Something went wrong");
          }
        });
      });
    </script>

    <script>
      document.addEventListener("DOMContentLoaded", function () {
        if (document.getElementById('description')) {
          CKEDITOR.replace('description');
        }
        if (document.getElementById('edit_content')) {
          CKEDITOR.replace('edit_content');
        }
      });


    </script>


</body>

</html>