@include('backend/include/custom')
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>
<!-- Required meta tags -->

<!--favicon-->

@include('backend/include/head')
@include('backend/include/datatableajax/tablelink')

<title>Admin User</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
@include('backend/include/sidebar')	
<!--end sidebar wrapper -->
<!--start header -->
@include('backend/include/header')	
<!--end header -->


<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3">
        <i class="bx bx-group me-1 mb-1"></i>
        <span>Admin User</span>
    </div>
</div>
<div class="page-content">
	 <div class="ms-auto">
   
    
     <div class="row">
					<div class="col-xl-12">
                
					<div class="card">
					 <!--   <div class="card-header  text-capitalize">-->
      <!--                      <h6 class="mb-0">Admin User </h6>-->
						<!--</div>-->
					 <div class="card-body">
						<div class="table-responsive">
							<table id="adminusertable" class="table table-striped  dataTable border table-bordered no-footer" style="width:100%">
								<thead>
									<tr class="hello1" >
    								<th>ID</th>
										<th>Image</th>
										<th>Role</th>
										<th> Name</th>
										<th>Number</th>
										<th>Email</th>
									
										<th>Status</th>
										<th>Action</th>
    								    
									</tr>
								</thead>
								<tbody>
								</tbody>
							</table>
						</div>
					</div>
				</div>
					</div>
					
				</div>
  
    </div>
</div>
</div>
<div class="switcher-wrapper">
    @if(permission(session('SUPERADMIN_ID'), '4', 'action_view'))
        <div class="switcher-btn">
            <i class='bx bx-filter-alt'></i>
        </div>
    @endif

    <div class="card">
        <div class="card-header text-capitalize usbb d-flex align-items-center">
            <h4 class="mb-0 text-white">Filter</h4>
            <button type="button" class="btn-close ms-auto close-switcher bg-white" aria-label="Close"></button>
        </div>

        <div class="switcher-body">
            @php
                if(!empty($_GET['role'])){
                    $role = $_GET['role'];
                } else {
                    $role = "";
                }
                if(!empty($_GET['emailmobile'])){
                    $emailmobile = $_GET['emailmobile'];
                } else {
                    $emailmobile = "";
                }
            @endphp

            <form class="row g-3 needs-validation" id="filterForm" novalidate style="margin-top: -16px;">
                <div class="col-md-12">
                    <label for="userSelect" class="form-label">Role</label>
                    <select class="form-control" name="role" id="role">
                        <option value="">Select Role</option>
                        @foreach($roles as $data)
                            <option value="{{ $data->id }}" @if($role == $data->id) selected @endif>
                                {{ $data->role }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-12">
                    <label for="userSelect" class="form-label">Email/Mobile Number</label>
                    <input type="text" class="form-control" name="emailmobile" id="emailmobile" value="{{ $emailmobile }}" placeholder="Enter Email/Number">
                </div>

                <div class="col-md-12"></div>
                <div class="col-md-8">
                    <div>
                        <button type="submit" id="submitBtn" class="btn btn-primary px-3">Apply</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>



<div class="plus-wrapper">
      @if(permission(session('SUPERADMIN_ID'), '4', 'action_add'))
<div class="plus-btn">  <a href="{{asset('backend/adminuseradd')}}" class="btn btn-primary"><i class='bx bx-plus'></i> </a> 
@endif
</div>
</div>



<style>
    .plus-wrapper {

	width: 280px;

	height: 100%;

	position: fixed;

	right: -280px;

  top: -21% !important;

	bottom: 0;

	z-index: 1;

	background: #fff;

	border-left: 0 solid #d2d2d2;

	box-shadow: 0 .3rem .6rem rgba(0, 0, 0, .13);

	transition: all .2s ease-out

}


.plus-btn {

	width: 40px;

	height: 40px;

	line-height: 40px;

	font-size: 24px;

	background: #008cff;

	box-shadow: 0 .3rem .6rem rgba(0, 0, 0, .13);

	color: #fff;

	text-align: center;

	border-top-left-radius: 10px;

	border-bottom-left-radius: 10px;

	position: absolute;

	top: 40%;

	right: 100%;

	cursor: pointer

}



.plus-wrapper.plus-toggled {

	right: 0

}



.plus-body {

	padding: 1.25rem

}



.plus-body .form-check .form-check-input,

.plus-body .form-check .form-check-label {

	cursor: pointer




}



.switcher-wrapper {
top: 0% !important;
	width: 367px;
		right: -367px;
}


.switcher-btn {
  top: 27% !important;
}




</style>

  	<div id="loader" style="display:none;">
    <div class="lds-hourglass"></div>
</div>	

@include('backend/include/footer')
@include('backend/include/datatableajax/tablescript')



 <script>
        $(document).ready(function () {
         
            $.ajaxSetup({
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                },
            });

            $("#adminusertable").DataTable({
                 @include('backend.include.datatableajax.datatablefilter')
                
                processing: true,
                serverSide: true,
                serverMethod: "POST",
               ajax: {
                        url: "{{ route('backend.houseajexadminuser') }}",
                       data: function (d) {
    d.role = $('#role').val();
    d.emailmobile = $('#emailmobile').val();
},
 beforeSend: function () {
                    $('#loader').show(); 
                    },
                    complete: function () {
                    $('#loader').hide(); 
                   
                     }
                  
                    },
                    
                columns: [
                    { data: "id" },
                    { data: "image", title: "Image" },
                    { data: "role", title: " Role" },
                    { data: "name", title: " Name" },
                    { data: "number", title: " Number" },
                   
                    { data: "email", title: "Email" },
                    { data: "status", title: " Status" },
                    { data: "action", title: "Action" }
                ],
            });
        });
    </script>

	
	
	<script>
	    	$(document).on('change', '.toggle-flip input[type="checkbox"]', function () {
    let status = $(this).prop('checked') ? 1 : 0;
    let userId = $(this).data('id');

    $.ajax({
        type: "POST",
        url: "{{ asset('backend/adminuserstatus') }}",
        data: {
            status: status,
            id: userId,
            _token: '{{ csrf_token() }}',
        },
        success: function (response) {
            console.log("Status updated", response);
        },
        error: function (xhr) {
            console.log("AJAX Error:", xhr);
            alert("Something went wrong");
        }
    });
});
	</script>



</body>

</html>












              



