<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_activity_masters', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->text('credit_message')->nullable();
            $table->text('debit_message')->nullable();
            $table->string('table_name')->nullable();
            $table->enum('status',['0','1'])->default(1);
            $table->string('ip')->nullable();
            $table->string('strtotime')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_activity_masters');
    }
};
