<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_orders', function (Blueprint $table) {
            $table->id();
            $table->string('orderid');
            $table->string('bill_number')->nullable();
            $table->string('user_id')->nullable();
            $table->string('addressid')->nullable();
            $table->string('bookingdate')->nullable();
            $table->string('bookingtime')->nullable();
            $table->string('paymentstatus')->nullable()->comment('1(uunpaid),2(paid)');
            $table->string('bookingdatestrtotime')->nullable();
            $table->string('paymentid')->nullable();
            $table->string('countery_id')->nullable();
            $table->string('state_id')->nullable();
            $table->string('city_id')->nullable();
            $table->string('address')->nullable();
            $table->string('user_number')->nullable();
            $table->string('user_name')->nullable();
            $table->string('pincode')->nullable();
            $table->string('user_email')->nullable();
            $table->string('user_gst_number')->nullable();
            $table->string('company_name')->nullable();
            $table->integer('subamount')->nullable();
            $table->integer('cgst')->nullable();
            $table->integer('igst')->nullable();
            $table->integer('sgst')->nullable();
            $table->integer('texamount')->nullable();
            $table->integer('totalamount')->nullable();
            $table->string('serviceid')->nullable();
            $table->string('totalservicebooking')->nullable();
            $table->string('bookingdatetime')->nullable();
            $table->string('razorpay_signature')->nullable();
            $table->string('order_otp')->nullable();
            $table->string('partner_id')->nullable();
            $table->string('message')->nullable();
            $table->string('otp_verify')->nullable();
            $table->string('work_status')->nullable()->comment('0(reject),1(accept),2(inprogress),3(pendding)');
            $table->string('re_open_status')->nullable()->comment('1(reopend),0(realoredr)');
            $table->string('payment_mode')->nullable();
            $table->string('latitude')->nullable();
            $table->string('longitude')->nullable();
            $table->string('admin_live_address')->nullable();
            $table->string('lead_id')->nullable();
            $table->enum('bill_status',['0','1'])->default('0');
            $table->enum('status',['0','1'])->default('1');
            $table->string('panel_id')->nullable();
            $table->string('created_by')->nullable();
            $table->string('strtotime')->nullable();
            $table->string('ip')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_orders');
    }
};
