<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('partners', function (Blueprint $table) {
            //
            $table->string('id_proof')->nullable()->after('mobile_number');
            $table->string('partner_code')->nullable()->after('id_proof');
            $table->string('salary_status')->nullable()->after('partner_code');
            $table->string('salary')->nullable()->after('salary_status');
            $table->string('total_days')->nullable()->after('salary');
            $table->string('per_day_salary')->nullable()->after('total_days');
            $table->string('per_day_hourly')->nullable()->after('per_day_salary');
            $table->string('per_hours_salary')->nullable()->after('per_day_hourly');
            $table->string('take_breack_hours')->nullable()->after('per_hours_salary');
            $table->string('commission')->nullable()->after('take_breack_hours');
            $table->string('countries')->nullable()->after('commission');
            $table->string('state')->nullable()->after('countries');
            $table->string('city')->nullable()->after('state');
            $table->string('pincode')->nullable()->after('city');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('partners', function (Blueprint $table) {
            //
        });
    }
};
