<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_logs', function (Blueprint $table) {
            $table->id();
            $table->string('activity_id')->nullable();
            $table->string('user_id')->nullable();
            $table->string('table_primary_id')->nullable();
            $table->text('description')->nullable();
            $table->text('before')->nullable();
            $table->text('after')->nullable();
            $table->string('ip')->nullable();
            $table->string('strtotime')->nullable();
            $table->string('date_time')->nullable();
            $table->string('read_status')->default('0');
            $table->enum('status',['0','1'])->default('1');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_logs');
    }
};
