<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('brands', function (Blueprint $table) {
            $table->id();
            $table->string('service_select')->nullable();
            $table->string('subservice_select')->nullable();
            $table->string('brand_name')->nullable();
            $table->string('user_id')->nullable();
            $table->string('slug')->nullable();
            $table->string('brand_logo')->nullable();
            $table->text('tollfree_number')->nullable();
            $table->text('description')->nullable();
            $table->enum('status',['0','1'])->default('1');
            $table->string('tokan')->nullable();
            $table->string('ip')->nullable();
            $table->string('strtotime')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('brands');
    }
};
