<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('websitesettings', function (Blueprint $table) {
            $table->id();
             $table->string('site_title')->nullable();
            $table->string('fevicon')->nullable();
            $table->string('header_logo')->nullable();
            $table->string('footer_logo')->nullable();
            $table->string('whatsapp')->nullable();
            $table->string('mobile_number')->nullable();
            $table->string('login_otp_default_number')->nullable();
            $table->string('otp_defalut_status')->nullable();
            $table->string('login_with_opt_apply')->nullable();
            $table->string('email')->nullable();
            $table->text('address')->nullable();
            $table->text('web_url')->nullable();
            $table->string('facebook')->nullable();
            $table->string('linkedin')->nullable();
            $table->string('instagram')->nullable();
            $table->string('twitter')->nullable();
            $table->string('youtube')->nullable();
            $table->text('footer_content')->nullable();
            $table->text('copyright')->nullable();
            $table->text('meta_title')->nullable();
            $table->text('meta_keyword')->nullable();
            $table->text('meta_description')->nullable();
            $table->text('video_link')->nullable();
            $table->text('map_link')->nullable();
            $table->enum('status',['0','1'])->default('1');
            $table->string('ip')->nullable();
            $table->string('strtotime')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('websitesettings');
    }
};
