<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class user_logs extends Model
{
    use HasFactory;
    
public static function userlogsusersajax($start, $searchValue, $columnSortOrder, $columnName, $rowcount, $length, $userid)
{
    $query = DB::table('user_logs')
        ->where('user_id', $userid)
        ->where('created_at', '>=', now()->subDays(30))
        ->orderBy($columnName, $columnSortOrder);

    if (!empty($searchValue)) {
        $query->where(function ($q) use ($searchValue) {
            $q->where('id', 'like', '%' . $searchValue . '%')
              ->orWhere('curd_functions', 'like', '%' . $searchValue . '%')
              ->orWhereIn('activity_id', function ($sub) use ($searchValue) {
                    $sub->select('id')
                        ->from('tbl_activities')
                        ->where('activity', 'like', '%' . $searchValue . '%');
              });
        });
    }

    if ($rowcount == 1) {
        return $query->offset($start)->limit($length)->get();
    } else {
        return $query->count();
    }
}
}
