<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class tbl_cart extends Model
{
    use HasFactory;
    
  public static function cartusersajax($start, $searchValue, $columnSortOrder, $columnName, $rowcount, $length, $userid)
{
    $query = DB::table('tbl_carts')
        ->where('user_id', $userid)
        ->where('created_at', '>=', now()->subDays(30))
        ->orderBy($columnName, $columnSortOrder);

    if (!empty($searchValue)) {
        $query->where(function ($q) use ($searchValue) {
            $q->where('id', 'like', '%' . $searchValue . '%')
              ->orWhere('plan_product_id', 'like', '%' . $searchValue . '%')
              ->orWhere('price', 'like', '%' . $searchValue . '%')
              ->orWhere('quantity', 'like', '%' . $searchValue . '%');
        });
    }

    if ($rowcount == 1) {
        return $query->offset($start)->limit($length)->get();
    } else {
        return $query->count();
    }
}

  
    
}
