<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use DB;
class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];
    
    
    
    
    
 public static function usersajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,$rowcount,$filterData){
    $name   = $filterData['name'] ?? null;
    $email  = $filterData['email'] ?? null;
    $number = $filterData['number'] ?? null;

    $start  = $filterData['start'] ?? 0;  
    $length = $filterData['length'] ?? 10;

    $query = DB::table('users')->orderBy($columnName, $columnSortOrder);

    if($searchValue){
        $query->where(function($q) use ($searchValue){
            $q->where('name','like','%'.$searchValue.'%')
              ->orWhere('email','like','%'.$searchValue.'%')
              ->orWhere('phone_number','like','%'.$searchValue.'%');
        });
    }

    if(!empty($name)){
        $query->where('name','like','%'.$name.'%');
    }
    if(!empty($email)){
        $query->where('email','like','%'.$email.'%');
    }
    if(!empty($number)){
        $query->where('phone_number','like','%'.$number.'%');
    }

    if($rowcount==1){
        return $query->offset($start)->limit($length)->get();
    } else {
        return $query->count();
    }
}





    
}
