<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Subservice extends Model
{
    use HasFactory;
    
    
    public static function subserviceajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,$rowcount,$length){
    
    
        $user_id = session('SUPERADMIN_ID');
    
        $start = $draw;
        
        $canViewGlobal = permission($user_id, '6', 'action_globle_view');
        $canAccessCity = permission($user_id, '6', 'action_globle_city');

        $city = superadmin::where('id', $user_id)->first();
        $globle = $city->global_city ?? 0;

        if ($user_id == '1') {
            $query = DB::table('subservices')->orderBy('ordering_by', 'ASC');

        } elseif ($globle == 1 && $canViewGlobal) {
            $query = DB::table('subservices')->orderBy('ordering_by', 'ASC');

        } elseif ($globle == 1 && $canAccessCity) {
            $query = DB::table('subservices')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');

        } else {
            $query = DB::table('subservices')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
        }

        
            
        if ($searchValue) {
            $query->join('services', 'services.id', '=', 'subservices.service_id')
                ->where(function ($q) use ($searchValue) {
                    $q->where('subservices.title', 'like', '%' . $searchValue . '%')
                        ->orWhere('services.title', 'like', '%' . $searchValue . '%'); 
                })
                ->select('subservices.*'); // subservices ka data hi aayega
        }

            
            // $sql = $query->toSql();
            // $bindings = $query->getBindings();
            
            // foreach ($bindings as $binding) {
            // $sql = preg_replace('/\?/', "'$binding'", $sql, 1);
            // }
            
            // if($rowcount == 1){
            // // $query->limit(10)->offset($start);
            // $query->offset($start)->take($length);
            // return $query->get();
            // }else{
            // return $query->count();    
            // }}
            if ($rowcount == 1) {
        
            $length = $length > 0 ? $length : 10; 
            $query->skip((int)$start)->take((int)$length);

            return $query->get();
        } else {
            return $query->count();
        }
    }

    public function subservices()
    {
        return $this->hasMany(Subservice::class, 'service_id', 'id');
    }
}

