<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class ServicePlan extends Model
{
    use HasFactory;
    
        public static function serviceplanajaxview($draw, $searchValue, $columnSortOrder, $columnName, $columnIndex, $filltersearchValue, $rowcount, $length, $start)
{
    $user_id = session('SUPERADMIN_ID');

    $canViewGlobal = permission($user_id, '17', 'action_globle_view');
    $canAccessCity = permission($user_id, '17', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($city->role == '1') {
        $query = DB::table('service_plans')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('service_plans')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('service_plans')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    } else {
        $query = DB::table('service_plans')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    }
if ($searchValue) {
    $query->leftJoin('services', 'services.id', '=', 'service_plans.service_id')
          ->leftJoin('subservices', 'subservices.id', '=', 'service_plans.subservice_id')
          ->leftJoin('child_services', 'child_services.id', '=', 'service_plans.childservice_id')
          ->where(function ($q) use ($searchValue) {
              $q->where('service_plans.title', 'like', '%' . $searchValue . '%')
                ->orWhere('services.title', 'like', '%' . $searchValue . '%')
                ->orWhere('subservices.title', 'like', '%' . $searchValue . '%')
                ->orWhere('child_services.title', 'like', '%' . $searchValue . '%');
          })
          ->select([
              'service_plans.*',
              'services.title as service_title',
              'subservices.title as subservice_title',
              'child_services.title as childservice_title',
          ]);
}




    if ($rowcount == 1) {
      
        $length = $length > 0 ? $length : 10; 
        $query->skip((int)$start)->take((int)$length);

        return $query->get();
    } else {
        return $query->count();
    }
}
}
