<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
use App\Models\superadmin;
class Newsletter extends Model
{
    use HasFactory;
     protected $fillable = [
        'email',
        'newsletter_status',
        'user_id',
        'ip',
        'strtotime',
        'created_at',
        'updated_at'
    ];
    
    
    
public static function newsletterajax($draw, $searchValue, $columnSortOrder, $columnName, $columnIndex, $filltersearchValue, $rowcount, $length, $start, $filterData)
{
    $status = $filterData['status'] ?? null;
    $user_id = session('SUPERADMIN_ID');

    $canViewGlobal = permission($user_id, '31', 'action_globle_view');
    $canAccessCity = permission($user_id, '31', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($city->role == '1') {
        $query = DB::table('newsletters')->orderBy('id', 'DESC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('newsletters')->orderBy('id', 'DESC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('newsletters')->where('user_id', $user_id)->orderBy('id', 'DESC');
    } else {
        $query = DB::table('newsletters')->where('user_id', $user_id)->orderBy('id', 'DESC');
    }

 
    if ($searchValue) {
        $query->where(function ($q) use ($searchValue) {
            $q->where('email', 'like', '%' . $searchValue . '%')
              ->orWhereIn('user_id', function ($sub) use ($searchValue) {
                  $sub->select('id')->from('users')->where('name', 'like', '%' . $searchValue . '%');
              });

            if (strtolower($searchValue) === 'subscribe') {
                $q->orWhere('newsletter_status', '1');
            } elseif (strtolower($searchValue) === 'unsubscribe') {
                $q->orWhere('newsletter_status', '0');
            }
        });
    }

 
    if ($status !== null && $status !== '') {
        $query->where('newsletter_status', $status);
    }


    if ($rowcount == 1) {
        $length = $length > 0 ? $length : 10;
        $query->skip((int)$start)->take((int)$length);
        return $query->get();
    } else {
        return $query->count();
    }
}


}
