<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class ChildService extends Model
{
    use HasFactory;
    
    public static function childservicesajax($draw, $searchValue, $columnSortOrder, $columnName, $columnIndex, $filltersearchValue, $rowcount, $length, $start)
{
    $user_id = session('SUPERADMIN_ID');

    $canViewGlobal = permission($user_id, '12', 'action_globle_view');
    $canAccessCity = permission($user_id, '12', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($city->role == '1') {
        $query = DB::table('child_services')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('child_services')->orderBy('ordering_by', 'ASC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('child_services')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    } else {
        $query = DB::table('child_services')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    }
if ($searchValue) {
    $query->join('services', 'services.id', '=', 'child_services.service_id')->join('subservices', 'subservices.id', '=', 'child_services.subservice_id')
          ->where(function ($q) use ($searchValue) {
              $q->where('child_services.title', 'like', '%' . $searchValue . '%')
                ->orWhere('services.title', 'like', '%' . $searchValue . '%') 
                 ->orWhere('subservices.title', 'like', '%' . $searchValue . '%'); 
          })
          ->select('child_services.*'); 
}



    if ($rowcount == 1) {
      
        $length = $length > 0 ? $length : 10; 
        $query->skip((int)$start)->take((int)$length);

        return $query->get();
    } else {
        return $query->count();
    }
}
}
