<?php

namespace App\Http\Controllers\frontend\features;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Contactenquiry;
use App\Models\Websitesetting;
use App\Models\Additionalsetting;
use App\Mail\Frontend\EnquiryMail;
use Illuminate\Support\Facades\Mail;
use DB;


class ContactusController extends Controller

{
      function contactus(){
          
        $data['allotted'] = Websitesetting::where('id', '1')->first();
        $data['countries'] = DB::table('tbl_countries')->where('cstatus','1')->get();
        return view('frontend.features.contactus',$data);
    }
    
    function contactenquiry(Request $request){
    $captcha = verifyRecaptcha($request->input('g-recaptcha-response'));
    if (!$captcha['success']) {
        return redirect()->back()->with('error', $captcha['message']);
    }
    $websitestting=Websitesetting::where('id','1')->first();

    $contactenquiry = new Contactenquiry;
    $contactenquiry->name = $request->name;
    $contactenquiry->email = $request->email;
    $contactenquiry->number = $request->number;
    $contactenquiry->message = $request->message;
    $contactenquiry->enquiry_status = '2';
    $contactenquiry->ip = CurrentTimestamp()['ip'];
    $contactenquiry->strtotime = CurrentTimestamp()['strtotime'];
    $contactenquiry->created_at = CurrentTimestamp()['datetime'];
    $contactenquiry->updated_at = CurrentTimestamp()['datetime'];
    $contactenquiry->save();

    $data = [
        'name'    => $contactenquiry->name,
        'email'   => $contactenquiry->email,
        'number'  => $contactenquiry->number,
        'message' => $contactenquiry->message,
    ];

    try {
        $contentAdmin = emailcontent(13, 7, asset('uploads/websitesetting/' . $websitestting->header_logo), $data['name'], $data['email'], $data['number'], $data['message'], $websitestting->copyright, url('/'));
        $adminData = [
            'subject' => $contentAdmin['subject'],
            'message' => $contentAdmin['message'],
        ];
        Mail::to($websitestting->email)->send(new \App\Mail\Frontend\EnquiryMail($adminData, 'owner'));

        $contentUser = emailcontent(11, 4, asset('uploads/websitesetting/' . $websitestting->header_logo), $data['name'], $websitestting->copyright, url('/'));
        $userData = [
            'subject' => $contentUser['subject'],
            'message' => $contentUser['message'],
        ];
        Mail::to($contactenquiry->email)->send(new \App\Mail\Frontend\EnquiryMail($userData, 'user'));
    } catch (\Exception $e) {
        return redirect()->back()->with('error', 'Failed to send email. Error: ' . $e->getMessage());
    }

    return redirect()->back()->with('success', 'Message Sent Successfully');
}


}

