<?php

namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\MyAddress;
use App\Models\tbl_cart;
use App\Models\Promocode;
use App\Models\Tbl_Product;
use App\Models\ServicePlan;
use App\Models\Service;
use App\Models\PromocodeIncentive;
use Illuminate\Support\Facades\Crypt;
use App\Models\User;
use DB;
use Carbon\Carbon;
use App\Models\Websitesetting;
class CheckoutController extends Controller
{
    //
    
  function checkout(){

    // ===== CHECK CART DATA =====
    if (!empty(session('user_id'))) {

        $cartData = tbl_cart::where('user_id', session('user_id'))->get();

        if ($cartData->isEmpty()) {
            return redirect(asset('cart'));
        }

        $data['cart'] = $cartData;

    } else {

        $cartCookies = json_decode($_COOKIE['cart_items'] ?? '[]', true);
        if (empty($cartCookies)) {
            return redirect(asset('cart'));
        }

        $data['cartcookies'] = $cartCookies;
    }

    // ===== LOAD OTHER DATA =====
    $data['address']   = MyAddress::where('user_id', session('user_id')) ->orderBy('id', 'desc')->get();
    $data['allotted']  = Websitesetting::where('id', '1')->first();
    $data['countries'] = DB::table('tbl_countries') ->where('cstatus', '1') ->get();
    $data['payment_mod'] = DB::table('tbl_payment_mods') ->where('status', '1') ->get();
    $data['userdata']  = DB::table('users') ->where('status', '1')->where('id', session('user_id'))->first();
    $data['walletTotal'] = DB::table('tbl_wallets')->where('user_id',session('user_id'))->where('credit_debit_type','1')->sum('amount');

    return view('frontend.checkout', $data);
}

    
    
    
public function applypromocode(Request $request){

    $addressid = $request->addressid;
    $totamount = $request->total;
    $disprice = 0;
    $dis = 0;
    $now = Carbon::now('Asia/Kolkata');

    $website = Websitesetting::where('id','1')->first();
    $msg = "";
    $status = "error";
    $symbol = '%';

    if(!empty($request->promocode)){

        $pcode = $request->promocode;
        $total = $request->total;
        $user_id = session('user_id'); 
        $today = $now->format('Y-m-d');

        $data = Promocode::where('promocode', $pcode)->first();


       // 1. Promocode availability check
        if(!$data){
            return response()->json([ 'status' => 'error', 'msg' => 'Promocode not available','dis' => 0,'discount' => 0, 'total' => $totamount, 'symbol' => $symbol
            ]); 
        }

        // 2. Status check
        if(!$data || $data->status != 1){
            return response()->json([ 'status' => 'error', 'msg' => 'Promocode Expired', 'dis' => 0, 'discount' => 0, 'total' => $totamount, 'symbol' => $symbol
            ]);
        }

        // 3. Date validity check
        $startDate = date('Y-m-d', strtotime($data->startdate));
        $endDate   = date('Y-m-d', strtotime($data->enddate));
        if($startDate > $today || $endDate < $today){
            return response()->json([ 'status' => 'error', 'msg' => 'Promocode Expired', 'dis' => 0, 'discount' => 0, 'total' => $totamount, 'symbol' => $symbol
            ]);
        }

        // 4. Use range
        if($data->use_range <= 0){
            return response()->json(['status' => 'error','msg' => 'Promocode usage limit exceeded','dis' => 0,'discount' => 0,'total' => $totamount, 'symbol' => $symbol
            ]);
        }

        // 5. User limit
       

        // 6. Location check
        $address = DB::table('my_addresses')->where('id', $addressid)->first();
        if($address){
            if(!empty($data->countries) && $data->countries != $address->countries){
                return response()->json(['status' => 'error','msg' => 'Promocode not available for this country','dis' => 0,'discount' => 0,'total' => $totamount,'symbol' => $symbol
                ]);
            }
            if(!empty($data->state) && $data->state != $address->state){
                return response()->json(['status' => 'error','msg' => 'Promocode not available for this state','dis' => 0,'discount' => 0,'total' => $totamount,'symbol' => $symbol
                ]);
            }
            if(!empty($data->city) && $data->city != $address->city){
                return response()->json(['status' => 'error','msg' => 'Promocode not available for this city','dis' => 0,'discount' => 0,'total' => $totamount,'symbol' => $symbol
                ]);
            }
            if(!empty($data->pincode) && $data->pincode != $address->pincode){
                return response()->json(['status' => 'error','msg' => 'Promocode not available for this pincode','dis' => 0,'discount' => 0,'total' => $totamount,'symbol' => $symbol
                ]);
            }
        }

        // 7. Cart type match check (UPDATED LOGIC)
        
if(!empty($data->service_id)){
 $serviceIds = DB::table('tbl_carts')->where('user_id', $user_id)->pluck('service_id')->toArray();
  $uniqueServiceIds = array_unique($serviceIds);
  if(count(array_unique($serviceIds)) === 1){
        if($uniqueServiceIds[0]!=$data->service_id){
        return response()->json(['status' => 'error','msg' => 'Promocode  valid for this service','dis' => 0,'discount' => 0,'total' => $totamount,'symbol' => $symbol ]);  
        }
  }else{
      return response()->json(['status' => 'error','msg' => 'Promocode not valid for this service','dis' => 0,'discount' => 0,'total' => $totamount,'symbol' => $symbol]);  
  }
}

if(!empty($data->subservice_id)){
 $serviceIds = DB::table('tbl_carts')->where('user_id', $user_id)->pluck('subservice_id')->toArray();
  $uniqueServiceIds = array_unique($serviceIds);
  if(count(array_unique($serviceIds)) === 1){
        if($uniqueServiceIds[0]!=$data->subservice_id){
        return response()->json(['status' => 'error','msg' => 'Promocode  valid for this subservice','dis' => 0,'discount' => 0,'total' => $totamount,'symbol' => $symbol ]);  
        }
  }else{
      return response()->json(['status' => 'error','msg' => 'Promocode not valid for this subservice','dis' => 0,'discount' => 0,'total' => $totamount,'symbol' => $symbol]);  
  }
}

if(!empty($data->serviceplan_id)){
 $serviceIds = DB::table('tbl_carts')->where('user_id', $user_id)->pluck('type')->toArray();
 
  $uniqueServiceIds = array_unique($serviceIds);
  if(count(array_unique($serviceIds)) === 1){
        if($uniqueServiceIds[0]!=4){
        return response()->json(['status' => 'error','msg' => 'Promocode  valid for this plan','dis' => 0,'discount' => 0,'total' => $totamount,'symbol' => $symbol ]);  
        }else{
             $serviceId = DB::table('tbl_carts')->where('user_id', $user_id)->pluck('plan_product_id')->toArray();
              $uniqueServiceIds = array_unique($serviceId);
              if(count(array_unique($serviceId)) === 1){
                  if($data->serviceplan_id != $uniqueServiceIds[0]) {
                 return response()->json(['status' => 'error','msg' => 'Promocode  valid for this plan','dis' => 0,'discount' => 0,'total' => $totamount,'symbol' => $symbol ]);
           }
              }
             
           
        }
  }else{
      return response()->json(['status' => 'error','msg' => 'Promocode not valid for this plan','dis' => 0,'discount' => 0,'total' => $totamount,'symbol' => $symbol]);  
  }
}



        


        // 8. Apply discount
        $symbol = ($data->promocode_type == 1) ? '₹' : '%';

        if($data->incentive_status == 0){

            if($data->promocode_type == 1){
                $disprice  = $data->pricr_per;
                $totamount = $total - $disprice;
                $msg = '₹ '.$disprice.' discount applied';
            } else {
                $disprice  = round(($total/100)*$data->pricr_per, 3);
                $totamount = round($total - $disprice, 3);
                $msg = $data->pricr_per.'% discount applied';
            }

            $status = "success";
            session()->put('promocode', $data->promocode);

        } else if($data->incentive_status == 1){

            $incentives = PromocodeIncentive::where('promocode_id', $data->id)->orderBy('start_price', 'asc')->get();
            $applied = false;

            foreach($incentives as $incentive){
                if($total >= $incentive->start_price && $total <= $incentive->end_price){

                    if($data->promocode_type == 1){
                        $disprice = $incentive->incentive_price;
                    } else {
                        $disprice = round(($total/100)*$incentive->incentive_price,3);
                    }

                    $totamount = round($total - $disprice,3);

                    $msg = ($data->promocode_type == 1)
                          ? '₹ '.$disprice.' discount applied'
                          : $incentive->incentive_price.'% discount applied';

                    $status = "success";
                    session()->put('promocode', $data->promocode);
                    $applied = true;
                    break;
                }
            }

            if(!$applied){
                return response()->json(['status' => 'error','msg' => 'Product price not eligible for this promocode','dis' => 0,'discount' => 0,'total' => $totamount,'symbol' => $symbol
                ]);
            }
        }

    } else {
        return response()->json([
            'status' => 'error',
            'msg' => 'Promocode Null',
            'dis' => 0,
            'discount' => 0,
            'total' => $totamount,
            'symbol' => $symbol
        ]);
    }

    return response()->json([
        'status' => $status,
        'msg' => $msg,
        'dis' => $dis,
        'discount' => $disprice,
        'total' => $totamount,
        'symbol' => $symbol
    ]);
}




    
    
    
// public function applypromocode(Request $request){

//   $addressid = $request->addressid;
 
//     $totamount = $request->total;
  
//     $disprice = 0;
//     $dis = 0;
//     $now = Carbon::now('Asia/Kolkata');

//     $website = Websitesetting::where('id','1')->first();
//     $msg = "";
//     $status = "error";
//     $symbol = '%';

//     if(!empty($request->promocode)){
//         $pcode = $request->promocode;
//         $total = $request->total;
//         $user_id = session('user_id'); 
//         $today = $now->format('Y-m-d');

//         $data = Promocode::where('promocode', $pcode)->first();

//         if($data){

//             // 1. CASH payment not allowed
//             if($data->promocode_status == 1){
//                 $msg = "This promocode is not valid for Cash Payment";
//                 $status = "error";
//                 session()->put('promocode', "");
//             } 
//             else {
//                 // 2. Check date validity
//                 $startDate = date('Y-m-d', strtotime($data->startdate));
//                 $endDate   = date('Y-m-d', strtotime($data->enddate));
//                 if($startDate > $today || $endDate < $today){
//                     $msg = "Promocode Expired";
//                     $status = 'error';
//                     session()->put('promocode', "");
//                 } 
//                 // 3. Check use_range
//                 else if($data->use_range <= 0){
//                     $msg = "Promocode usage limit exceeded";
//                     $status = 'error';
//                     session()->put('promocode', "");
//                 } 
//                 // 4. Check user_range
//                 else {
//                     $userUsedCount = 2;
//                     // $userUsedCount = DB::table('promocode_user_usage')->where('promocode_id', $data->id)->where('user_id', $user_id)->count();

//                     if($data->user_range > 0 && $userUsedCount >= $data->user_range){
//                     // if($data->user_range > 0 && $userUsedCount >= $data->user_range){
//                         $msg = "You have already used this promocode maximum allowed times";
//                         $status = 'error';
//                         session()->put('promocode', "");
//                     } 
//                     else {
//                         // 5. Apply discount
//                         $symbol = ($data->promocode_type == 1) ? '₹' : '%';

//                         if($data->incentive_status == 0){
//                             if($data->promocode_type == 1){
//                                 $disprice  = $data->pricr_per;
//                                 $totamount = $total - $disprice;
//                                 $msg = '₹ '.$disprice.' discount applied';
//                             } else {
//                                 $disprice  = round(($total/100)*$data->pricr_per, 3);
//                                 $totamount = round($total - $disprice, 3);
//                                 $msg = $data->pricr_per.'% discount applied';
//                             }
//                             $status = "success";
//                             session()->put('promocode', $data->promocode);
//                         } 
//                         else if($data->incentive_status == 1){
//                             $incentives = PromocodeIncentive::where('promocode_id', $data->id)->orderBy('start_price', 'asc')->get();

//                             $applied = false;
//                             foreach($incentives as $incentive){
//                                 if($total >= $incentive->start_price && $total <= $incentive->end_price){
//                                     if($data->promocode_type == 1){
//                                         $disprice = $incentive->incentive_price;
//                                     } else {
//                                         $disprice = round(($total/100)*$incentive->incentive_price,3);
//                                     }
//                                     $totamount = round($total - $disprice,3);
//                                     $msg = ($data->promocode_type == 1)
//                                           ? '₹ '.$disprice.' discount applied'
//                                           : $incentive->incentive_price.'% discount applied';
//                                     $status = "success";
//                                     session()->put('promocode', $data->promocode);
//                                     $applied = true;
//                                     break;
//                                 }
//                             }

//                             if(!$applied){
//                                 $msg = "Product price not eligible for this promocode";
//                                 $disprice = 0;
//                                 $totamount = $total;
//                                 $status = "error";
//                                 session()->put('promocode', "");
//                             }
//                         }
//                     }
//                 }
//             }

//         } else {
//             $msg = "Promocode not available";
//             $status = 'error';
//             session()->put('promocode', "");
//         }

//     } else {
//         $msg = "Promocode Null";
//         $status = 'error';
//         session()->put('promocode', "");
//     }

//     return response()->json([
//         'status' => $status,
//         'msg' => $msg,
//         'dis' => $dis,
//         'discount' => $disprice,
//         'total' => $totamount,
//         'symbol' => $symbol
//     ]);
// }


 
    
    
    
    
public function ajaxchangeuser(Request $request)
{
    $userId = $request->user_id;
    $userdata = User::where('id', $userId)->first();

    if($userdata){
        return response()->json([
            'status' => 'success',
            'user' => [
                'name' => $userdata->name,
                'phonecode' => $userdata->phonecode,
                'phone_number' => $userdata->phone_number
            ]
        ]);
    } else {
        return response()->json([
            'status' => 'error',
            'message' => 'User not found'
        ]);
    }
}



// public function ajaxdeliverhere(Request $request)
// {
//     $addressId = $request->address_id;
//     $address = MyAddress::where('id', $addressId)->first();
//     if(!$address){
//         return response()->json(['status'=>'error','message'=>'Address not found']);
//     }

//     $selectedCityId = $address->city;
//     $selectedStateId = $address->state;

//     $websiteSettings = Websitesetting::where('id','1')->first();
//     $websiteStateId = $websiteSettings->state ?? null;

//     $cartItems = tbl_cart::where('user_id', session('user_id'))->get();
//     $mismatchProducts = [];
    
//     $igstValues = []; 
//     $addedServiceIds = []; 

//     foreach($cartItems as $cart){
//         $productTitle = '';
//         $encryptedId = Crypt::encrypt($cart->id);
//         $serviceId = null;
//         $igstRate = 0;

//         if($selectedStateId == $websiteStateId){
//             if($cart->type == 4){ 
//                 $plan = ServicePlan::find($cart->plan_product_id);
//                 $productTitle = $plan->title ?? 'No Name';

//                 if($plan){
//                     $serviceId = $plan->service_id;
//                     $service = Service::where('id', $serviceId)->first();
//                     $igstRate = $service->igst ?? 0;
//                 }

//             } elseif($cart->type == 5){ // Product
//                 $product = Tbl_Product::where('id', $cart->plan_product_id)
//                                       ->where('status','1')
//                                       ->where('quantity','<>','0')
//                                       ->first();
//                 $productTitle = $product->product_item ?? 'No Name';

//                 if($product){
//                     $serviceId = $product->service_id;
//                     $service = Service::where('id', $serviceId)->first();
//                     $igstRate = $service->igst ?? 0;
//                 }
//             }

//             // Add IGST once per service_id
//             if($serviceId && !in_array($serviceId, $addedServiceIds)){
//                 $igstValues[$serviceId] = $igstRate;
//                 $addedServiceIds[] = $serviceId;
//             }
//         }

//         // City mismatch check
//         $productCity = $cart->city_id ?? $cart->cityid ?? '';
//         if($productCity != $selectedCityId){
//             $mismatchProducts[] = [
//                 'id' => $encryptedId,
//                 'name' => $productTitle,
//                 'city' => $productCity
//             ];
//         }
//     }

//     return response()->json([
//         'status' => 'success',
//         'mismatchProducts' => $mismatchProducts,
//         'igstValues' => $igstValues, // pass to frontend
//     ]);
// }


   public function ajaxdeliverhere(Request $request)
{
    $addressId = $request->address_id;
    $address = MyAddress::where('id', $addressId)->first();

    if(!$address){
        return response()->json([
            'status' => 'error',
            'message' => 'Address not found'
        ]);
    }

    $selectedCityId  = $address->city;
    $selectedStateId = $address->state;

    $websiteSettings = Websitesetting::where('id','1')->first();
    $websiteStateId  = $websiteSettings->state ?? null;

    $cartItems = tbl_cart::where('user_id', session('user_id'))->get();

    $mismatchProducts = [];
    $igstValues = [];
    $addedServiceIds = [];

    foreach($cartItems as $cart){

        $productTitle = 'No Name';
        $encryptedId  = Crypt::encrypt($cart->id);
        $serviceId    = null;
        $igstRate     = 0;

        /* -------------------------
           PRODUCT / PLAN NAME
        --------------------------*/
        if($cart->type == 4){ // Service Plan
            $plan = ServicePlan::find($cart->plan_product_id);
            if($plan){
                $productTitle = $plan->title;
                $serviceId = $plan->service_id;
            }
        }
        elseif($cart->type == 5){ // Product
            $product = Tbl_Product::where('id', $cart->plan_product_id)
                                  ->where('status','1')
                                  ->where('quantity','<>','0')
                                  ->first();
            if($product){
                $productTitle = $product->product_item;
                $serviceId = $product->service_id;
            }
        }

        /* -------------------------
           IGST ONLY IF STATE SAME
        --------------------------*/
        if($selectedStateId == $websiteStateId && $serviceId){
            if(!in_array($serviceId, $addedServiceIds)){
                $service = Service::where('id', $serviceId)->first();
                $igstRate = $service->igst ?? 0;

                $igstValues[$serviceId] = $igstRate;
                $addedServiceIds[] = $serviceId;
            }
        }

        /* -------------------------
           CITY MISMATCH CHECK
        --------------------------*/
        $productCity = $cart->city_id ?? $cart->cityid ?? '';

        if($productCity != $selectedCityId){
            $mismatchProducts[] = [
                'id'   => $encryptedId,
                'name' => $productTitle,
                'city' => $productCity
            ];
        }
    }

    return response()->json([
        'status' => 'success',
        'mismatchProducts' => $mismatchProducts,
        'igstValues' => $igstValues,
    ]);
}
 
    
}
