<?php

namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\tbl_cart;
use App\Models\Testimonial;
use App\Models\Tbl_Product;
use App\Models\Websitesetting;
use App\Models\Serviceallottedcity;
use App\Models\ServicePlan;
use Carbon\Carbon;
use DB;
use Crypt;
class CartController extends Controller
{
    //
public function addtocart(Request $request)
{
    $plan_id = $request->plan_id;
    $quantity = $request->quantity ?? 1;
    $user_id = session('user_id') ?? null;

    // ---- Plan Check ----
    $plan = Serviceallottedcity::leftJoin('service_plans', 'service_plans.id', '=', 'serviceallottedcities.serviceid')
        ->where('serviceallottedcities.serviceid', $plan_id)
        ->where('serviceallottedcities.status', '1')
        ->where('serviceallottedcities.service_type', '4')
        ->first([
            'serviceallottedcities.*',
            'service_plans.service_id',
            'service_plans.subservice_id',
        ]);

    if ($plan) {
        $type = $plan->service_type;
        $price = $plan->price ?? null;
        $service_id = $plan->service_id;
        $subservice_id = $plan->subservice_id;
        $plan_product_id = $plan->serviceid;
        $city_id = $plan->city_id;
    } else {
        // ---- Product Check ----
        $product = Serviceallottedcity::leftJoin('tbl__products', 'tbl__products.id', '=', 'serviceallottedcities.serviceid')
            ->where('serviceallottedcities.serviceid', $plan_id)
            ->where('serviceallottedcities.status', '1')
            ->where('serviceallottedcities.service_type', '5')
            ->first([
                'serviceallottedcities.*',
                'tbl__products.service_id',
                'tbl__products.subservice_id',
            ]);

        if (!$product) {
            return response()->json([
                'error' => '0',
                'successmsg' => 'Plan/Product not found',
                'items' => cartitemcount()
            ]);
        }

        $type = $product->service_type;
        $price = $product->price ?? null;
        $service_id = $product->service_id;
        $subservice_id = $product->subservice_id;
        $plan_product_id = $product->serviceid;
        $city_id = $product->city_id;
    }

    // ---- Logged In User ----
    if ($user_id) {
        $cartdata = tbl_cart::where('user_id', $user_id)
            ->where('plan_product_id', $plan_product_id)
            ->first();

        if ($cartdata) {
            return response()->json([
                'error' => '0',
                'successmsg' => 'Product Already Exist',
                'items' => cartitemcount()
            ]);
        }

        $cart = new tbl_cart;
        $cart->plan_product_id = $plan_product_id;
        $cart->user_id = $user_id;
        $cart->service_id = $service_id;
        $cart->subservice_id = $subservice_id;
        $cart->city_id = $city_id;
        $cart->type = $type;
        $cart->price = $price;
        $cart->quantity = $quantity;
        $cart->ip = $_SERVER['REMOTE_ADDR'];
        $cart->strtotime = Carbon::now()->timestamp;
        $cart->save();

        return response()->json([
            'success' => '1',
            'successmsg' => 'Successfully Added To Cart',
            'items' => cartitemcount()
        ]);
    } 
    // ---- Guest User ----
    else {
        $time = time() + 365*24*60*60;
        $saved_cart_items = !empty($_COOKIE['cart_items'])
            ? json_decode(stripslashes($_COOKIE['cart_items']), true)
            : [];

        if (array_key_exists($plan_product_id, $saved_cart_items)) {
            return response()->json([
                'error' => '0',
                'successmsg' => 'Product Already Exist',
                'items' => cartitemcount()
            ]);
        }

        $saved_cart_items[$plan_product_id] = [
            'type' => $type,
            'plan_product_id' => $plan_product_id,
            'quantity' => $quantity,
            'cityid' => $city_id
        ];

        setcookie('cart_items', json_encode($saved_cart_items), $time, '/');
 return $itemcount = cartitemcount()+1;
        return response()->json([
            'success' => '1',
            'successmsg' => 'Successfully Added To Cart',
            'items' => $itemcount
        ]);
    }
}



public function cartmodel()
{
    $html = "";
    $totalAmount = 0; // total calculation
    $web = Websitesetting::where('id', '1')->first();

    if (!empty(session('user_id'))) {
         $cartItems = tbl_cart::where('user_id', session('user_id'))->get();

        foreach ($cartItems as $cart) {
         
            $alloted = Serviceallottedcity::where('serviceid', $cart->plan_product_id)->where('city_id', $cart->city_id)->where('service_type', $cart->type)->first();

            if ($cart->type == 4 && $alloted) {
                $plan = ServicePlan::find($cart->plan_product_id);
                if ($plan) {
                    $totalPrice = ($alloted->price ?? 0) * $cart->quantity;
                    $totalAmount += $totalPrice;

                    $html .= '
                    <div class="cart-item d-flex align-items-start" style="background:#fff;">
                        <div class="cart-box">
                            <a href="' . asset('productdetails/' . $plan->slug) . '">
                                <img src="' . asset('uploads/serviceplan/'. $plan->image) . '" 
                                     alt="' . $plan->title . '" class="img-fluid rounded"
                                     style="width:90px;padding:3px;height:65px;border-radius:8px;object-fit:cover;">
                            </a>
                        </div>
                        <div class="ms-3 flex-grow-1">
                            <h6 class="mb-1" style="font-weight:400;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;overflow:hidden;text-overflow:ellipsis;text-align:start;font-size:13px;line-height:18px;">
                                ' . $plan->title . '
                            </h6>
                            <span class="text-muted small d-flex">₹' . $alloted->price . ' × ' . $cart->quantity . ' = ₹' . $totalPrice . '</span>
                        </div>
                        <div>
                            <a href="' . asset('cartdelete/' . Crypt::encrypt($cart->id)) . '" 
                               onclick="return check_delete();" class="delete-btn" title="Delete">
                               <i class="fa-solid fa-xmark"></i>
                            </a>
                        </div>
                    </div>';
                }
            } else {
                $product = Tbl_Product::where('id', $cart->plan_product_id)
                            ->where('status', '1')->where('quantity','<>','0')->first();
                if ($product && $alloted) {
                    $totalPrice = ($alloted->price ?? 0) * $cart->quantity;
                    $totalAmount += $totalPrice;

                    $html .= '
                    <div class="cart-item d-flex align-items-start" style="background:#fff;">
                        <div class="cart-box">
                            <a href="' . asset('productdetails/' . $product->slug) . '">
                                <img src="' . asset('uploads/product/'. $product->image) . '" 
                                     alt="' . $product->product_item . '" class="img-fluid rounded"
                                     style="width:90px;padding:3px;height:65px;border-radius:8px;object-fit:cover;">
                            </a>
                        </div>
                        <div class="ms-3 flex-grow-1">
                            <h6 class="mb-1" style="font-weight:400;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;overflow:hidden;text-overflow:ellipsis;text-align:start;font-size:13px;line-height:18px;">
                                <a href="' . asset('productdetails/' . $product->slug) . '" style="text-decoration:none;color:inherit;">
                                ' . $product->product_item . '</a>
                            </h6>
                            <span class="text-muted small d-flex">₹' . $alloted->price . ' × ' . $cart->quantity . ' = ₹' . $totalPrice . '</span>
                        </div>
                        <div>
                            <a href="' . asset('cartdelete/' . Crypt::encrypt($cart->id)) . '" 
                               onclick="return check_delete();" class="delete-btn" title="Delete">
                               <i class="fa-solid fa-xmark"></i>
                            </a>
                        </div>
                    </div>';
                }
            }
        }
    } else {
        $cartItems = json_decode($_COOKIE['cart_items'] ?? '[]', true);
        foreach ($cartItems as $index => $cart) {
            $alloted = Serviceallottedcity::where('serviceid', $cart['plan_product_id'])
                        ->where('city_id', $cart['cityid'])
                        ->where('service_type', $cart['type'])
                        ->first();

            if ($cart['type'] == 4 && $alloted) {
                $plan = ServicePlan::find($cart['plan_product_id']);
                if ($plan) {
                    $totalPrice = ($alloted->price ?? 0) * $cart['quantity'];
                    $totalAmount += $totalPrice;

                    $html .= '
                    <div class="cart-item d-flex align-items-start" style="background:#fff;">
                        <div class="cart-box">
                            <a href="' . asset('productdetails/' . $plan->slug) . '">
                                <img src="' . asset('uploads/serviceplan/'. $plan->image) . '" alt="' . $plan->title . '" 
                                     class="img-fluid rounded" style="width:90px;padding:3px;height:65px;border-radius:8px;object-fit:cover;">
                            </a>
                        </div>
                        <div class="ms-3 flex-grow-1">
                            <h6 class="mb-1" style="font-weight:400;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;overflow:hidden;text-overflow:ellipsis;text-align:start;font-size:13px;line-height:18px;">
                                ' . $plan->title . '
                            </h6>
                            <span class="text-muted small d-flex">₹' . $alloted->price . ' × ' . $cart['quantity'] . ' = ₹' . $totalPrice . '</span>
                        </div>
                        <div>
                            <a href="' . asset('cartdelete/' . Crypt::encrypt($index)) . '" onclick="return check_delete();" class="delete-btn" title="Delete">
                               <i class="fa-solid fa-xmark"></i>
                            </a>
                        </div>
                    </div>';
                }
            } elseif ($cart['type'] == 5 && $alloted) {
                $product = Tbl_Product::where('id', $cart['plan_product_id'])->where('status','1')->where('quantity','<>','0')->first();
                if ($product) {
                    $totalPrice = ($alloted->price ?? 0) * $cart['quantity'];
                    $totalAmount += $totalPrice;

                    $html .= '
                    <div class="cart-item d-flex align-items-start" style="background:#fff;">
                        <div class="cart-box">
                            <a href="' . asset('productdetails/' . $product->slug) . '">
                                <img src="' . asset('uploads/product/' . $product->image) . '" alt="' . $product->product_item . '" class="img-fluid rounded" style="width:90px;padding:3px;height:65px;border-radius:8px;object-fit:cover;">
                            </a>
                        </div>
                        <div class="ms-3 flex-grow-1">
                            <h6 class="mb-1" style="font-weight:400;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;overflow:hidden;text-overflow:ellipsis;text-align:start;font-size:13px;line-height:18px;">
                                <a href="' . asset('productdetails/' . $product->slug) . '" style="text-decoration:none;color:inherit;">
                                ' . $product->product_item . '</a>
                            </h6>
                            <span class="text-muted small d-flex">₹' . $alloted->price . ' × ' . $cart['quantity'] . ' = ₹' . $totalPrice . '</span>
                        </div>
                        <div>
                            <a href="' . asset('cartdelete/' . Crypt::encrypt($index)) . '" onclick="return check_delete();" class="delete-btn" title="Delete">
                               <i class="fa-solid fa-xmark"></i>
                            </a>
                        </div>
                    </div>';
                }
            }
        }
    }

    $html .= '
    <style>
        .delete-btn { color: #dc3545; background: #ffe5e5; border-radius: 50%; width:32px; height:32px; display:flex; align-items:center; justify-content:center; transition: all 0.3s ease; }
        .delete-btn:hover { background:#dc3545; color:#fff; }
    </style>';

    return response()->json([
        'html' => $html,
        'total' => "₹" . number_format($totalAmount, 2)
    ]);
}



public function cartdelete($id)
{
    $cartItemId = Crypt::decrypt($id);

    if (!empty(session('user_id'))) {
        tbl_cart::where('id', $cartItemId)->delete();

    } else {
        
       $time = time() + (365 * 24 * 60 * 60);

        if (isset($_COOKIE['cart_items']) && !empty($_COOKIE['cart_items'])) {
            $saved_cart_items = json_decode($_COOKIE['cart_items'] ?? '[]', true);

            if (is_array($saved_cart_items) && isset($saved_cart_items[$cartItemId])) {
                unset($saved_cart_items[$cartItemId]);
                setcookie("cart_items", json_encode($saved_cart_items, true), $time, '/');
            }
        }
    }

    return redirect()->back()->with('success', 'Successfully deleted the cart product');
}

 function cart(){
        $data['settings'] = DB::table('additionalsettings')->where('id','1')->first();
    if (!empty(session('user_id'))) {
        $data['cart'] = tbl_cart::where('user_id', session('user_id'))->get();
    }else{
        $data['cartcookies'] = json_decode($_COOKIE['cart_items'] ?? '[]', true);
    }
        return view('frontend.cart.cart',$data);
  }

//quantityupdate//

// public function quantityupdate(Request $request)
// {
//     $qty = (int) $request->quantity;
//     $id  = $request->cart_id;

//     if (!empty(session('user_id'))) {
     
//         $cart = tbl_cart::where('id', $id)->first();
//         if ($cart) {
//             if ($qty > 0) {
           
//                 if ($cart->type == 4) {
//                     $plan = ServicePlan::find($cart->plan_product_id);
//                     if ($plan && $qty <= $plan->quantity) {
//                         $cart->quantity = $qty;
//                         $cart->save();
//                         return response()->json(['success' => 1, 'successmsg' => 'Product Quantity Updated']);
//                     } else {
//                         return response()->json(['error' => 0, 'successmsg' => 'Service Plan Quantity Not Available']);
//                     }
//                 } else {
//                     $product = Tbl_Product::find($cart->plan_product_id);
//                     if ($product && $qty <= $product->quantity) {
//                         $cart->quantity = $qty;
//                         $cart->save();
//                         return response()->json(['success' => 1, 'successmsg' => 'Product Quantity Updated']);
//                     } else {
//                         return response()->json(['error' => 0, 'successmsg' => 'Product Quantity Not Available']);
//                     }
//                 }
//             }
//         }
//         return response()->json(['error' => 0, 'successmsg' => 'Cart Item Not Found']);
//     } else {
//         // Guest user (cookie)
//         $time   = time() + 365 * 24 * 60 * 60;
//         $cookie = json_decode($_COOKIE['cart_items'] ?? '[]', true);

//         if (isset($cookie[$id])) {
//             $cart = $cookie[$id];
//             $newQty = $qty > 0 ? $qty : 1;

//             if ($cart['type'] == 4) {
//                 $plan = ServicePlan::find($cart['serviceid']);
//                 if ($plan && $newQty <= $plan->quantity) {
//                     $cookie[$id]['quantity'] = $newQty;
//                 } else {
//                     return response()->json(['error' => 0, 'successmsg' => 'Service Plan Quantity Not Available']);
//                 }
//             } else {
//                 $product = Tbl_Product::find($id);
//                 if ($product && $newQty <= $product->quantity) {
//                     $cookie[$id]['quantity'] = $newQty;
//                 } else {
//                     return response()->json(['error' => 0, 'successmsg' => 'Product Quantity Not Available']);
//                 }
//             }

          
//             setcookie('cart_items', json_encode($cookie, true), $time, '/');

//             return response()->json(['success' => 1, 'successmsg' => 'Product Quantity Updated']);
//         }

//         return response()->json(['error' => 0, 'successmsg' => 'Cart Item Not Found']);
//     }
// }


public function quantityupdate(Request $request)
{
    $qty = (int) $request->quantity;
    $id  = $request->cart_id;

    if (!empty(session('user_id'))) {
     
        $cart = tbl_cart::where('id', $id)->first();
        if ($cart) {
            if ($qty > 0) {

                $cart->quantity = $qty;
                $cart->save();

                return response()->json(['success' => 1, 'successmsg' => 'Product Quantity Updated']);
            }
        }

        return response()->json(['error' => 0, 'successmsg' => 'Cart Item Not Found']);

    } else {

        $time   = time() + 365 * 24 * 60 * 60;
        $cookie = json_decode($_COOKIE['cart_items'] ?? '[]', true);

        if (isset($cookie[$id])) {
            $newQty = $qty > 0 ? $qty : 1;
            $cookie[$id]['quantity'] = $newQty;
            setcookie('cart_items', json_encode($cookie, true), $time, '/');
            return response()->json(['success' => 1, 'successmsg' => 'Product Quantity Updated']);
        }

        return response()->json(['error' => 0, 'successmsg' => 'Cart Item Not Found']);
    }
}



    
}
