<?php

namespace App\Http\Controllers\backend\settings;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Websitesetting;
use App\Models\Service;
use App\Models\Additionalsetting;
use DB;
use Crypt;
use Session;
class SettingController extends Controller
{
    //
    
    
    function settings(){

    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }

    $user_id = session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '1', 'action_view');

    if ($hasPermission) { 
        return view('backend.settings.setting');
    }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);

    return redirect(asset('backend/permission_denied'))->with($messagepremission['status'], $messagepremission['message'])->send();
}

    function websitesetting(){
        $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '2', 'action_view');
     if ($hasPermission) { 
        $data['websitedata']=Websitesetting::where('id','1')->first();
        $data['service']=Service::where('status','1')->get();
         $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
         $data['state'] = DB::table('tbl_states')->where('s_status','1')->get();
         
        return view('backend.settings.websitesetting',$data);
     }
        $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }
    
    
    function websitesettingedit(Request $request){
        
        
           $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '2', 'action_edit');
     if ($hasPermission) { 
          $update =Websitesetting::where('id','1')->first();
           $before = json_encode($update);
          
        $update->site_title=$request->site_title;
        
         if ($request->fevicon) {
        $img = time() . 'fevicon.' . $request->fevicon->extension();
        $request->fevicon->move(public_path('uploads/websitesetting'), $img);
        $update->fevicon = $img;
          }
          
         if ($request->header_logo) {
        $img = time() . 'header_logo.' . $request->header_logo->extension();
        $request->header_logo->move(public_path('uploads/websitesetting'), $img);
        $update->header_logo = $img;
          }
          
         if ($request->footer_logo) {
        $img = time() . 'footer_logo.' . $request->footer_logo->extension();
        $request->footer_logo->move(public_path('uploads/websitesetting'), $img);
        $update->footer_logo = $img;
          }
           $update->whatsapp=$request->whatsapp;
           $update->mobile_number=$request->mobile_number;
           $update->login_otp_default_number=$request->login_otp_default_number??0;
           $update->login_otp_default_email=$request->login_otp_default_email??0;
           $update->otp_defalut_status=$request->otp_defalut_status;
           
           $serviceIds = $request->input('services', []);
           $serviceIds = array_map(function ($id) {
    return $id ?: 0;  
}, $serviceIds);
           $update->services = json_encode($serviceIds);
           
        $SubserviceIds = $request->input('home_services', []);   
$subserviceIds = $request->input('sub_services', []); 

$serviceMap = [];

foreach ($SubserviceIds as $index => $serviceId) {
    if ($serviceId) {
        $serviceMap[$serviceId] = $subserviceIds[$index] ?? null;
    }
}

$update->home_services = json_encode($serviceMap); 
          
           
           $update->otp_defalutemail_status=$request->otp_defalutemail_status;
           $update->login_with_opt_apply=$request->login_with_opt_apply??0;
           $update->email=$request->email;
           $update->adminloginattempt_time=$request->adminloginattempt_time;
           $update->allotted_countries=$request->allotted_countries;
           $update->state=$request->state;
           $update->address=$request->address;
           $update->web_url=$request->web_url;
           $update->footer_content=$request->footer_content;
           $update->facebook=$request->facebook;
           $update->linkedin=$request->linkedin;
           $update->instagram=$request->instagram;
           $update->twitter=$request->twitter;
           $update->youtube=$request->youtube;
           $update->file_size=$request->file_size;
           $update->user_multipal_attempt_status=$request->user_multipal_attempt_status ?? 0;
           $update->user_login_with_opt_apply=$request->user_login_with_opt_apply ?? 0;
           $update->created_by=$user_id;
           $update->panel_id='1';
           $update->copyright=$request->copyright;
           $update->meta_title=$request->meta_title;
           $update->meta_keyword=$request->meta_keyword;
           $update->meta_description=$request->meta_description;
           $update->video_link=$request->video_link;
           $update->map_link=$request->map_link;
           $update->admin_otp_attempt_count=$request->admin_otp_attempt_count;
           $update->multipal_attempt_status = $request->multipal_attempt_status ?? 0;

           $update->admin_login_ip_attempt_count=$request->admin_login_ip_attempt_count;
            $update->ip = CurrentTimestamp()['ip'];
    $update->strtotime = CurrentTimestamp()['strtotime'];
    $update->save();
     $after = json_encode($update);
    $adduser=$update->id;
     insertLogsAPI($user_id,'3','Website Setting Update','2','',$adduser,'','',$after,$before); 
    
    $message = fleshmessage(3,1,'Website Setting');
    return redirect()->back()->with($message['status'],$message['message']);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
       

    }
    
    
    function tbl_crud_features(){
     $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
        $data['feature']=  DB::table('tbl_crud_features')->get();
        return view('backend.settings.tbl_crud_features',$data);
    }
    
    
     function getsubserviceshome(Request $request)
{
    $response = [];

    // service -> subservices
    if ($request->has('service_id')) {
        $response['subservices'] = DB::table('subservices')->where('service_id', $request->service_id)->where('status', '1')->get(['id', 'title']);
    }

    return response()->json($response);
}

function additionalsetting(Request $request){
      $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
     $user_id = session('SUPERADMIN_ID');
     
     $hasPermission = permission($user_id, '28', 'action_view');
     if ($hasPermission) { 
           insertLogsAPI($user_id,'2','Additional Setting View','28','','','','','','',''); 
   
      $data['additionalsetting']= Additionalsetting::where('id','1')->first();
    return view('backend/settings/additional_setting',$data);
}
 $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
  
    }




public function additionalsettingupdate(Request $request) {

    $user_id = session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '28', 'action_edit');

    if ($hasPermission) {

        $id = Crypt::decrypt($request->id);
        $update = Additionalsetting::where('id',$id)->first();

        $before = json_encode($update);

        $update->port = $request->port;
        $update->email = $request->email;
        $update->password = $request->password;
        $update->captchasitekey = $request->captchasitekey;
        $update->captchasecretkey = $request->captchasecretkey;
        $update->google_client_id = $request->google_client_id;
        $update->google_client_secret = $request->google_client_secret;
        $update->google_redirect_url = $request->google_redirect_url;
        $update->google_api = $request->google_api;
        $update->latitude = $request->latitude;
        $update->longitude = $request->longitude;
        $update->host = $request->host;
        $update->smtpsecure = $request->smtpsecure;
        $update->smtpsecure_no = $request->smtpsecure_no;

        $update->panel_id = '1';
        $update->creat_by = $user_id;
        $update->user_id = $user_id;
        $update->ip = CurrentTimestamp()['ip'];
        $update->strtotime = CurrentTimestamp()['strtotime'];
        $update->created_at = CurrentTimestamp()['datetime'];
        $update->updated_at = CurrentTimestamp()['datetime'];
        $update->save();

        $after = json_encode($update);
        $adduser = $update->id;

        insertLogsAPI($user_id,'3','Additional Setting Update','28','',$adduser,'','',$after,$before,'');

        // ************ ENV UPDATE (ONLY MAIL SETTINGS) ************
        $Data = [
            'MAIL_HOST'       => $request->host,
            'MAIL_PORT'       => $request->port,
            'MAIL_USERNAME'   => $request->email,
            'MAIL_PASSWORD'   => $request->password,
            'MAIL_ENCRYPTION' => $request->smtpsecure,
        ];

        foreach ($Data as $key => $value) {
            $this->setEnv($key, $value);
        }

        \Artisan::call('config:clear');
        \Artisan::call('config:cache');

        $message = fleshmessage(3,1,'Additional Setting');
        return redirect()->back()->with($message['status'],$message['message']);
    }

    $website = Websitesetting::where('id','1')->first();
    $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);

    return redirect(asset('backend/permission_denied'))
            ->with($messagepremission['status'],$messagepremission['message'])
            ->send();
}



protected function setEnv($key, $value) {
    $path = base_path('.env');

    if (file_exists($path)) {

        $env = file_get_contents($path);

        if (strpos($env, $key.'=') !== false) {
            $env = preg_replace(
                "/^{$key}=.*/m",
                "{$key}={$value}",
                $env
            );
        } else {
            $env .= "\n{$key}={$value}";
        }

        file_put_contents($path, $env);
    }
}




public function locationsetting(Request $request)
{
    if ($request->type == 'api') {
        // Update selected API or reset
        DB::table('additionalsettings')->update(['location_api' => $request->value]);
    } 
    elseif ($request->type == 'func') {
        // Update selected Functionality or reset
        DB::table('additionalsettings')->update(['location_functlity' => $request->value]);
    }

    return response()->json([
        'status' => 'success',
        'message' => $request->value ? 'Setting activated successfully!' : 'Setting deactivated successfully!'
    ]);
}






}
