<?php

namespace App\Http\Controllers\backend\promocode;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\superadmin;
use App\Models\ChildService;
use App\Models\Serviceallottedcity;
use App\Models\Websitesetting;
use App\Models\PromocodeIncentive;
use App\Models\Service;
use App\Models\ServicePlan;
use App\Models\Subservice;
use App\Models\Promocode;
use App\Models\tbl_permission;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\File;
use Crypt;
use Session;
class PromocodeController extends Controller
{
    //
    
    
      function promocode(){
          
    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '22', 'action_view');
     if ($hasPermission) { 
           insertLogsAPI($user_id,'2','Promocode View','22','','','','','','',''); 
             $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
            
        

        return view('backend.promocode.promocode',$data);
     }
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
  
    }
  
  
  
  function promocodeedit(Request $request){
    $user_id = session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '22', 'action_edit');
        if ($hasPermission) { 
        $id=Crypt::decrypt($request->id);
        $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
        $data['services'] = Service::where('status', '1')->get();
        $data['promocode']=Promocode::where('id',$id)->first();
          $data['incentive'] = PromocodeIncentive::where('promocode_id', $id)->get();

        return view('backend.promocode.promocodeedit',$data);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
    ->with($messagepremission['status'], $messagepremission['message'])
    ->send();
    }
  
  
  
    
  
  
  
    
    
public function promocodestatebycity(Request $request)
{
    $states = [];
    $cities = [];
    $pincodes = [];
    $services = [];
    $subservices = [];
    $childservices = [];
    $plans = [];

 
    if ($request->has('country_id') && !$request->has('state_id') && !$request->has('city_id') && !$request->has('service_id') && !$request->has('subservice_id') && !$request->has('childservice_id')) {
        $states = DB::table('tbl_states')
            ->where('country_id', $request->country_id)
            ->where('s_status', '1')
            ->get(['state_id', 'name']);
    }

    if ($request->has('state_id') && !$request->has('city_id') && !$request->has('service_id') && !$request->has('subservice_id') && !$request->has('childservice_id')) {
        $cities = DB::table('tbl_cities')
            ->where('stateid', $request->state_id)
            ->where('city_status', '1')
            ->get(['city_id', 'name']);
    }

 
    if ($request->has('city_id') && !$request->has('service_id') && !$request->has('subservice_id') && !$request->has('childservice_id')) {
        $pincodes = DB::table('pincodes')
            ->where('city', $request->city_id)
            ->where('status', '1')
            ->get(['id', 'pincode']);

        $serviceIds = DB::table('serviceallottedcities')
            ->where('countries_id', $request->country_id)
            ->where('state_id', $request->state_id)
            ->where('city_id', $request->city_id)
            ->where('status','1')
            ->where('service_type', '1') 
            ->pluck('serviceid');

        $services = DB::table('services')
            ->whereIn('id', $serviceIds)
            ->where('status', '1')
            ->select('id', 'title')
            ->get();
    }

   
    if ($request->has('service_id') && !$request->has('subservice_id') && !$request->has('childservice_id')) {
        $subserviceIds = DB::table('subservices')
            ->where('service_id', $request->service_id)
            ->where('status', '1')
            ->pluck('id');

        $allowedSubserviceIds = DB::table('serviceallottedcities')
            ->where('countries_id', $request->country_id)
            ->where('state_id', $request->state_id)
            ->where('city_id', $request->city_id)
            ->where('status', '1')
            ->where('service_type', '2')
            ->whereIn('serviceid', $subserviceIds) 
            ->pluck('serviceid');

        $subservices = DB::table('subservices')
            ->whereIn('id', $allowedSubserviceIds)
            ->select('id', 'title')
            ->get();
    }

   
    if ($request->has('subservice_id')) {
        // childservices
        $childserviceIds = DB::table('child_services')
            ->where('subservice_id', $request->subservice_id)
            ->where('status', '1')
            ->pluck('id');

        $allowedChildIds = DB::table('serviceallottedcities')
            ->where('countries_id', $request->country_id)
            ->where('state_id', $request->state_id)
            ->where('city_id', $request->city_id)
            ->where('status', '1')
            ->where('service_type', '3')
            ->whereIn('serviceid', $childserviceIds)
            ->pluck('serviceid');

      
        $childservices = DB::table('child_services')
            ->whereIn('id', $allowedChildIds)
            ->select('id', 'title')
            ->get();

        // plans
        $planIds = DB::table('service_plans')
            ->where('subservice_id', $request->subservice_id)
            ->where('status', '1')
            ->pluck('id');

        $allowedPlanIds = DB::table('serviceallottedcities')
            ->where('countries_id', $request->country_id)
            ->where('state_id', $request->state_id)
            ->where('city_id', $request->city_id)
            ->where('status', '1')
            ->where('service_type', '4')
            ->whereIn('serviceid', $planIds)
            ->pluck('serviceid');

        $plans = DB::table('service_plans')
            ->whereIn('id', $allowedPlanIds)
            ->select('id', 'title')
            ->get();
    }

    return response()->json([
        'states'        => $states,
        'cities'        => $cities,
        'pincodes'      => $pincodes,
        'services'      => $services,
        'subservices'   => $subservices,
        'childservices' => $childservices,
        'plans'         => $plans
    ]);
}





public function promocodecreate(Request $request){
    $user_id = session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '22', 'action_add');

    if (!$hasPermission) {
        $website = Websitesetting::where('id', '1')->first();
        $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
        return redirect(asset('backend/permission_denied'))
            ->with($messagepremission['status'], $messagepremission['message'])
            ->send();
    }

    // Check duplicate promocode
    $existingMobile = Promocode::where('promocode', $request->promocode)->first();
    if ($existingMobile) {
        $message = fleshmessage(6, 1, 'Promocode');
        return redirect()->back()->with($message['status'], $message['message']);
    }

    // ---------- CREATE PROMOCODE ----------
    $create = new Promocode;
    $create->title = $request->title;
    $create->promocode_type = $request->promocode_type;
    $create->pricr_per = $request->pricr_per;
    $create->promocode = $request->promocode;
    $create->incentive_status = $request->incentive_status;
    $create->use_range = $request->use_range;
    $create->promocode_status = $request->promocode_status;
    $create->user_range = $request->user_range;
    $create->startdate = $request->startdate;
    $create->enddate = $request->enddate;
    $create->ordering_by = $request->ordering_by;
    $create->countries = $request->countries;
    $create->state = $request->state;
    $create->city = $request->city;
    $create->pincode = $request->pincode;
    $create->service_id = $request->service_id;
    $create->subservice_id = $request->subservice_id;
    $create->childservice_id = $request->childservice_id;
    $create->serviceplan_id = $request->serviceplan_id;
    $create->user_id = $user_id;
    $create->created_by = $user_id;
    $create->panel_id = '1';
    $create->tokan = reandum_code('50');
    $create->ip = CurrentTimestamp()['ip'];
    $create->strtotime = CurrentTimestamp()['strtotime'];
    $create->created_at = CurrentTimestamp()['datetime'];
    $create->updated_at = CurrentTimestamp()['datetime'];
    $create->save();

    // ---------- LOG PROMOCODE ----------
    $after = json_encode($create);
    $before = json_encode($create);
    $adduser = $create->id;
    insertLogsAPI($user_id, '1', 'Promocode Add', '22', '', $adduser, '', '', $after, $before, '');

    // ---------- INSERT ONLY INCENTIVE IF FILLED ----------
    $startPrices = $request->input('start_price', []);
    $endPrices = $request->input('end_price', []);
    $incentivePrices = $request->input('incentive_price', []);

    foreach ($startPrices as $index => $startPrice) {

        $endPrice = $endPrices[$index] ?? null;
        $incentivePrice = $incentivePrices[$index] ?? null;

        // Skip if any field is empty
        if ($startPrice === '' || $endPrice === '' || $incentivePrice === '') {
            continue;
        }

        $data = [
           'start_price'      => $startPrice??'',
            'end_price'        => $endPrice??'',
            'incentive_price'  => $incentivePrice ??'',
            'promocode_id'     => $create->id, // Link to newly created promocode
            'ip'               => CurrentTimestamp()['ip'],
            'strtotime'        => CurrentTimestamp()['strtotime'],
            'created_at'       => CurrentTimestamp()['datetime'],
            'updated_at'       => CurrentTimestamp()['datetime'],
            'user_id'          => $user_id,
            'created_by'       => $user_id,
            'panel_id'         => '1'
        ];

        $incentive = PromocodeIncentive::create($data);
        $after = json_encode($incentive);
        $before = json_encode($incentive);
        insertLogsAPI($user_id, '1', 'PromocodeIncentive Add', '22', '', $incentive->id, '', '', $after, $before, '');
    }

    $message = fleshmessage(2, 1, 'Promocode');
    return redirect()->back()->with($message['status'], $message['message']);
}









public function promocodeupdate(Request $request){
    $id = Crypt::decrypt($request->id);
    $user_id = session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '22', 'action_edit');

    if (!$hasPermission) {
        $website = Websitesetting::where('id', '1')->first();
        $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
        return redirect(asset('backend/permission_denied'))
            ->with($messagepremission['status'], $messagepremission['message'])
            ->send();
    }

    // Check duplicate promocode
    $existingMobile = Promocode::where('promocode', $request->promocode)->where('id', '!=', $id)->first();
    if ($existingMobile) {
        $message = fleshmessage(6, 1, 'Promocode');
        return redirect()->back()->with($message['status'], $message['message']);
    }

    // ---------- UPDATE PROMOCODE ----------
    $update = Promocode::findOrFail($id);
    $before = json_encode($update);

    $update->title = $request->title;
    $update->promocode_type = $request->promocode_type;
    $update->pricr_per = $request->pricr_per;
    $update->promocode = $request->promocode;
    $update->incentive_status = $request->incentive_status;
    $update->use_range = $request->use_range;
    $update->user_range = $request->user_range;
    $update->startdate = $request->startdate;
    $update->promocode_status = $request->promocode_status;
    $update->enddate = $request->enddate;
    $update->ordering_by = $request->ordering_by;
    $update->countries = $request->countries;
    $update->state = $request->state;
    $update->city = $request->city;
    $update->pincode = $request->pincode;
    $update->service_id = $request->service_id;
    $update->subservice_id = $request->subservice_id;
    $update->childservice_id = $request->childservice_id;
    $update->serviceplan_id = $request->serviceplan_id;
    $update->user_id = $user_id;
    $update->created_by = $user_id;
    $update->panel_id = '1';
    $update->ip = CurrentTimestamp()['ip'];
    $update->strtotime = CurrentTimestamp()['strtotime'];
    $update->created_at = CurrentTimestamp()['datetime'];
    $update->updated_at = CurrentTimestamp()['datetime'];

    $update->save();

    // ---------- LOG PROMOCODE UPDATE ----------
    $after = json_encode($update);
    $adduser = $update->id;
    insertLogsAPI($user_id, '3', 'Promocode Update', '22', '', $adduser, '', '', $after, $before, '');

    // ---------- INSERT / UPDATE INCENTIVE PRICES ----------
    $incentiveIds = $request->input('insentiveid', []);
    $startPrices = $request->input('start_price', []);
    $endPrices = $request->input('end_price', []);
    $incentivePrices = $request->input('incentive_price', []);

    foreach ($startPrices as $index => $startPrice) {
        $endPrice = $endPrices[$index] ?? null;
        $incentivePrice = $incentivePrices[$index] ?? null;
        $insentiveId = $incentiveIds[$index] ?? 0;

        // Skip if any required field is empty
        if ($startPrice === '' || $endPrice === '' || $incentivePrice === '') {
            continue;
        }

        $data = [
            'start_price'      => $startPrice??'',
            'end_price'        => $endPrice??'',
            'incentive_price'  => $incentivePrice ??'',
            'promocode_id'     => $update->id,
            'ip'               => CurrentTimestamp()['ip'],
            'strtotime'        => CurrentTimestamp()['strtotime'],
            'created_at'       => CurrentTimestamp()['datetime'],
            'updated_at'       => CurrentTimestamp()['datetime'],
            'user_id'          => $user_id,
            'created_by'       => $user_id,
            'panel_id'         => '1'
        ];

        if ($insentiveId && $insentiveId > 0) {
            // ---------- UPDATE EXISTING ----------
            $incentive = PromocodeIncentive::find($insentiveId);
            if ($incentive) {
                $beforeIncentive = json_encode($incentive);
                $incentive->update($data);
                $afterIncentive = json_encode($incentive);
                insertLogsAPI($user_id, '3', 'PromocodeIncentive Update', '22', '', $incentive->id, '', '', $afterIncentive, $beforeIncentive, '');
            }
        } else {
            // ---------- INSERT NEW ----------
            $incentive = PromocodeIncentive::create($data);
            $afterIncentive = json_encode($incentive);
            $beforeIncentive = json_encode($incentive);
            insertLogsAPI($user_id, '1', 'PromocodeIncentive Add', '22', '', $incentive->id, '', '', $afterIncentive, $beforeIncentive, '');
        }
    }

    $message = fleshmessage(3, 1, 'Promocode');
    return redirect(url('backend/promocode/promocode'))->with($message['status'], $message['message']);
}

  





function promocodeajax(Request $request){
    $draw   = $request->draw ?? 0;
    $rows   = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? null;
    $searchValue = $request->search['value'] ?? null;
    
    $user_id = session('SUPERADMIN_ID');
    if($user_id=='1'){
   

    $promocodedata = Promocode::promocodeajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length);
    $promocodecount = Promocode::promocodeajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length);
    }else{
    $promocodedata = Promocode::promocodeajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$user_id);
    $promocodecount = Promocode::promocodeajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$user_id);   
    }
     
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($promocodedata as $row) {
    $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  

    // Edit Button
    $action .= '<li class="list-unstyled" style="margin: 0;"> ';
    if(permission($user_id,'22','action_edit')){
                 $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/promocodeedit/' . Crypt::encrypt($row->id)) . '">
                        <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                    </a>';
                    }
  
              $action .= '   </li>';

    $action .= '<li class="list-unstyled">';
      if(permission($user_id,'22','action_delete')){
    $action .= '<a href="' . route('backend.promocodedelete', Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                        <i class="fadeIn animated bx bx-trash anji me-0"></i>
                    </a>';
      }
    $action .= '</li>';
    

    $action .= '</ul>';

    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
    $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
        onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
        <label class="flip-label" for="flip' . $row->id . '"></label>
    </div>';

   
     $data[] = array(
    "id" => $row->id, 
    "ordering_by" => $row->ordering_by,
    "promocode" => $row->promocode,
    "promocode_type" => $row->promocode_type,
    "use_range" => $row->use_range,
    "startdate" => $row->startdate,
    "enddate" => $row->enddate,
    "status" => $status,
    "action" => $action
    );

    }
    
    $canViewGlobal = permission($user_id, '22', 'action_globle_view');
    $canAccessCity = permission($user_id, '22', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;


    if ($user_id == '1') {
        $query = DB::table('promocodes')->orderBy('ordering_by', 'ASC');

    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('promocodes')->orderBy('ordering_by', 'ASC');

    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('promocodes')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');

    } else {
        $query = DB::table('promocodes')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
    }

    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $promocodecount,
    "data" => $data
    );
    
    echo json_encode($datas);
}





public function promocodestatus(Request $request) {
    $id = $request->id;
    $statusstatus = Promocode::find($id);
    if (!$statusstatus) {
        return response()->json(['success' => false, 'message' => 'product not found'], 404);
    }

    $statusstatus->status = $request->status;
    $statusstatus->save();
    return response()->json(['success' => true]);
} 





    
    
    
    public function incentivedelete(Request $request, $id)
{
     $user_id = session('SUPERADMIN_ID');
    $id = Crypt::decrypt($id);
  
        $delete = PromocodeIncentive::findOrFail($id);
        $after = json_encode($delete);
        $before = json_encode($delete);
        $adduser = $delete->id;
        $delete->delete();
        insertLogsAPI($user_id, '4', 'PromocodeIncentive Delete', '22', '', $adduser, '', '', $after, $before, '');
        $message = fleshmessage(4, 1, 'Promocode Incentive');
        return redirect()->back()->with($message['status'], $message['message']);
    }
   
    
}
