<?php

namespace App\Http\Controllers\backend\product;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\superadmin;

use App\Models\ChildService;
use App\Models\Serviceallottedcity;
use App\Models\Brand;
use App\Models\Service;
use App\Models\Tbl_Product;
use App\Models\Websitesetting;
use App\Models\Subservice;
use App\Models\tbl_permission;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\File;
use Crypt;
use Session;

class ProductController extends Controller
{
    function product(){
    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
     $data['validateslug'] = array('editid'=> '','slugtype' => '1', 'fid'=>'16');
     $data['servicescount'] = Service::count();
     $data['productcount'] = Tbl_Product::count();
     $data['activeservice'] = Service::where('status', '1')->count();
     $data['activeproduct'] = Tbl_Product::where('status', '1')->count();
     $data['inactiveproduct'] = Tbl_Product::where('status', '0')->count();

     $data['services'] = Service::where('status', '1')->get();
     $data['subservices'] = Subservice::where('status', '1')->get();
     $data['brand'] = Brand::where('status', '1')->get();
     $hasPermission = permission($user_id, '16', 'action_view');
     if ($hasPermission) { 
           insertLogsAPI($user_id,'2','Product View','16','','','','','','',''); 
        return view('backend.product.product' , $data);
     }
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }
    
    
 function productedit(Request $request){
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '16', 'action_edit');
        if ($hasPermission) { 
        $id=Crypt::decrypt($request->id);
        $data['validateslug'] = array('editid'=> Crypt::decrypt($request->id),'slugtype' => '2', 'fid'=>'16');
        $data['services'] = Service::where('status', '1')->get();
        $data['product']=Tbl_Product::where('id',$id)->first();
        return view('backend.product.productedit',$data);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }
    
    

    function productcreate(Request $request){
        $user_id=session('SUPERADMIN_ID');
     $existingMobile = Tbl_Product::where('slug', $request->slug)->first();
     $hasPermission = permission($user_id, '16', 'action_add');
    if ($hasPermission) { 
    if ($existingMobile) {
         $message = fleshmessage(6,1,'Slug');
        return redirect()->back()->with($message['status'],$message['message']);
    }

        $create=new Tbl_Product;
        $create->service_id = $request->service_id;
        $create->subservice_id = $request->subservice_id;
        $create->brand_id = $request->brand_id;
        $create->product_item = $request->product_item;
        $create->user_id = $user_id;
        $create->slug = $request->slug;
        $create->img_description=$request->img_description;
        $create->meta_title = $request->meta_title;
        $create->meta_keyword = $request->meta_keyword;
        $create->default_price = $request->default_price;
        $create->mrp_price = $request->mrp_price;
        $create->ordering_by = $request->ordering_by;
        $create->meta_description = $request->meta_description;
        $create->description = $request->description;

        if ($request->image) {
        $img = time() . 'image.' . $request->image->extension();
        $request->image->move(public_path('uploads/product'), $img);
        $create->image = $img;
        }
        if ($request->hasFile('multiple_image')) {
        foreach ($request->file('multiple_image') as $file) {
        $img = time() . '_' . uniqid() . '.' . $file->extension();
        $file->move(public_path('uploads/product'), $img);
        $images[] = $img;
        }
        
        $create->multiple_image = json_encode($images);
        }
        $create->created_by=$user_id;
        $create->panel_id='1';
        $create->tokan=reandum_code('50');
        $create->ip = CurrentTimestamp()['ip'];
        $create->strtotime = CurrentTimestamp()['strtotime'];
        $create->created_at = CurrentTimestamp()['datetime'];
        $create->updated_at = CurrentTimestamp()['datetime'];
        $create->save();
        $after = json_encode($create);
        $before = json_encode($create);
        $adduser=$create->id;
    insertLogsAPI($user_id,'1','Product Add','16','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(2,1,'Product');
    return redirect()->back()->with($message['status'],$message['message']);
    }
         $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }   
    
    
    function productupdate(Request $request){
    $id = Crypt::decrypt($request->id);
    $user_id = session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '16', 'action_edit');
    if ($hasPermission) { 
    $existingMobile = Tbl_Product::where('slug', $request->slug)->where('id', '!=', $id)->first();
    if ($existingMobile) {
        $message = fleshmessage(6,1,'Slug');
        return redirect()->back()->with($message['status'],$message['message']);
    }
   
    $update = Tbl_Product::findOrFail($id);
    $before = json_encode($update);
        $update->service_id = $request->service_id;
        $update->subservice_id = $request->subservice_id;
        $update->brand_id = $request->brand_id;
        $update->product_item = $request->product_item;
        $update->user_id = $user_id;
        $update->slug = $request->slug;
        $update->img_description=$request->img_description;
        $update->meta_title = $request->meta_title;
        $update->meta_keyword = $request->meta_keyword;
        $update->default_price = $request->default_price;
        $update->mrp_price = $request->mrp_price;
        $update->ordering_by = $request->ordering_by;
        $update->meta_description = $request->meta_description;;
        $update->description = $request->description;

        if ($request->hasFile('image')) {
        if ($update->image && file_exists(public_path('uploads/product/' . $update->image))) {
            unlink(public_path('uploads/product/' . $update->image));
        }

        $imgName = time() . 'image.' . $request->image->extension();
        $request->image->move(public_path('uploads/product'), $imgName);
        $update->image = $imgName;
        }
        
     if ($request->hasFile('multiple_image')) {

    if ($update->multiple_image) {
        $oldImages = json_decode($update->multiple_image, true); // JSON format
        if (is_array($oldImages)) {
            foreach ($oldImages as $oldImg) {
                $oldPath = public_path('uploads/product/' . $oldImg);
                if (file_exists($oldPath)) {
                    unlink($oldPath);
                }
            }
        }
    }

    $images = [];
    foreach ($request->file('multiple_image') as $file) {
        $imgName = time() . '_' . uniqid() . '.' . $file->getClientOriginalExtension();
        $file->move(public_path('uploads/product'), $imgName);
        $images[] = $imgName;
    }


    $update->multiple_image = json_encode($images);
}
        $update->created_by=$user_id;
        $update->panel_id='1';
        $update->ip = CurrentTimestamp()['ip'];
        $update->strtotime = CurrentTimestamp()['strtotime'];
        $update->created_at = CurrentTimestamp()['datetime'];
        $update->updated_at = CurrentTimestamp()['datetime'];

    $update->save();
      $after = json_encode($update);
       $adduser=$update->id;
    insertLogsAPI($user_id,'3','Product Update','16','',$adduser,'','',$after,$before,''); 

    $message = fleshmessage(3,1,'Product');
    return redirect(url('backend/product/product'))->with($message['status'],$message['message']);
    }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }    




      function productajax(Request $request){
       
       $filterData = [
        'filterservice_id' => $request->filterservice_id,
        'filtersubservice_id'   => $request->filtersubservice_id,
        'filterbrand_id'   => $request->filterbrand_id,
        'status'   => $request->status,
    ];
    
   $draw   = $request->draw ?? 0;
    $rows   = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? null;
    $searchValue = $request->search['value'] ?? null;
    
   $user_id = session('SUPERADMIN_ID');
    if($user_id=='1'){
   

    $productdata = Tbl_Product::productajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$filterData,$length);
    $productcount = Tbl_Product::productajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$filterData,$length);
    }else{
       $productdata = Tbl_Product::productajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$filterData,$user_id);
    $productcount = Tbl_Product::productajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length, $filterData,$user_id);   
    }
     
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($productdata as $row) {
   $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  

    // Edit Button
    $action .= '<li class="list-unstyled" style="margin: 0;"> ';
   if(permission($user_id,'16','action_edit')){
                 $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/productedit/' . Crypt::encrypt($row->id)) . '">
                        <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                    </a>';
                    }
  
              $action .= '   </li>'; 
              
        $action .= '<li class="list-unstyled ms-1" style="margin: 0;"> ';
        if(permission($user_id,'16','action_edit')){
            $action .= '   <a class="btn actionedit viewbtn btn-sm " href="' . asset('backend/productsingleview/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-show anji me-0"></i>
                </a>';
        }
        $action .= '   </li>';

  $action .= '   </li>';
        $action .= '<li class="list-unstyled ms-1" style="margin: 0;"> ';
        if(permission($user_id,'16','action_edit')){
            $action .= '   <a class="btn  planbtn btn-sm " href="' . asset('backend/productallottedcity/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-dollar anji me-0"></i>
                </a>';
        }
        $action .= '   </li>';
   

    $action .= '<li class="list-unstyled">';
      if(permission($user_id,'16','action_delete')){
    $action .= '<a href="' . asset('backend/productdelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>';
      }
    $action .= '</li>';


    $action .= '</ul>';




   $status = '<div class="toggle-flip" style="margin-left: 4px;">
            <input
                type="checkbox"
                id="flip' . $row->id . '"
                name="status"
                class="status-toggle"
                data-id="' . $row->id . '"
               ' . ($row->status == 1 ? 'checked' : '') . '>
            <label class="flip-label" for="flip' . $row->id . '"></label>
        </div>';

         $subservice = Subservice::where('id',$row->subservice_id)->first();
         if(empty($subservice)){
        $subservice = "";
    }else{
        $subservice = $subservice->title;
    } 
     $Subservice = '<span>'.$subservice.'</span>'; 
     
  $service = Service::where('id',$row->service_id)->first();
         if(empty($service)){
        $service = "";
    }else{
        $service = $service->title;
    } 
     $Services = '<span>'.$service.'</span>';

$brand = Brand::where('id', $row->brand_id)->first();
$brand = $brand ? $brand->brand_name : '';

$Brandname = '<span>' . $brand . '</span>';
   
     $data[] = array(
    "id" => $row->id, 
    "ordering_by" => $row->ordering_by,
     "service" => 
    '<span class="badge servicecolor" style="background:#5D3FD3;">' . $Services . '</span><br>' .
    '<span class="badge subservicecolor" style="background:#E91E63;">' . $Subservice . '</span>',
    "brand_id" => $Brandname,
    "product_item" => $row->product_item,
    "image" => '<a href="' . asset('uploads/product/' . $row->image) . '" data-fancybox="images" data-caption=""><img src="' . asset('uploads/product/' . $row->image) . '" style=" width: 36px;"></a>',
    "meta_title" => $row->meta_title,
    "meta_keyword" => $row->meta_keyword,
    "price" => 
    '<div class="d-flex flex-column">
        <span>₹' . number_format($row->default_price) . '</span>' .
        ($row->mrp_price 
            ? '<small class="text-danger text-decoration-line-through">₹' . number_format($row->mrp_price) . '</small>' 
            : ''
        ) .
    '</div>',
    // "mrp_price" => $row->mrp_price,
    "status" => $status,
    "action" => $action
);

    
    }
    
 $canViewGlobal = permission($user_id, '16', 'action_globle_view');
$canAccessCity = permission($user_id, '16', 'action_globle_city');

$city = superadmin::where('id', $user_id)->first();
$globle = $city->global_city ?? 0;





if ($user_id == '1') {
    $query = DB::table('tbl__products')->orderBy('ordering_by', 'ASC');

} elseif ($globle == 1 && $canViewGlobal) {
    $query = DB::table('tbl__products')->orderBy('ordering_by', 'ASC');

} elseif ($globle == 1 && $canAccessCity) {
    $query = DB::table('tbl__products')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');

} else {
    $query = DB::table('tbl__products')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
}




  
    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $productcount,
    "data" => $data
    );
    
    echo json_encode($datas);

    
    }


public function productstatus(Request $request)
{
    $id = $request->id;
    $product = Tbl_Product::find($id);

    if (!$product) {
        return response()->json(['success' => false, 'message' => 'Product not found'], 404);
    }

    $result = updateStatus('product', $id, $request->status);
    $currentStatus = Tbl_Product::where('id', $id)->value('status');

    return response()->json([
        'success' => $result['success'],
        'message' => $result['message'] ?? null,
        'status'  => $currentStatus
    ]);
}

public function productallottedcitystatus(Request $request)
{
    $id = $request->id;
    $newStatus = (string) $request->status;

    // Find record by id
    $record = Serviceallottedcity::find($id);

    if (!$record) {
        return response()->json([
            'success' => false,
            'message' => 'Product not found'
        ], 404);
    }

    // Call updateAllottedCityStatus with validation
    $result = updateAllottedCityStatus('product', $record, $newStatus);

    if (!$result['success']) {
        return response()->json([
            'success' => false,
            'message' => $result['message']
        ], 400);
    }

    // Save new status only if valid
    $record->status = $newStatus;
    $record->save();

    return response()->json(['success' => true]);
}   


public function productdelete(Request $request, $id)
{
    $id = Crypt::decrypt($id);
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '16', 'action_delete');
        if ($hasPermission) { 
    $delete = Tbl_Product::findOrFail($id);
    if ($delete->image) {
        $logoPath = public_path('uploads/product/' . $delete->image);

        if (file_exists($logoPath)) {
            @unlink($logoPath);
        }
    }

    $delete->delete();
        $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
        
         insertLogsAPI($user_id,'4','Product Delete','16','',$adduser,'','',$after,$before,''); 
      $message = fleshmessage(4,1,'product');
          return redirect()->back()->with($message['status'],$message['message']);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
}

public function productgetsubservices(Request $request)
{
    $response = [];

  
    if ($request->has('service_id')) {
        $response['subservices'] = Subservice::where('service_id', $request->service_id)->where('status', '1')
            ->get(['id', 'title']);
    }

   
    if ($request->has('subservice_id')) {
        $response['brands'] = Brand::where('subservice_id', $request->subservice_id)->where('status', '1')
            ->get(['id', 'brand_name']);
    }

    return response()->json($response);
}

//Product Allotted City

function productallottedcity(Request $request){
       
        $user_id = session('SUPERADMIN_ID');
    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    $id=Crypt::decrypt($request->id);
    $data['productallotteddata']= Tbl_Product::where('id',$id)->first();
   
     $data['country'] = DB::table('serviceallottedcities')->where('service_type','2')->where('status','1')->distinct()->select('countries_id')->get();
      insertLogsAPI($user_id,'2',' Product  Allotted City View','','','','','','','',''); 
    return view('backend.product.productallottedcity',$data);
}



 function productcountrydata(Request $request)
{
    $service_id = $request->service_id;

    // States
    $states = DB::table('serviceallottedcities as sac')->join('tbl_states as s', 'sac.state_id', '=', 's.state_id')->where('sac.countries_id', $request->country_id)->where('sac.service_type', '2')->where('sac.status', '1') ->distinct()->get(['sac.state_id', 's.name']);

    // Cities
    $cities = [];
    if ($request->state_id) {
        $cities = DB::table('serviceallottedcities as sac')->join('tbl_cities as c', 'sac.city_id', '=', 'c.city_id')->where('sac.state_id', $request->state_id)->where('sac.service_type', '2')->where('sac.status', '1') ->distinct()->get(['sac.city_id', 'c.name']);
    }

    return response()->json(['states' => $states, 'cities' => $cities]);
}

 function productallottedcityadd(Request $request)
{
    $user_id   = session('SUPERADMIN_ID');
    $serviceId = $request->id;
    $countryId = $request->countries;
    $stateId   = $request->state;
    $cityId    = $request->city;
    $status    = $request->status;
   
    $ip        = CurrentTimestamp()['ip'];
    $strtotime = CurrentTimestamp()['strtotime'];

    $inserted = false;
    $updated  = false;

    
    if (!empty($cityId)) {
        $existing = Serviceallottedcity::where('city_id', $cityId)->where('service_type','5')->where('serviceid',$serviceId)
            ->first();

        if ($existing) {
            
            $before = json_encode($existing);
            $existing->status           = $status ?? '1';
            $existing->ip               = $ip;
            $existing->price = $request->price;
            $existing->strtotime        = $strtotime;
            $existing->save();
          
            $after   = json_encode($existing);
            $adduser = $existing->id;
            insertLogsAPI($user_id,'2','Product Allotted City Update','','',$adduser,'','',$after,$before,''); 
            $updated = true;

        } else {
           
            $create = new Serviceallottedcity();
            $create->serviceid        = $serviceId;
            $create->service_type     = '5';
            $create->countries_id     = $countryId;
            $create->price     = $request->price;
            $create->state_id         = $stateId;
            $create->city_id          = $cityId;
            $create->status           = $status ?? '1';
           
            $create->ip               = $ip;
            $create->strtotime        = $strtotime;
            $create->save();

            $after   = json_encode($create);
            $before  = json_encode([]);
            $adduser = $create->id;

            insertLogsAPI($user_id,'1','Product Allotted City Add','','',$adduser,'','',$after,$before,''); 
            $inserted = true;
        }

   } else {
       
        $cities = DB::table('serviceallottedcities')->where('state_id', $stateId)->where('status','1')->where('service_type','2')->get();
     
        foreach ($cities as $city) {
            $existing = Serviceallottedcity::where('city_id', $city->city_id)->where('service_type','5')->where('serviceid',$serviceId)->first();

            if ($existing) {
              
                $before = json_encode($existing);

                $existing->status           = $status ?? '1';
              
                $existing->ip               = $ip;
                $existing->price               = $request->price;
                $existing->strtotime        = $strtotime;
                $existing->save();
           
                $after   = json_encode($existing);
                $adduser = $existing->id;

                insertLogsAPI($user_id,'2',' Product Allotted City Update','','',$adduser,'','',$after,$before,''); 
                $updated = true;

            } else {
             
                $create = new Serviceallottedcity();
                $create->serviceid        = $serviceId;
                $create->service_type     = '5';
                $create->countries_id     = $countryId;
                $create->price     = $request->price;
                $create->state_id         = $stateId;
                $create->city_id          = $city->city_id;
                $create->status           = $status ?? '1';
             
                $create->ip               = $ip;
                $create->strtotime        = $strtotime;
                $create->save();
                         

                $after   = json_encode($create);
                $before  = json_encode([]);
                $adduser = $create->id;

                insertLogsAPI($user_id,'1',' Product Allotted City Add','','',$adduser,'','',$after,$before,''); 
                $inserted = true;
            }
        }
    }
    
    

    if ($updated) {
        $message = fleshmessage(3,1,'Product Allotted City');
        return redirect()->back()->with($message['status'],$message['message']);
    } elseif ($inserted) {
        $messagei = fleshmessage(2,1,' Product Allotted City');
        return redirect()->back()->with($messagei['status'],$messagei['message']);
    } else {
        return redirect()->back()->with('error', 'Something went wrong.');
    }
}


function productallottedcityview(Request $request){
     $service_id =$request->service_id;
     $product_id =$request->product_id;
     $filterdata=[
         'countriesfilter'=>$request->countriesfilter,
         'statefilter'=>$request->statefilter,
         'cityfilter'=>$request->cityfilter,
         'statusfilter'=>$request->statusfilter,
         ];
       
  $draw  = $request->draw ?? 1;
    $rows  = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex     = $request->order[0]['column'] ?? 0;
    $columnName      = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? '';
    $searchValue     = $request->search['value'] ?? '';

 $user_id = session('SUPERADMIN_ID');
  $roledata = superadmin::where('id', $user_id)->first();
   
   

    $housesurveydata = Serviceallottedcity::productallottedcityview($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$filterdata,$service_id,$product_id);
    $housesurveycount = Serviceallottedcity::productallottedcityview($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$filterdata,$service_id,$product_id);
   
  
  
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($housesurveydata as $row) {
           $checkbox = '<input type="checkbox" class="row-checkbox" value="' . $row->id . '">';
  $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  

    $action .= '<li class="list-unstyled " style="margin: 0;">';
   
    $action .= '<a href="' . asset('backend/productallottedcitydelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-2">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>
    </li>';
    
    $action .= '</ul>';




    
     
    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
   $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
        ' . ($row->status == 1 ? 'checked' : '') . '>
    <label class="flip-label" for="flip' . $row->id . '"></label>
</div>';


     
 $city =DB::table('tbl_cities')->where('city_id', $row->city_id)->first();
         if(empty($city)){
        $city = "";
    }else{
        $city = $city->name;
    } 
     $Cityname = '<span>'.$city.'</span>'; 
     
 $state =DB::table('tbl_states')->where('state_id', $row->state_id)->first();
         if(empty($state)){
        $state = "";
    }else{
        $state = $state->name;
    } 
     $Statename = '<span>'.$state.'</span>'; 
     
 $country =DB::table('tbl_countries')->where('countries_id', $row->countries_id)->first();
         if(empty($country)){
        $country = "";
    }else{
        $country = $country->name;
    } 
     $Countryname = '<span>'.$country.'</span>'; 
     
  
        
        
  
        
   $country = DB::table('tbl_countries')->where('countries_id', $row->countries_id)->first();
        $countryName = $country->name ?? '';
        $countryName = '';

      
   
     $data[] = array(
    "id"        => $checkbox . " " . $row->id, 
  
   "countries" => $Countryname,
   "state" => $Statename,
   "city" => $Cityname,
   "price" => $row->price,
   "status" => $status,
    "action" => $action
);

    
    }
    

    $query = DB::table('serviceallottedcities')->orderBy('id', 'DESC')->where('service_type','5')->where('serviceid',$product_id);



  
    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $housesurveycount,
    "data" => $data
    );
    
    echo json_encode($datas);

    }
    
    
   


 function productdeletemultiplecities(Request $request)
{
    $ids = $request->ids;

    if (!empty($ids)) {
        $ids = array_filter($ids, function ($id) {
            return is_numeric($id);
        });

        if (!empty($ids)) {
            DB::table('serviceallottedcities')
                ->whereIn('id', $ids)
                ->delete();

            return response()->json([
                'status' => true,
                'message' => 'Selected records deleted successfully!'
            ]);
        }
    }

    return response()->json([
        'status' => false,
        'message' => 'No records selected!'
    ]);
}

function productallottedcitydelete(Request $request,$id){
     $user_id = session('SUPERADMIN_ID');
        $id=Crypt::decrypt($id);
        $delete = Serviceallottedcity::findOrFail($id);
        $delete->delete();
         $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Product Allotted City Delete','','',$adduser,'','',$after,$before); 
    $message = fleshmessage(4,1,'Product Allotted City');
          return redirect()->back()->with($message['status'],$message['message']);
   
    }




function productsingleview(Request $request){
    $id = Crypt::decrypt($request->id);
      $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '16', 'action_edit');
     if ($hasPermission) { 
        $data['productdata']=Tbl_Product::where('id',$id)->first();
           insertLogsAPI($user_id,'2',' Single View Product','16','','','','','','',''); 
        return view('backend.product.productsingleview',$data);
     }
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    
}

}
