<?php

namespace App\Http\Controllers\backend\media;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Media;
use App\Models\superadmin;
use Illuminate\Support\Str;
use App\Models\Websitesetting;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\File;
use Crypt;
use Session;

class MediaController extends Controller
{
    function media() {
        $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
         $hasPermission = permission($user_id, '27', 'action_view');
     if ($hasPermission) {
          insertLogsAPI($user_id,'2','Media View','27','','','','','','',''); 
        return view('backend.media.media');
     }
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
        

}

    
 

     public function mediacreate(Request $request){
          $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '27', 'action_add');
    if ($hasPermission) {
    $create = new Media;

    $create->title = $request->title;
    $create->media_type = $request->media_type;
    if ($request->hasFile('media_file')) {
    $img = Str::random(44) . '.' . $request->media_file->extension();
    $request->media_file->move(public_path('uploads/media'), $img);

    $create->media_file = $img;
}
    $create->media_url = $request->media_url;
    $create->panel_id = '1';
    $create->created_by = $user_id;
    $create->user_id = $user_id;
    $create->token = reandum_code('50');
    $create->ip = CurrentTimestamp()['ip'];
    $create->strtotime = CurrentTimestamp()['strtotime'];
    $create->created_at = CurrentTimestamp()['datetime'];
    $create->save();
    $after = json_encode($create);
    $before = json_encode($create);
    $adduser=$create->id;
    insertLogsAPI($user_id,'1','Media Add','27','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(2,1,'Media');
    return redirect()->back()->with($message['status'],$message['message']);
     }
    $website=Websitesetting::where('id','1')->first();
    $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
    return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
}

   
function mediaajax(Request $request){
    $draw   = $request->draw ?? 1;
    $start  = $request->start ?? 0;  
    $length = $request->length ?? 10;

    $columnIndex = isset($request->order[0]['column']) ? $request->order[0]['column'] : 0;
    $columnName  = isset($request->columns[$columnIndex]['data']) ? $request->columns[$columnIndex]['data'] : 'id';
    $columnSortOrder = isset($request->order[0]['dir']) ? $request->order[0]['dir'] : 'desc';
    $filltersearchValue = isset($request->columns[$columnIndex]['search']['value']) ? $request->columns[$columnIndex]['search']['value'] : '';
    $searchValue = $request->search['value'] ?? '';

    $user_id = session('SUPERADMIN_ID');


    if($user_id=='1'){
        
        $housesurveydata = Media::mediaajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start);
        $housesurveycount = Media::mediaajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start);
    }else{
        $housesurveydata = Media::mediaajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start);
        $housesurveycount = Media::mediaajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start);   
    }
  
    $i = 1;
    $data = array();
    $user_id = session('SUPERADMIN_ID');
         
    foreach ($housesurveydata as $row) {
        $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';
       
         $action .= '<li class="list-unstyled" style="margin: 0;"> ';
        if(permission($user_id,'27','action_edit')){
            $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/mediaedit/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                </a>';
        }
        $action .= '   </li>';

        $action .= '<li class="list-unstyled " style="margin: 0;">';
        if(permission($user_id,'27','action_delete')){
            $action .= '<a href="' . asset('backend/mediadelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                        <i class="fadeIn animated bx bx-trash anji me-0"></i>
                    </a>';
        }
        $action .= '</li>';
        $action .= '<li class="list-unstyled ms-1" style="margin: 0;"> ';
        if(permission($user_id,'27','action_view')){
           $action .= '   <a class="btn actionedit viewbtn btn-sm" href="https://uat.localpintu.com/uploads/media/' . $row->media_file . '" target="_blank">
    <i class="fadeIn animated bx bx-show anji me-0"></i>
</a>';

        }
        $action .= '   </li>';
        $action .= '</ul>';

        // $status = '<div class="toggle-flip" style="margin-left: 4px;">
        //     <input
        //         type="checkbox"
        //         id="flip' . $row->id . '"
        //         name="status"
        //         class="status-toggle"
        //         data-id="' . $row->id . '"
        //         onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
        //     <label class="flip-label" for="flip' . $row->id . '"></label>
        // </div>';

        $data[] = array(
            "id" => $row->id,
            "title"=>$row->title,
    	    "media_type"=>$row->media_type,
    	    "media_file"     => '<a href="https://uat.localpintu.com/uploads/media/' . $row->media_file . '" >' . $row->media_file . '</a>',

            "action" => $action
        );
    }
    
    $canViewGlobal = permission($user_id, '27', 'action_globle_view');
    $canAccessCity = permission($user_id, '27', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($user_id == '1') {
        $query = DB::table('media')->orderBy('id', 'ASC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('media')->orderBy('id', 'ASC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('media')->where('user_id', $user_id)->orderBy('id', 'ASC');
    } else {
        $query = DB::table('media')->where('user_id', $user_id)->orderBy('id', 'ASC');
    }

    $tot_rows = $query->count();
    
    $datas = array(
        "draw" => $draw,
        "recordsTotal" => $tot_rows,
        "recordsFiltered" => $housesurveycount,
        "data" => $data
    );
    
    echo json_encode($datas);
}
function mediadelete(Request $request,$id){
        $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '27', 'action_delete');
     if ($hasPermission) { 
      $id=Crypt::decrypt($id);
      $delete = Media::findOrFail($id);
      $image_path = public_path("uploads/media/{$delete->image}");
         if (File::exists($image_path) && !File::isDirectory($image_path)) {
        unlink($image_path);
        }
     $delete->delete();
     $after = json_encode($delete);
     $before = json_encode($delete);
     $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Media Delete','27','',$adduser,'','',$after,$before,''); 

    $message = fleshmessage(4,1,'Media');
    return redirect()->back()->with($message['status'],$message['message']);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
        
    }
    
    
    
    
 public function mediaupdate(Request $request)
{
     $id=Crypt::decrypt($request->id);
    $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '27', 'action_edit');
     if ($hasPermission) { 
       
    $update = Media::where('id',$id)->first();
    $before = json_encode($update);
    $update->title = $request->title;
    $update->media_type = $request->media_type;
    $update->media_url = $request->media_url;
 
  
if ($request->hasFile('media_file')) {
    // Generate a random file name
    $img = Str::random(44) . '.' . $request->media_file->extension();

    // Delete old image if exists
    if ($update->media_file && file_exists(public_path('uploads/media/' . $update->media_file))) {
        unlink(public_path('uploads/media/' . $update->media_file));
    }

    // Move new image to uploads/media
    $request->media_file->move(public_path('uploads/media'), $img);

    // Save new image name in DB
    $update->media_file = $img;
    $update->save();
}
    $update->panel_id = '1';
    $update->created_by = $user_id;
    $update->user_id = $user_id;
    $update->ip = CurrentTimestamp()['ip'];
    $update->strtotime = CurrentTimestamp()['strtotime'];
    $update->created_at = CurrentTimestamp()['datetime'];
    $update->updated_at = CurrentTimestamp()['datetime'];
    $update->save();
    $after = json_encode($update);
    $adduser=$update->id;
    insertLogsAPI($user_id,'3','Media Update','27','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(3,1,'Media');
    return redirect(url('backend/media/media'))->with($message['status'],$message['message']);

     }
}
  
    
    
    


  function mediaedit(Request $request){
     $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '27', 'action_edit');
     if ($hasPermission) {
        $id=Crypt::decrypt($request->id);
     $data['media']= Media::where('id',$id)->first();
      return view('backend.media.mediaedit',$data);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
        }




}
