<?php

namespace App\Http\Controllers\backend\master;
use App\Models\superadmin;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\File;
use Crypt;
use App\Models\Websitesetting;
use Session;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Status;
use App\Models\Source;
use App\Models\Slider;

class MasterController extends Controller
{
    function status(){
        $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }

    $user_id = session('SUPERADMIN_ID');


    $hasPermission = permission($user_id, '14', 'action_view');
    if ($hasPermission) { 
        insertLogsAPI($user_id, '2', 'Status View', '14', '', '', '', '', '', '', ''); 
        return view('backend.master.status');
    }

    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }
    



    function statuscreate(Request $request){
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '14', 'action_add');
        if ($hasPermission) { 
    $create = new Status();
    $create->title = $request->title;
    $create->color = $request->color;
    $create->bg_color = $request->bg_color;
    $create->user_id = $user_id;
    $create->created_by=$user_id;
    $create->panel_id='1';
    $create->tokan=reandum_code('50');

    // Assuming CurrentTimestamp() returns an array with 'ip' and 'strtotime'
    $timestampData = CurrentTimestamp();
    $create->ip = $timestampData['ip'];
    $create->strtotime = CurrentTimestamp()['strtotime'];
    $create->created_at = CurrentTimestamp()['datetime'];
    $create->updated_at = CurrentTimestamp()['datetime'];

    $create->save();
    $after = json_encode($create);
    $before = json_encode($create);
    $adduser = $create->id;

    insertLogsAPI($user_id, '1', 'Status Add', '14', '', $adduser, '', '', $after, $before, '');
    $message = fleshmessage(2,1,'Status');
    return redirect()->back()->with($message['status'],$message['message']);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }



function statusupdate(Request $request) {
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '14', 'action_edit');
        if ($hasPermission) { 
    $update = Status::where('id',$request->id)->first();
    $before = json_encode($update);


    $update->title = $request->title;
    $update->color = $request->color;
    $update->bg_color = $request->bg_color;
    $update->user_id = $user_id;
    $update->created_by=$user_id;
    $update->panel_id='1';

    $update->ip = CurrentTimestamp()['ip'];
    $update->strtotime = CurrentTimestamp()['strtotime'];
    $update->created_at = CurrentTimestamp()['datetime'];
    $update->updated_at = CurrentTimestamp()['datetime'];

    $update->save();
    $after = json_encode($update);
    $adduser=$update->id;
    insertLogsAPI($user_id,'3','Status Update','14','',$adduser,'','',$after,$before); 
    $message = fleshmessage(3, 1, 'Status');
    return redirect()->back()->with($message['status'], $message['message']);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
}

    
        function statusajax(Request $request){
   $draw   = $request->draw ?? 0;
    $rows   = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? null;
    $searchValue = $request->search['value'] ?? null;


        $user_id = session('SUPERADMIN_ID');
        $roledata = superadmin::where('id', $user_id)->first();
        if($roledata->role=='1'){


        $statusdata = Status::statusajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length);
        $statuscount = Status::statusajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length);
        }else{
        $statusdata = Status::statusajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$user_id);
        $statuscount = Status::statusajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$user_id);
        }


    // Prepare response data
    $data = [];
       $user_id = session('SUPERADMIN_ID');
    foreach ($statusdata as $row) {
        $action = '<ul class="action list-unstyled d-flex m-0">';

        // Edit button
if (permission($user_id, '14', 'action_edit')) {
    $action .= '<li class="list-unstyled" style="margin: 0;">
        <a href="javascript:void(0);"
           class="actionedit btn editbtn btn-sm"
           title="Partner Edit"
           data-bs-toggle="modal"
           data-bs-target="#editModal"
           onclick="statusedit(' . htmlspecialchars(json_encode($row), ENT_QUOTES, 'UTF-8') . ')">
            <i class="fadeIn animated anji bx bx-pencil me-0"></i>
        </a>
    </li>';
}


        // Delete button
        // if (permission($row->id != '1' && $user_id, '14', 'action_delete')) {
        //     $action .= '<li>
        //         <a class="btn deletebtn btn-sm ms-2" onclick="return check_delete();" href="' . asset('backend/statusdelete/' . Crypt::encrypt($row->id)) . '">
        //             <i class="fadeIn animated bx bx-trash anji me-0"></i>
        //         </a>
        //     </li>';
        // }



        $action .= '</ul>';

        if($row->status === '1'){
        $checked = 'checked';
        }

        $status = '<div class="toggle-flip" style="margin-left: 4px;">
        <input type="checkbox" id="flip' . $row->id . '" name="status" class="status-toggle" data-id="' . $row->id . '"
        onclick="round_success_noti()" ' . ($row->status == 1 ? ' checked' : '' ) . '>
        <label class="flip-label" for="flip' . $row->id . '"></label>
        </div>';


$data[] = array(
    "id" => $row->id,
    "title" => $row->title,
    "color" => $row->color,
    "bg_color" => $row->bg_color,
    "status" => $status,
    "action" => $action
);


        }


    $canViewGlobal = permission($user_id, '14', 'action_globle_view');
    $canAccessCity = permission($user_id, '14', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($user_id == '1') {
        $query = DB::table('statuses')->orderBy('id', 'DESC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('statuses')->orderBy('id', 'DESC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('statuses')->where('user_id', $user_id)->orderBy('id', 'DESC');
    } else {
        $query = DB::table('statuses')->where('user_id', $user_id)->orderBy('id', 'DESC');
    }





        $tot_rows = $query->count();

        $datas = array(
        "draw" => $draw,
        "recordsTotal" => $tot_rows,
        "recordsFiltered" => $statuscount,
        "data" => $data
        );

        echo json_encode($datas);


        }
        
public function statusstatus(Request $request) {
    $id = $request->id;
    $statusstatus = Status::find($id);
    if (!$statusstatus) {
        return response()->json(['success' => false, 'message' => 'Status not found'], 404);
    }

    $statusstatus->status = $request->status;
    $statusstatus->save();
    return response()->json(['success' => true]);
}     
function statusdelete(Request $request,$id){
      $id=Crypt::decrypt($id);
    $user_id = session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '14', 'action_delete');
    if ($hasPermission) { 
        $delete = Status::findOrFail($id);
        $delete->delete();
     $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Service Delete','14','',$adduser,'','',$after,$before,'');
    $message = fleshmessage(4,1,'Status');
    return redirect()->back()->with($message['status'],$message['message']);
    }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
        
    }
    
    
    
    
    
    
    
///// Source    
    
    
    
    
    
    function source(){
            $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }

    $user_id = session('SUPERADMIN_ID');


    $hasPermission = permission($user_id, '15', 'action_view');
    if ($hasPermission) { 
        insertLogsAPI($user_id, '2', 'Source View', '15', '', '', '', '', '', '', ''); 
        return view('backend.master.source');
    }

    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }
    



    function sourcecreate(Request $request){
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '15', 'action_add');
        if ($hasPermission) { 
    $create = new Source();
    $create->title = $request->title;
    $create->color = $request->color;
    $create->bg_color = $request->bg_color;
    $create->user_id = $user_id;
    $create->created_by=$user_id;
    $create->panel_id='1';
    $create->tokan=reandum_code('50');

    // Assuming CurrentTimestamp() returns an array with 'ip' and 'strtotime'
    $timestampData = CurrentTimestamp();
    $create->ip = $timestampData['ip'];
    $create->strtotime = CurrentTimestamp()['strtotime'];
    $create->created_at = CurrentTimestamp()['datetime'];
    $create->updated_at = CurrentTimestamp()['datetime'];

    $create->save();
    $after = json_encode($create);
    $before = json_encode($create);
    $adduser = $create->id;

    insertLogsAPI($user_id, '1', 'Source Add', '15', '', $adduser, '', '', $after, $before, '');
    $message = fleshmessage(2,1,'Source');
    return redirect()->back()->with($message['status'],$message['message']);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }



function sourceupdate(Request $request) {
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '15', 'action_edit');
        if ($hasPermission) { 
    $update = Source::where('id',$request->id)->first();
    $before = json_encode($update);


    $update->title = $request->title;
    $update->color = $request->color;
    $update->bg_color = $request->bg_color;
    $update->user_id = $user_id;
    $update->created_by=$user_id;
    $update->panel_id='1';

    $update->ip = CurrentTimestamp()['ip'];
    $update->strtotime = CurrentTimestamp()['strtotime'];
    $update->created_at = CurrentTimestamp()['datetime'];
    $update->updated_at = CurrentTimestamp()['datetime'];

    $update->save();
    $after = json_encode($update);
    $adduser=$update->id;
    insertLogsAPI($user_id,'3','Source Update','15','',$adduser,'','',$after,$before); 
    $message = fleshmessage(3, 1, 'Source');
    return redirect()->back()->with($message['status'], $message['message']);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
}

    
        function sourceajax(Request $request){
   $draw   = $request->draw ?? 0;
    $rows   = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? null;
    $searchValue = $request->search['value'] ?? null;


        $user_id = session('SUPERADMIN_ID');
        $roledata = superadmin::where('id', $user_id)->first();
        if($roledata->role=='1'){


        $sourcedata = Source::sourceajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length);
        $sourcecount = Source::sourceajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length);
        }else{
        $sourcedata = Source::sourceajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$user_id);
        $sourcecount = Source::sourceajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$user_id);
        }


    // Prepare response data
    $data = [];
    foreach ($sourcedata as $row) {
        $action = '<ul class="action list-unstyled d-flex m-0">';

        // Edit button
if (permission($user_id, '15', 'action_edit')) {
    $action .= '<li class="list-unstyled" style="margin: 0;">
        <a href="javascript:void(0);"
           class="actionedit btn editbtn btn-sm"
           title="Partner Edit"
           data-bs-toggle="modal"
           data-bs-target="#editModal"
           onclick="sourceedit(' . htmlspecialchars(json_encode($row), ENT_QUOTES, 'UTF-8') . ')">
            <i class="fadeIn animated anji bx bx-pencil me-0"></i>
        </a>
    </li>';
}


        // Delete button
        if (permission($user_id, '15', 'action_delete')) {
            $action .= '<li>
                <a class="btn deletebtn btn-sm ms-2" onclick="return check_delete();" href="' . asset('backend/sourcedelete/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>
            </li>';
        }



        $action .= '</ul>';

        if($row->status === '1'){
        $checked = 'checked';
        }

        $status = '<div class="toggle-flip" style="margin-left: 4px;">
        <input type="checkbox" id="flip' . $row->id . '" name="status" class="status-toggle" data-id="' . $row->id . '"
        onclick="round_success_noti()" ' . ($row->status == 1 ? ' checked' : '' ) . '>
        <label class="flip-label" for="flip' . $row->id . '"></label>
        </div>';


$data[] = array(
    "id" => $row->id,
    "title" => $row->title,
    "color" => $row->color,
    "bg_color" => $row->bg_color,
    "status" => $status,
    "action" => $action
);


        }


    $canViewGlobal = permission($user_id, '15', 'action_globle_view');
    $canAccessCity = permission($user_id, '15', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($user_id == '1') {
        $query = DB::table('sources')->orderBy('id', 'DESC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('sources')->orderBy('id', 'DESC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('sources')->where('user_id', $user_id)->orderBy('id', 'DESC');
    } else {
        $query = DB::table('sources')->where('user_id', $user_id)->orderBy('id', 'DESC');
    }





        $tot_rows = $query->count();

        $datas = array(
        "draw" => $draw,
        "recordsTotal" => $tot_rows,
        "recordsFiltered" => $sourcecount,
        "data" => $data
        );

        echo json_encode($datas);


        }
        
public function sourcestatus(Request $request) {
    $id = $request->id;
    $statusstatus = Source::find($id);
    if (!$statusstatus) {
        return response()->json(['success' => false, 'message' => 'Source not found'], 404);
    }

    $statusstatus->status = $request->status;
    $statusstatus->save();
    return response()->json(['success' => true]);
}     
function sourcedelete(Request $request,$id){
      $id=Crypt::decrypt($id);
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '15', 'action_delete');
        if ($hasPermission) { 
        $delete = Source::findOrFail($id);
        $delete->delete();
     $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Source Delete','15','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(4,1,'Source');
    return redirect()->back()->with($message['status'],$message['message']);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
        
    }
    
    


}
