<?php

namespace App\Http\Controllers\backend\lead;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Websitesetting;
use App\Models\Lead;
use App\Models\Reminder;
use App\Models\reminder_type;
use App\Models\superadmin;
use App\Models\Followup;
use Illuminate\Support\Str;
use DB;
use Crypt;
class LeadController extends Controller
{


//Lead//

function lead(){
    
    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    $user_id = session('SUPERADMIN_ID');
        $hasPermission = permission($user_id, '13', 'action_view');
         if ($hasPermission) { 
           insertLogsAPI($user_id,'2','Lead View','13','','','','','','',''); 
      $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
     
    
        return view('backend.lead./lead',$data);
     }
         $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
       
    }


function leadscreate(Request $request){
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '13', 'action_add');
        if ($hasPermission) {     
      $create = new Lead;
        $create->tags = $request->tags;
        $create->name = $request->name;
        $create->phone = $request->phone;
        $create->leadstatus = $request->leadstatus;
        $create->source = $request->source;
       $create->email_address = $request->email_address;
       $create->position = $request->position;
       $create->company = $request->company;
       $create->country = $request->countries;
       $create->state = $request->state;
       $create->city = $request->city;
       $create->pincode = $request->pincode;
       $create->address = $request->address;
       $create->website = $request->website;
       $create->lead_value = $request->lead_value;
       $create->description = $request->description;
       $create->created_by=$user_id;
       $create->user_id=$user_id;
     
       $create->panel_id='1';

       $create->ip = CurrentTimestamp()['ip'];
       $create->strtotime = CurrentTimestamp()['strtotime'];
        $create->created_at = CurrentTimestamp()['datetime'];
        $create->updated_at = CurrentTimestamp()['datetime'];
 
       $create->save();
       
          $after = json_encode($create);
     $before = json_encode($create);
         $adduser=$create->id;
    insertLogsAPI($user_id,'1','Lead Add','13','',$adduser,'','',$after,$before,'');
       
       $message = fleshmessage(2,1,'lead');
       

       
    return  redirect()->back()->with($message['status'],$message['message']);
}
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
}



  public function leadcountrydata(Request $request)
{
   
        $states = DB::table('tbl_states')
                ->where('country_id', $request->country_id)->where('s_status','1')
                ->get(['state_id', 'name']);


    $cities = DB::table('tbl_cities')
                ->where('stateid', $request->state_id ?? null)->where('city_status','1') 
                ->get(['city_id', 'name']);
    

    return response()->json(['states' => $states, 'cities' => $cities]);
}

function leadsajax(Request $request){
    $draw   = $request->draw ?? 1;
    $start  = $request->start ?? 0;  
    $length = $request->length ?? 10;

    $columnIndex = isset($request->order[0]['column']) ? $request->order[0]['column'] : 0;
    $columnName  = isset($request->columns[$columnIndex]['data']) ? $request->columns[$columnIndex]['data'] : 'id';
    $columnSortOrder = isset($request->order[0]['dir']) ? $request->order[0]['dir'] : 'desc';
    $filltersearchValue = isset($request->columns[$columnIndex]['search']['value']) ? $request->columns[$columnIndex]['search']['value'] : '';
    $searchValue = $request->search['value'] ?? '';

    $user_id = session('SUPERADMIN_ID');
    $roledata = superadmin::where('id', $user_id)->first();

    if($roledata && $roledata->role=='1'){
        
        $housesurveydata = Lead::leadsajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start);
        $housesurveycount = Lead::leadsajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start);
    }else{
        $housesurveydata = Lead::leadsajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start);
        $housesurveycount = Lead::leadsajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start);   
    }
  
    $i = 1;
    $data = array();
    $user_id = session('SUPERADMIN_ID');
         
    foreach ($housesurveydata as $row) {
        
           $city = DB::table('tbl_cities')->where('city_id', $row->city)->first();
    $cityName = !empty($city) ? $city->name : '';

    // --- State ---
    $state = DB::table('tbl_states')->where('state_id', $row->state)->first();
    $stateName = !empty($state) ? $state->name : '';

    // --- Country ---
    $country = DB::table('tbl_countries')->where('countries_id', $row->country)->first();
    $countryName = !empty($country) ? $country->name : '';
      
        $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';
        $action .= '<li class="list-unstyled" style="margin: 0;"> ';
        if(permission($user_id,'13','action_edit')){
            $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/leadedit/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                </a>';
        }
        $action .= '   </li>';

        $action .= '<li class="list-unstyled " style="margin: 0;">';
        if(permission($user_id,'13','action_delete')){
            $action .= '<a href="' . asset('backend/leaddelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                        <i class="fadeIn animated bx bx-trash anji me-0"></i>
                    </a>';
        }
        $action .= '</li>';
         if(permission($user_id,'13','action_edit')){
      
        $extraData = [
            'city'    => $cityName,
            'state'   => $stateName,
            'country' => $countryName,
            'description' => $row->description,
            'tags' => $row->tags,
        ];

        $action .= '<li class="list-unstyled" style="margin: 0;">
            <a data-bs-toggle="modal" 
               data-bs-target="#editModal" 
               class="actionedit btn editbtn btn-sm ms-1" 
               href="javascript:void(0);" 
               onClick="alldatainlead(' . htmlspecialchars(json_encode(array_merge((array)$row, $extraData)), ENT_QUOTES, 'UTF-8') . ');">
              <i class="fadeIn animated bx bx-show anji me-0"></i>
            </a>
        </li>';
    }
    
    

        $action .= '</ul>';

        $status = '<div class="toggle-flip" style="margin-left: 4px;">
            <input
                type="checkbox"
                id="flip' . $row->id . '"
                name="status"
                class="status-toggle"
                data-id="' . $row->id . '"
                onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
            <label class="flip-label" for="flip' . $row->id . '"></label>
        </div>';

        $data[] = array(
            "id" => $row->id, 
            "name" => $row->name,
            "phone" => $row->phone,
            "email_address" => $row->email_address,
            "status" => $status,
            "action" => $action
        );
    }
    
    $canViewGlobal = permission($user_id, '13', 'action_globle_view');
    $canAccessCity = permission($user_id, '13', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($user_id == '1') {
        $query = DB::table('leads')->orderBy('id', 'DESC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('leads')->orderBy('id', 'DESC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('leads')->where('user_id', $user_id)->orderBy('id', 'DESC');
    } else {
        $query = DB::table('leads')->where('user_id', $user_id)->orderBy('id', 'DESC');
    }

    $tot_rows = $query->count();
    
    $datas = array(
        "draw" => $draw,
        "recordsTotal" => $tot_rows,
        "recordsFiltered" => $housesurveycount,
        "data" => $data
    );
    
    echo json_encode($datas);
}

    
    function leaddelete(Request $request,$id){
         $user_id = session('SUPERADMIN_ID');
     $hasPermission = permission($user_id, '13', 'action_delete');
     if ($hasPermission) { 
      $id=Crypt::decrypt($id);
   
        $delete = Lead::findOrFail($id);
        $delete->delete();
       $after = json_encode($delete);
     $before = json_encode($delete);
   $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Lead Delete','13','',$adduser,'','',$after,$before,''); 


     $message = fleshmessage(4,1,'Lead');
          return redirect()->back()->with($message['status'],$message['message']);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
        
    }


 function leadedit(Request $request){
     
     $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '13', 'action_edit');
    if ($hasPermission) {     
       
        $id=Crypt::decrypt($request->id);
         $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
        $data['leaddata']=Lead::where('id',$id)->first();
        return view('backend.lead.leadedit',$data);
    }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }
   
   public function leadupdate(Request $request){

       $id = Crypt::decrypt($request->id);
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '13', 'action_edit');
        if ($hasPermission) { 
    $update = Lead::findOrFail($id);
    $before = json_encode($update);
 $update->tags = $request->tags;
        $update->name = $request->name;
        $update->phone = $request->phone;
        $update->leadstatus = $request->leadstatus;
        $update->source = $request->source;
       $update->email_address = $request->email_address;
       $update->position = $request->position;
       $update->company = $request->company;
       $update->country = $request->countries;
       $update->state = $request->state;
       $update->city = $request->city;
       $update->pincode = $request->pincode;
       $update->address = $request->address;
       $update->website = $request->website;
    
  $update->lead_value = $request->lead_value;
       $update->description = $request->description;
       $update->created_by=$user_id;
       $update->user_id=$user_id;
     
       $update->panel_id='1';

       $update->ip = CurrentTimestamp()['ip'];
       $update->strtotime = CurrentTimestamp()['strtotime'];
  $update->created_at = CurrentTimestamp()['datetime'];
        $update->updated_at = CurrentTimestamp()['datetime'];
   
   

    $update->save();
        $after = json_encode($update);
             $adduser=$update->id;
    insertLogsAPI($user_id,'3','Lead Update','13','',$adduser,'','',$after,$before,''); 
    
 $message = fleshmessage(3,1,'Lead');
    return redirect(url('backend/lead/lead'))->with($message['status'],$message['message']);
}
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
}

//Lead ////



//reminder

//reminder add
function remindercreate(Request $request){
    $user_id = session('SUPERADMIN_ID');
        $reminder = new Reminder;
        $reminder->reminder_type = $request->reminder_type;
        $reminder->title = $request->title;
        $reminder->email = $request->email;
        $reminder->content = $request->content;
        if ($request->file) {
        $img = time() . 'file.' . $request->file->extension();
        $request->file->move(public_path('uploads/reminder'), $img);
        $reminder->file = $img;
        }
        $reminder->created_by = $user_id;
        $reminder->user_id = $user_id;
        $reminder->primary_id = '0';
        $reminder->panel_id = '1';
        $reminder->ip = CurrentTimestamp()['ip'];
        $reminder->strtotime = CurrentTimestamp()['strtotime'];
        $reminder->datetime  = CurrentTimestamp()['datetime'];
          $reminder->datestrtotime = strtotime($reminder->datetime);

    $reminder->save();

    $message =  fleshmessage(2,1,'Reminders'); 

    return redirect()->back()->with($message['status'],$message['message']);
}
function reminderupdate(Request $request){
    $user_id = session('SUPERADMIN_ID');
       $update = Reminder::find($request->id);
        $update->title = $request->title;
        $update->email = $request->email;
        $update->content = $request->content;
         if ($request->hasFile('file')) {
        // Delete old file if exists
        if ($update->file && file_exists(public_path('uploads/reminder/' . $update->file))) {
            unlink(public_path('uploads/reminder/' . $update->file));
        }

        // Save new file
        $img = time() . '_file.' . $request->file->extension();
        $request->file->move(public_path('uploads/reminder'), $img);
        $update->file = $img;
    }
        $update->created_by = $user_id;
        $update->user_id = $user_id;
        $update->primary_id = '0';
        $update->panel_id = '1';
        $update->ip = CurrentTimestamp()['ip'];
        $update->strtotime = CurrentTimestamp()['strtotime'];
        $update->datetime  = CurrentTimestamp()['datetime'];
          $update->datestrtotime = strtotime($update->datetime);

    $update->save();

    $message =  fleshmessage(3,1,'Reminders'); 

    return redirect()->back()->with($message['status'],$message['message']);
}











public function leadstatus(Request $request) {
    $id = $request->id;
    $statusstatus = Lead::find($id);
    if (!$statusstatus) {
        return response()->json(['success' => false, 'message' => 'Lead not found'], 404);
    }

    $statusstatus->status = $request->status;
    $statusstatus->save();
    return response()->json(['success' => true]);
}     



    function reminderajax(Request $request){
       
    
    $draw   = $request->draw ?? 0;
    $rows   = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? null;
    $searchValue = $request->search['value'] ?? null;
    
   $user_id = session('SUPERADMIN_ID');
    if($user_id=='1'){
   

    $reminderdata = Reminder::reminderajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length);
    $remindercount = Reminder::reminderajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length);
    }else{
       $reminderdata = Reminder::reminderajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$user_id);
    $remindercount = Reminder::reminderajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$user_id);   
    }
     
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($reminderdata as $row) {
   $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  

    // Edit Button
$action .= '<li class="list-unstyled" style="margin: 0;"> ';
if(permission($user_id,'13','action_edit')){
    $action .= '<a href="javascript:void(0)" 
        class="btn actionedit editbtn btn-sm" 
         onClick="reminderedit(' . htmlspecialchars(json_encode(array_merge((array)$row)), ENT_QUOTES, 'UTF-8') . ');">
        <i class="fadeIn animated bx bx-pencil anji me-0"></i>
    </a>';
}
$action .= '</li>';

if (!empty($row->file) && file_exists(public_path('uploads/reminder/' . $row->file))) {
    $action .= '<a href="' . asset('uploads/reminder/' . $row->file) . '" 
        data-fancybox="gallery" 
        class="btn viewbtn btn-sm ms-1" 
        title="View File">
        <i class="fadeIn animated bx bx-show anji me-0"></i>
    </a>';
}

$action .= '</li>';


    $action .= '<li class="list-unstyled">';
      if(permission($user_id,'13','action_delete')){
    $action .= '<a href="' . asset('backend/reminderdelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>';
      }
    $action .= '</li>';


    $action .= '</ul>';




    
    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
   $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
        onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
    <label class="flip-label" for="flip' . $row->id . '"></label>
</div>';


$reminderType = reminder_type::where('id', $row->reminder_type)->first();

if (!$reminderType) {
    $reminder_type_display = '';
} else {
    $reminder_type_display = $reminderType->title;
}

$Reminder = '<span>' . $reminder_type_display . '</span>';
   
     $data[] = array(
    "id" => $row->id, 
    // "reminder_type" => $Reminder,
    "title" => '<span class="text-success">' . $row->title . '</span><br><span class="text-primary">' . $row->email . '</span>',
    // "email" => $row->email,
    "content" => $row->content,
    "status" => $status,
    "action" => $action
);

    
    }
    
 $canViewGlobal = permission($user_id, '13', 'action_globle_view');
$canAccessCity = permission($user_id, '13', 'action_globle_city');

$city = superadmin::where('id', $user_id)->first();
$globle = $city->global_city ?? 0;





if ($user_id == '1') {
    $query = DB::table('reminders')->orderBy('id', 'ASC');

} elseif ($globle == 1 && $canViewGlobal) {
    $query = DB::table('reminders')->orderBy('id', 'ASC');

} elseif ($globle == 1 && $canAccessCity) {
    $query = DB::table('reminders')->where('user_id', $user_id)->orderBy('id', 'ASC');

} else {
    $query = DB::table('reminders')->where('user_id', $user_id)->orderBy('id', 'ASC');
}




  
    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $remindercount,
    "data" => $data
    );
    
    echo json_encode($datas);

    
    }



public function reminderstatus(Request $request) {
    $id = $request->id;
    $statusstatus = Reminder::find($id);
    if (!$statusstatus) {
        return response()->json(['success' => false, 'message' => 'Reminder not found'], 404);
    }

    $statusstatus->status = $request->status;
    $statusstatus->save();
    return response()->json(['success' => true]);
}     


public function reminderdelete(Request $request, $id)
{
    // $id = Crypt::decrypt($id);
    //   $user_id = session('SUPERADMIN_ID');
    //   $hasPermission = permission($user_id, '16', 'action_delete');
    //     if ($hasPermission) { 
    $delete = Reminder::findOrFail($id);
    if ($delete->file) {
        $logoPath = public_path('uploads/reminder/' . $delete->file);

        if (file_exists($logoPath)) {
            @unlink($logoPath);
        }
    }

    $delete->delete();
    //     $after = json_encode($delete);
    //  $before = json_encode($delete);
    // $adduser=$delete->id;
        
    //      insertLogsAPI($user_id,'4','Product Delete','16','',$adduser,'','',$after,$before,''); 
    //   $message = fleshmessage(4,1,'product');
    //       return redirect()->back()->with($message['status'],$message['message']);
        
    // $website = Websitesetting::where('id', '1')->first();
    // $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    // return redirect(asset('backend/permission_denied'))
    //     ->with($messagepremission['status'], $messagepremission['message'])
    //     ->send();
}


    
 





public function followup(Request $request)
{
    $user_id = session('SUPERADMIN_ID');
        $create = new Followup();
        $create->user_id = $user_id;
        $create->created_by = $user_id;
        $create->panel_id = '1';
        $create->tokan = reandum_code('50');
        $create->ip = CurrentTimestamp()['ip'];
        $create->strtotime = CurrentTimestamp()['strtotime'];
        $create->created_at = CurrentTimestamp()['datetime'];
        $create->updated_at = CurrentTimestamp()['datetime'];
    $create->startdate = $request->startdate;
    $create->enddate = $request->enddate;
    $create->content = $request->content;

    $create->save();

    $message = fleshmessage(2, 1, 'followup');

    return redirect()->back()->with($message['status'], $message['message']);
}





  function followupdate(Request $request){
 
    $user_id = session('SUPERADMIN_ID');

   $update = Followup::find($request->id);

    if(!$update){
        return redirect()->back()->with('error', 'Followup not found');
    }
    $update->user_id = $user_id;
    $update->created_by = $user_id;
    $update->panel_id = '1';
    $update->ip = CurrentTimestamp()['ip'];
    $update->strtotime = CurrentTimestamp()['strtotime'];
    $update->created_at = CurrentTimestamp()['datetime'];
    $update->updated_at = CurrentTimestamp()['datetime'];
    $update->startdate = $request->startdate;
    $update->enddate = $request->enddate;
    $update->content = $request->content;
    $update->save();
    $message = fleshmessage(3, 1, 'Followup');

    return redirect()->back()->with($message['status'], $message['message']);
}

 
 




public function followupdelete(Request $request, $id)
{
    $id = Crypt::decrypt($id);
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '13', 'action_delete');
        if ($hasPermission) { 
    $delete = Followup::findOrFail($id);
 

    $delete->delete();
        $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
        
         insertLogsAPI($user_id,'4','Followup Delete','13','',$adduser,'','',$after,$before,''); 
      $message = fleshmessage(4,1,'Followup');
          return redirect()->back()->with($message['status'],$message['message']);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
}




    function followupajax(Request $request){
       
    
    $draw   = $request->draw ?? 0;
    $rows   = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? null;
    $searchValue = $request->search['value'] ?? null;
    
   $user_id = session('SUPERADMIN_ID');
    if($user_id=='1'){
   

    $followdata = Followup::followupajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length);
    $followcount = Followup::followupajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length);
    }else{
       $followdata = Followup::followupajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$user_id);
    $followcount = Followup::followupajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$user_id);   
    }
     
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($followdata as $row) {
   $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  

// Edit Button
$action .= '<li class="list-unstyled" style="margin: 0;">';
if (permission($user_id, '13', 'action_edit')) {
    $action .= '<a href="javascript:void(0)" 
        class="btn actionedit editbtn btn-sm" 
        data-tab="followup" 
      onClick="followupedit(' . htmlspecialchars(json_encode(array_merge((array)$row)), ENT_QUOTES, 'UTF-8') . ');">
        <i class="fadeIn animated bx bx-pencil anji me-0"></i>
    </a>';
}
$action .= '</li>';




    $action .= '<li class="list-unstyled">';
      if(permission($user_id,'13','action_delete')){
    $action .= '<a href="' . asset('backend/followupdelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>';
      }
    $action .= '</li>';


    $action .= '</ul>';




    
    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
   $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
        onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
    <label class="flip-label" for="flip' . $row->id . '"></label>
</div>';
$content = $row->content;



$content = $row->content;

if (strlen($content) > 25) {
    $short = Str::limit($content, 25);
    $full = $content;

    $contentHtml = '<div class="content-cell">
                        <span class="short-text">'.e($short).'</span>
                        <span class="full-text d-none">'.e($full).'</span>
                        <a href="javascript:void(0)" class="read-more">Read More</a>
                    </div>';
} else {
    $contentHtml = '<div class="content-cell">'.e($content).'</div>';
}

   
     $data[] = array(
    "id" => $row->id, 
    "dates" => $row->startdate . '<br>' . $row->enddate,
    "content" => $contentHtml,
    "action" => $action
);

    
    }
    
 $canViewGlobal = permission($user_id, '13', 'action_globle_view');
$canAccessCity = permission($user_id, '13', 'action_globle_city');

$city = superadmin::where('id', $user_id)->first();
$globle = $city->global_city ?? 0;





if ($user_id == '1') {
    $query = DB::table('followups')->orderBy('id', 'ASC');

} elseif ($globle == 1 && $canViewGlobal) {
    $query = DB::table('followups')->orderBy('id', 'ASC');

} elseif ($globle == 1 && $canAccessCity) {
    $query = DB::table('followups')->where('user_id', $user_id)->orderBy('id', 'ASC');

} else {
    $query = DB::table('followups')->where('user_id', $user_id)->orderBy('id', 'ASC');
}




  
    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $followcount,
    "data" => $data
    );
    
    echo json_encode($datas);

    
    }
    
 



}
