<?php

namespace App\Http\Controllers\backend\features;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Testimonial;
use App\Models\superadmin;
use App\Models\Websitesetting;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\File;
use Crypt;
use Session;

class TestimonialController extends Controller
{
     function testimonial(){
           $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
         $hasPermission = permission($user_id, '26', 'action_view');
     if ($hasPermission) {
          insertLogsAPI($user_id,'2','Testimonial View','26','','','','','','',''); 
        return view('backend.features.testimonial');
     }
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
       
    }
    
    public function testimonialcreate(Request $request){
    $user_id = session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '26', 'action_add');
    if ($hasPermission) {
         $existingMobile = Testimonial::where('name', $request->name)->first();
    if ($existingMobile) {
         $message = fleshmessage(6,1,'Name');
        return redirect()->back()->with($message['status'],$message['message']);
    }
    $create = new Testimonial;
    $create->name = $request->name;
    $create->designation = $request->designation;
    $create->description = $request->description;
    $create->rating = $request->rating;
   if ($request->image) {
        $img = time() . 'image.' . $request->image->extension();
        $request->image->move(public_path('uploads/testimonial'), $img);
        $create->image = $img;
          }
   
    $create->panel_id = '1';
    $create->created_by = $user_id;
    $create->user_id = $user_id;
    $create->token = reandum_code('50');
    $create->ip = CurrentTimestamp()['ip'];
    $create->strtotime = CurrentTimestamp()['strtotime'];
    $create->created_at = CurrentTimestamp()['datetime'];
    $create->updated_at = CurrentTimestamp()['datetime'];
    $create->save();
    $after = json_encode($create);
    $before = json_encode($create);
    $adduser=$create->id;
    insertLogsAPI($user_id,'1','Testimonial Add','26','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(2,1,'Testimonial');
    return redirect()->back()->with($message['status'],$message['message']);
     }
    $website=Websitesetting::where('id','1')->first();
    $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
    return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
}




function testimonialajax(Request $request){
    $draw   = $request->draw ?? 1;
    $start  = $request->start ?? 0;  
    $length = $request->length ?? 10;

    $columnIndex = isset($request->order[0]['column']) ? $request->order[0]['column'] : 0;
    $columnName  = isset($request->columns[$columnIndex]['data']) ? $request->columns[$columnIndex]['data'] : 'id';
    $columnSortOrder = isset($request->order[0]['dir']) ? $request->order[0]['dir'] : 'desc';
    $filltersearchValue = isset($request->columns[$columnIndex]['search']['value']) ? $request->columns[$columnIndex]['search']['value'] : '';
    $searchValue = $request->search['value'] ?? '';

    $user_id = session('SUPERADMIN_ID');


    if($user_id=='1'){
        
        $housesurveydata = Testimonial::testimonialajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start);
        $housesurveycount = Testimonial::testimonialajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start);
    }else{
        $housesurveydata = Testimonial::testimonialajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start);
        $housesurveycount = Testimonial::testimonialajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start);   
    }
  
    $i = 1;
    $data = array();
    $user_id = session('SUPERADMIN_ID');
         
    foreach ($housesurveydata as $row) {
        $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';
        $action .= '<li class="list-unstyled" style="margin: 0;"> ';
        if(permission($user_id,'26','action_edit')){
            $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/testimonialedit/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                </a>';
        }
        $action .= '   </li>';

        $action .= '<li class="list-unstyled " style="margin: 0;">';
        if(permission($user_id,'26','action_delete')){
            $action .= '<a href="' . asset('backend/testimonialdelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                        <i class="fadeIn animated bx bx-trash anji me-0"></i>
                    </a>';
        }
        $action .= '</li>';
        $action .= '</ul>';

        $status = '<div class="toggle-flip" style="margin-left: 4px;">
            <input
                type="checkbox"
                id="flip' . $row->id . '"
                name="status"
                class="status-toggle"
                data-id="' . $row->id . '"
                onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
            <label class="flip-label" for="flip' . $row->id . '"></label>
        </div>';

        $data[] = array(
            "id" => $row->id,
            "name"=>$row->name,
            "image" => '<a href="' . asset('uploads/testimonial/' . $row->image) . '" data-fancybox="images" data-caption=""><img src="' . asset('uploads/testimonial/' . $row->image) . '" style=" width: 36px;"></a>',
            "designation"=>$row->designation,
    	    "rating"=>$row->rating,
         	"description"=>$row->description,
            "status" => $status,
            "action" => $action
        );
    }
    
    $canViewGlobal = permission($user_id, '26', 'action_globle_view');
    $canAccessCity = permission($user_id, '26', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($user_id == '1') {
        $query = DB::table('testimonials')->orderBy('id', 'ASC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('testimonials')->orderBy('id', 'ASC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('testimonials')->where('user_id', $user_id)->orderBy('id', 'ASC');
    } else {
        $query = DB::table('testimonials')->where('user_id', $user_id)->orderBy('id', 'ASC');
    }

    $tot_rows = $query->count();
    
    $datas = array(
        "draw" => $draw,
        "recordsTotal" => $tot_rows,
        "recordsFiltered" => $housesurveycount,
        "data" => $data
    );
    
    echo json_encode($datas);
}


 public function testimonialupdate(Request $request)
{
     $id=Crypt::decrypt($request->id);
    $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '26', 'action_edit');
     if ($hasPermission) { 
         
         $existingMobile = Testimonial::where('name', $request->name)->where('id', '!=', $id)->first();
    if ($existingMobile) {
        $message = fleshmessage(6,1,'name');
        return redirect()->back()->with($message['status'],$message['message']);
    } 
   
    $update = Testimonial::where('id',$id)->first();
    $before = json_encode($update);
    $update->name = $request->name;
    $update->designation = $request->designation;
    $update->description = $request->description;
    $update->rating = $request->rating;
 
if ($request->hasFile('image')) {
    if ($update->image && file_exists(public_path('uploads/testimonial/' . $update->image))) {
        unlink(public_path('uploads/testimonial/' . $update->image));
    }
    $imgName = time() . '_' . uniqid() . '.' . $request->image->extension();
    $request->image->move(public_path('uploads/testimonial/'), $imgName);
    $update->image = $imgName;
}



   
    $update->panel_id = '1';
    $update->created_by = $user_id;
    $update->user_id = $user_id;
    $update->ip = CurrentTimestamp()['ip'];
    $update->strtotime = CurrentTimestamp()['strtotime'];
    $update->created_at = CurrentTimestamp()['datetime'];
    $update->updated_at = CurrentTimestamp()['datetime'];
    $update->save();
    $after = json_encode($update);
    $adduser=$update->id;
    insertLogsAPI($user_id,'3','Testimonial Update','26','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(3,1,'Testimonial');
    return redirect(url('backend/features/testimonial'))->with($message['status'],$message['message']);

     }
}
  



   function testimonialedit(Request $request){
     $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '26', 'action_edit');
     if ($hasPermission) {
        $id=Crypt::decrypt($request->id);
     $data['testimonial']= Testimonial::where('id',$id)->first();
      return view('backend.features.testimonialedit',$data);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
        }

function testimonialdelete(Request $request,$id){
        $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '26', 'action_delete');
     if ($hasPermission) { 
      $id=Crypt::decrypt($id);
      $delete = Testimonial::findOrFail($id);
      $image_path = public_path("uploads/testimonial/{$delete->image}");
         if (File::exists($image_path) && !File::isDirectory($image_path)) {
        unlink($image_path);
        }
     $delete->delete();
     $after = json_encode($delete);
     $before = json_encode($delete);
     $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Testimonial Delete','26','',$adduser,'','',$after,$before,''); 

    $message = fleshmessage(4,1,'Testimonial');
    return redirect()->back()->with($message['status'],$message['message']);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
        
    }


    public function testimonialstatus(Request $request) {
    $id = $request->id;
    $status = Testimonial::find($id);
    if (!$status) {
        return response()->json(['success' => false, 'message' => 'Testimonial not found'], 404);
    }
    $status->status = (string) $request->status;
    $status->save();
    return response()->json(['success' => true]);
}
    
}
