<?php

namespace App\Http\Controllers\backend\features;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\superadmin;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\File;
use App\Models\Websitesetting;
use App\Models\Service;
use App\Models\Subservice;
use Crypt;
use Session;
use App\Models\Slider;
class SliderController extends Controller
{
    function slider(){
            $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }

    $user_id = session('SUPERADMIN_ID');


    $hasPermission = permission($user_id, '18', 'action_view');
    if ($hasPermission) { 
        $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
        $data['services'] = Service::where('status', '1')->get();
        insertLogsAPI($user_id, '2', 'Slider View', '18', '', '', '', '', '', '', ''); 
        return view('backend.features.slider',$data);
    }

    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }
    
 function slideredit(Request $request){
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '18', 'action_edit');
        if ($hasPermission) { 
        $id=Crypt::decrypt($request->id);
        $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
        $data['services'] = Service::where('status', '1')->get();
        $data['slider']=Slider::where('id',$id)->first();
        return view('backend.features.slideredit',$data);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }


    function slidercreate(Request $request){
    $user_id = session('SUPERADMIN_ID');
    $existingMobile = Slider::where('title', $request->title)->first();
    if ($existingMobile) {
    $message = fleshmessage(6,1,'Title');
        return redirect()->back()->with($message['status'],$message['message']);
    }
    $hasPermission = permission($user_id, '18', 'action_add');
    if ($hasPermission) { 
    $create = new Slider();
    $create->service_id = $request->service_id;
    $create->subservice_id = $request->subservice_id;
    $create->title = $request->title;
    $create->tagline = $request->tagline;
    $create->ordering_by = $request->ordering_by;
    $create->button_name = $request->button_name;
    $create->button_url = $request->button_url;
    $create->country = $request->country;
    $create->state = $request->state;
    $create->city = $request->city;
    $create->image_description = $request->image_description;
    if ($request->image) {
        $img = time() . 'image.' . $request->image->extension();
        $request->image->move(public_path('uploads/slider'), $img);
        $create->image = $img;
    }
    $create->user_id = $user_id;
    $create->created_by=$user_id;
    $create->panel_id='1';
    $create->tokan=reandum_code('50');

    // Assuming CurrentTimestamp() returns an array with 'ip' and 'strtotime'
    $timestampData = CurrentTimestamp();
    $create->ip = $timestampData['ip'];
    $create->strtotime = CurrentTimestamp()['strtotime'];
    $create->created_at = CurrentTimestamp()['datetime'];
    $create->updated_at = CurrentTimestamp()['datetime'];

    $create->save();
    $after = json_encode($create);
    $before = json_encode($create);
    $adduser = $create->id;

    insertLogsAPI($user_id, '1', 'Slider Add', '18', '', $adduser, '', '', $after, $before, '');
    $message = fleshmessage(2,1,'Slider');
    return redirect()->back()->with($message['status'],$message['message']);
    }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }



function sliderupdate(Request $request) {
    $id = Crypt::decrypt($request->id);
    $user_id = session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '18', 'action_edit');
    if ($hasPermission) { 
    $existingMobile = Slider::where('title', $request->title)->where('id', '!=', $id)->first();
    if ($existingMobile) {
        $message = fleshmessage(6,1,'Title');
        return redirect()->back()->with($message['status'],$message['message']);
    }
    $update = Slider::findOrFail($id);
    $before = json_encode($update);

    $update->service_id = $request->service_id;
    $update->subservice_id = $request->subservice_id;
    $update->title = $request->title;
    $update->tagline = $request->tagline;
    $update->ordering_by = $request->ordering_by;
    $update->button_name = $request->button_name;
    $update->button_url = $request->button_url;
    $update->country = $request->country;
    $update->state = $request->state;
    $update->city = $request->city;
    $update->image_description = $request->image_description;
    
    if ($request->hasFile('image')) {
    if ($update->image && file_exists(public_path('uploads/slider/' . $update->image))) {
            unlink(public_path('uploads/slider/' . $update->image));
    }
        $imgName = time() . 'image.' . $request->image->extension();
        $request->image->move(public_path('uploads/slider'), $imgName);
        $update->image = $imgName;
    }
        
    $update->user_id = $user_id;
    $update->created_by=$user_id;
    $update->panel_id='1';

    $update->ip = CurrentTimestamp()['ip'];
    $update->strtotime = CurrentTimestamp()['strtotime'];
    $update->created_at = CurrentTimestamp()['datetime'];
    $update->updated_at = CurrentTimestamp()['datetime'];

    $update->save();
    $after = json_encode($update);
    $adduser=$update->id;
    insertLogsAPI($user_id,'3','Slider Update','18','',$adduser,'','',$after,$before); 
    $message = fleshmessage(3, 1, 'Slider');
    return redirect(url('backend/features/slider'))->with($message['status'], $message['message']);
    }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
}

    
      function sliderajax(Request $request){
   $draw   = $request->draw ?? 0;
    $rows   = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? null;
    $searchValue = $request->search['value'] ?? null;
    
   $user_id = session('SUPERADMIN_ID');
    if($user_id=='1'){
   

    $sliderdata = Slider::sliderajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length);
    $slidercount = Slider::sliderajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length);
    }else{
       $sliderdata = Slider::sliderajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$user_id);
    $slidercount = Slider::sliderajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$user_id);   
    }
     
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($sliderdata as $row) {
   $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  

    // Edit Button
    $action .= '<li class="list-unstyled" style="margin: 0;"> ';
   if(permission($user_id,'18','action_edit')){
                 $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/slideredit/' . Crypt::encrypt($row->id)) . '">
                        <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                    </a>';
                    }
  
              $action .= '   </li>';

   

    $action .= '<li class="list-unstyled">';
      if(permission($user_id,'18','action_delete')){
    $action .= '<a href="' . asset('backend/sliderdelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>';
      }
    $action .= '</li>';


    $action .= '</ul>';




    
    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
   $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
        onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
    <label class="flip-label" for="flip' . $row->id . '"></label>
</div>';
     
// Service
$service = Service::where('id', $row->service_id)->first();
if (!empty($service)) {
    $Services = '<span class="badge servicecolor" style="background:#5D3FD3;">' . e($service->title) . '</span>';
} else {
    $Services = '';
}

// Subservice
$subservice = Subservice::where('id', $row->subservice_id)->first();
if (!empty($subservice)) {
    $Subservice = '<br><span class="badge subservicecolor" style="background:#E91E63;">' . e($subservice->title) . '</span>';
} else {
    $Subservice = '';
}

 

   
     $data[] = array(
    "id" => $row->id, 
    "ordering_by" => $row->ordering_by,
     "service" => $Services.$Subservice,
    "title" => $row->title,
    "tagline" => $row->tagline,
    "image" => '<a href="' . asset('uploads/slider/' . $row->image) . '" data-fancybox="images" data-caption=""><img src="' . asset('uploads/slider/' . $row->image) . '" style=" width: 36px;"></a>',
    "button_name" => $row->button_name,
    "button_url" => $row->button_url,
    "status" => $status,
    "action" => $action
);

    
    }
    
 $canViewGlobal = permission($user_id, '18', 'action_globle_view');
$canAccessCity = permission($user_id, '18', 'action_globle_city');

$city = superadmin::where('id', $user_id)->first();
$globle = $city->global_city ?? 0;





if ($user_id == '1') {
    $query = DB::table('sliders')->orderBy('ordering_by', 'ASC');

} elseif ($globle == 1 && $canViewGlobal) {
    $query = DB::table('sliders')->orderBy('ordering_by', 'ASC');

} elseif ($globle == 1 && $canAccessCity) {
    $query = DB::table('sliders')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');

} else {
    $query = DB::table('sliders')->where('user_id', $user_id)->orderBy('ordering_by', 'ASC');
}




  
    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $slidercount,
    "data" => $data
    );
    
    echo json_encode($datas);

    
    }
        
public function sliderstatus(Request $request) {
    $id = $request->id;
    $statusstatus = Slider::find($id);
    if (!$statusstatus) {
        return response()->json(['success' => false, 'message' => 'Slider not found'], 404);
    }

    $statusstatus->status = $request->status;
    $statusstatus->save();
    return response()->json(['success' => true]);
}     
function sliderdelete(Request $request,$id){
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '18', 'action_delete');
        if ($hasPermission) { 
      $id=Crypt::decrypt($id);
   
        $delete = Slider::findOrFail($id);
        $delete->delete();
     $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Slider Delete','18','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(4,1,'Slider');
    return redirect()->back()->with($message['status'],$message['message']);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
   
        
    }
}
